/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import org.scilab.modules.helptools.scilab.AbstractScilabCodeHandler;
import org.scilab.modules.scinotes.ScilabContext;
import org.scilab.modules.scinotes.ScilabEditorKit;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabLexer;

public class HTMLCodeConverter
extends AbstractScilabCodeHandler {
    protected StringBuilder buffer = new StringBuilder(8192);
    protected ScilabContext ctx;
    protected org.scilab.modules.helptools.scilab.ScilabLexer lexer;
    protected boolean printLineNumber;
    protected int lineNumber = 1;

    public HTMLCodeConverter(ScilabEditorPane scilabEditorPane) {
        this.ctx = ((ScilabEditorKit)scilabEditorPane.getEditorKit()).getStylePreferences();
        this.lexer = new org.scilab.modules.helptools.scilab.ScilabLexer(ScilabLexer.commands, ScilabLexer.macros);
    }

    public String convert(String string, boolean bl) {
        this.printLineNumber = bl;
        this.buffer.setLength(0);
        this.buffer.append("<pre style=\"font-family:" + this.ctx.tokenFonts[0].getFamily() + ";font-style:normal;font-size:" + Float.toString(this.ctx.tokenFonts[0].getSize2D()) + ";\">");
        if (bl) {
            String string2 = "font-family:" + this.ctx.tokenFonts[0].getFamily() + ";font-size:" + Float.toString(this.ctx.tokenFonts[0].getSize2D() * 9.0f / 14.0f) + ";";
            this.buffer.append("<span style=\"" + string2 + "\">" + this.getStringInt(this.lineNumber++) + "</span>  ");
        }
        return this.lexer.convert((AbstractScilabCodeHandler)this, string) + "</pre>";
    }

    public String convertColor(Color color) {
        return "color:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");";
    }

    public String convertFont(Font font) {
        Object object = "";
        if (font.isBold()) {
            object = (String)object + "font-weight:bold;";
        }
        if (font.isItalic()) {
            object = (String)object + "font-style:italic;";
        }
        return object;
    }

    public String convertAttrib(int n) {
        Object object = "";
        if ((n & 1) != 0) {
            object = (String)object + "text-decoration:underline;";
        }
        if ((n & 2) != 0) {
            object = (String)object + "text-decoration:line-through;";
        }
        return object;
    }

    public String convertTokenStyle(int n, String string) {
        return "<span style=\"" + this.convertColor(this.ctx.tokenColors[n]) + this.convertFont(this.ctx.tokenFonts[n]) + this.convertAttrib(this.ctx.tokenAttrib[n]) + "\">" + string + "</span>";
    }

    public void handleDefault(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(0, string));
    }

    public void handleOperator(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(1, string));
    }

    public void handleOpenClose(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(11, string));
    }

    public void handleFKeywords(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(14, string));
    }

    public void handleSKeywords(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(2, string));
    }

    public void handleCKeywords(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(4, string));
    }

    public void handleConstants(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(5, string));
    }

    public void handleCommand(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(15, string));
    }

    public void handleMacro(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(16, string));
    }

    public void handleFunctionId(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(17, string));
    }

    public void handleFunctionIdDecl(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(17, string));
    }

    public void handleId(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(6, string));
    }

    public void handleInputOutputArgsDecl(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(27, string));
    }

    public void handleInputOutputArgs(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(27, string));
    }

    public void handleNumber(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(7, string));
    }

    public void handleSpecial(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(8, string));
    }

    public void handleString(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(12, string));
    }

    public void handleNothing(String string) throws IOException {
        if (string.equals("\n") && this.printLineNumber) {
            String string2 = "font-family:" + this.ctx.tokenFonts[0].getFamily() + ";font-size:" + Float.toString(this.ctx.tokenFonts[0].getSize2D() * 9.0f / 14.0f) + ";";
            this.buffer.append("\n<span style=\"" + string2 + "\">" + this.getStringInt(this.lineNumber++) + "</span>  ");
        } else {
            this.buffer.append(string);
        }
    }

    public void handleField(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(18, string));
    }

    public void handleComment(String string) throws IOException {
        this.buffer.append(this.convertTokenStyle(13, string));
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String getStringInt(int n) {
        if (n < 10) {
            return "000" + n;
        }
        if (n < 100) {
            return "00" + n;
        }
        if (n < 1000) {
            return "0" + n;
        }
        return Integer.toString(n);
    }
}

