/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.io.IOException;
import org.scilab.modules.helptools.scilab.AbstractScilabCodeHandler;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.utils.HTMLCodeConverter;

public class FOCodeConverter
extends HTMLCodeConverter {
    private static final String ENTETE = "<?xml version=\"1.0\"?>\n<root xmlns=\"http://www.w3.org/1999/XSL/Format\">\n<layout-master-set>\n<simple-page-master master-name=\"content\"\nmargin-right=\"MRin\"\nmargin-left=\"MLin\"\nmargin-bottom=\"MBin\"\nmargin-top=\"MTin\"\npage-width=\"PWin\"\npage-height=\"PHin\">\n<region-body/>\n</simple-page-master>\n</layout-master-set>\n<page-sequence master-reference=\"content\">\n<flow flow-name=\"xsl-region-body\">";
    private static final String END = "</flow></page-sequence></root>";
    private int[] lineNumberArray;

    public FOCodeConverter(ScilabEditorPane scilabEditorPane) {
        super(scilabEditorPane);
    }

    public String convert(String string, int[] nArray, PageFormat pageFormat) {
        this.printLineNumber = nArray != null;
        this.lineNumberArray = nArray;
        this.buffer.setLength(0);
        Font font = this.ctx.tokenFonts[0];
        double d = pageFormat.getImageableX() / 72.0;
        double d2 = (pageFormat.getWidth() - pageFormat.getImageableWidth()) / 72.0 - d;
        double d3 = pageFormat.getImageableY() / 72.0;
        double d4 = (pageFormat.getHeight() - pageFormat.getImageableHeight()) / 72.0 - d3;
        double d5 = pageFormat.getWidth() / 72.0;
        double d6 = pageFormat.getHeight() / 72.0;
        String string2 = ENTETE.replace("MR", Double.toString(d2)).replace("ML", Double.toString(d)).replace("MT", Double.toString(d3)).replace("MB", Double.toString(d4)).replace("PW", Double.toString(d5)).replace("PH", Double.toString(d6));
        this.buffer.append(string2);
        this.buffer.append("<block white-space-treatment=\"preserve\" linefeed-treatment=\"preserve\" white-space-collapse=\"false\" hyphenate=\"false\" wrap-option=\"wrap\" font-family=\"" + font.getFamily() + "\" font-size=\"" + Float.toString(font.getSize2D() * 9.0f / 14.0f) + "pt\">");
        if (this.printLineNumber) {
            String string3 = "color=\"rgb(127,127,127)\" font-family=\"" + this.ctx.tokenFonts[0].getFamily() + "\" font-size=\"" + Float.toString(this.ctx.tokenFonts[0].getSize2D() * 9.0f / 14.0f) + "\"";
            this.buffer.append("<inline " + string3 + ">" + this.getStringInt(this.lineNumber++) + "</inline>  ");
        }
        return this.lexer.convert((AbstractScilabCodeHandler)this, string) + "</block>\n</flow></page-sequence></root>";
    }

    @Override
    public String convertColor(Color color) {
        return " color=\"rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\" ";
    }

    @Override
    public String convertFont(Font font) {
        Object object = "";
        if (font.isBold()) {
            object = (String)object + "font-weight=\"bold\" ";
        }
        object = font.isItalic() ? (String)object + "font-style=\"italic\" " : (String)object + "font-style=\"normal\" ";
        return object;
    }

    @Override
    public String convertAttrib(int n) {
        Object object = "";
        if ((n & 1) != 0) {
            object = (String)object + " text-decoration=\"underline\" ";
        }
        if ((n & 2) != 0) {
            object = (String)object + " text-decoration=\"line-through\" ";
        }
        return object;
    }

    @Override
    public String convertTokenStyle(int n, String string) {
        return "<inline " + this.convertColor(this.ctx.tokenColors[n]) + this.convertFont(this.ctx.tokenFonts[n]) + this.convertAttrib(this.ctx.tokenAttrib[n]) + ">" + string + "</inline>";
    }

    @Override
    public void handleNothing(String string) throws IOException {
        if (string.equals("\n") && this.printLineNumber) {
            String string2 = "color=\"rgb(127,127,127)\" font-family=\"" + this.ctx.tokenFonts[0].getFamily() + "\" font-size=\"" + Float.toString(this.ctx.tokenFonts[0].getSize2D() * 9.0f / 14.0f) + "\"";
            this.buffer.append("\n<inline " + string2 + ">" + this.getStringInt(this.lineNumber++) + "</inline>  ");
        } else {
            this.buffer.append(string);
        }
    }

    @Override
    public String getStringInt(int n) {
        return super.getStringInt(this.lineNumberArray[n - 1]);
    }
}

