/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.actions.DefaultAction;

public final class CapitalizeAction
extends DefaultAction {
    private static final long serialVersionUID = 1531881688147993338L;

    public CapitalizeAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        int n;
        ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        int n2 = scilabEditorPane.getSelectionStart();
        if (n2 == (n = scilabEditorPane.getSelectionEnd())) {
            try {
                String string = scilabDocument.getText(n2, 1);
                char c = string.charAt(0);
                String string2 = Character.isUpperCase(c) ? string.toLowerCase() : string.toUpperCase();
                scilabDocument.mergeEditsBegin();
                scilabDocument.getUndoManager().enableOneShot(true);
                scilabEditorPane.select(n2, n2 + 1);
                scilabEditorPane.replaceSelection(string2);
                scilabDocument.mergeEditsEnd();
                scilabDocument.getUndoManager().enableOneShot(false);
            }
            catch (BadLocationException badLocationException) {}
        } else {
            String string = scilabEditorPane.getSelectedText();
            boolean bl = true;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (Character.isLetter(c)) {
                    if (!bl) continue;
                    cArray[i] = Character.isLowerCase(c) ? Character.toUpperCase(c) : Character.toLowerCase(c);
                    bl = false;
                    continue;
                }
                bl = true;
            }
            scilabDocument.mergeEditsBegin();
            scilabEditorPane.replaceSelection(new String(cArray));
            scilabEditorPane.select(n2, n);
            scilabDocument.mergeEditsEnd();
        }
    }

    public static MenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";\uff1b");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        return CapitalizeAction.createMenu(string2, string3, sciNotes, keyStroke, new CapitalizeAction(string2, sciNotes));
    }

    protected static MenuItem createMenu(final String string, final String string2, final SciNotes sciNotes, KeyStroke keyStroke, CapitalizeAction capitalizeAction) {
        final MenuItem menuItem = CapitalizeAction.createMenu(string, null, capitalizeAction, keyStroke);
        ((JMenuItem)menuItem.getAsSimpleMenuItem()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (sciNotes.getTextPane() != null) {
                    String string3 = sciNotes.getTextPane().getSelectedText();
                    if (string3 == null) {
                        menuItem.setText(string2);
                    } else {
                        menuItem.setText(string);
                    }
                }
            }
        });
        return menuItem;
    }
}

