/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.scilab.modules.scinotes.IndentManager;
import org.scilab.modules.scinotes.IndentScanner;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabDocument;

public class TabManager {
    private static final String EOL = "\n";
    private String tab;
    private int lengthTab;
    private ScilabDocument doc;
    private Element elem;
    private IndentManager indent;
    private boolean isTabInsertable = true;

    public TabManager(ScilabDocument scilabDocument, IndentManager indentManager) {
        this.doc = scilabDocument;
        this.elem = scilabDocument.getDefaultRootElement();
        this.indent = indentManager;
        this.setTabulation(' ', 3);
    }

    public void setTabulation(char c, int n) {
        if (c == ' ') {
            this.tab = " ";
            this.lengthTab = n;
        } else {
            this.tab = "\t";
            this.lengthTab = 1;
        }
        this.doc.putProperty("tabSize", new Integer(Math.max(n, 1)));
        if (this.indent != null) {
            this.indent.setProperties(c, SciNotesOptions.getSciNotesDisplay().indentSize);
        }
    }

    public String getTabulationString(int n) {
        if (this.tab.equals(" ")) {
            Element element = this.elem.getElement(this.elem.getElementIndex(n));
            int n2 = n - element.getStartOffset();
            int n3 = this.lengthTab - n2 % this.lengthTab;
            if (n3 == 0) {
                n3 = this.lengthTab;
            }
            char[] cArray = new char[n3];
            for (int i = 0; i < n3; ++i) {
                cArray[i] = 32;
            }
            return new String(cArray);
        }
        return this.tab;
    }

    public String getBasicTabulationString() {
        if (this.tab.equals(" ")) {
            char[] cArray = new char[this.lengthTab];
            for (int i = 0; i < this.lengthTab; ++i) {
                cArray[i] = 32;
            }
            return new String(cArray);
        }
        return this.tab;
    }

    public void setTabulation(Tabulation tabulation) {
        this.setTabulation(tabulation.tab, tabulation.number);
    }

    public void setDefaultTabulation() {
        this.setTabulation(new Tabulation());
    }

    public void setTabInsertable(boolean bl) {
        this.isTabInsertable = bl;
    }

    public String getTabulation() {
        return this.tab;
    }

    public int insertTab(int n) {
        try {
            if (this.isTabInsertable) {
                String string = this.getTabulationString(n);
                this.doc.insertString(n, string, null);
                return string.length();
            }
            this.tabifyLines(n, n - 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return this.lengthTab;
    }

    public int[] tabifyLines(int n, int n2) {
        Element element = this.elem.getElement(this.elem.getElementIndex(n));
        int n3 = element.getStartOffset();
        int[] nArray = new int[]{0, 0};
        int n4 = n2;
        try {
            Object object = this.doc.getText(n3, n4 - n3 + 1);
            if (((String)object).charAt(((String)object).length() - 1) == EOL.charAt(0)) {
                --n4;
                object = ((String)object).substring(0, ((String)object).length() - 1);
                nArray[1] = nArray[1] + 1;
            }
            String string = this.getTabulationString(n);
            String string2 = this.getTabulationString(0);
            String string3 = EOL + string2;
            object = string + ((String)object).replaceAll(EOL, string3);
            nArray[0] = n + string.length();
            nArray[1] = nArray[1] + (n3 + ((String)object).length());
            this.doc.replace(n3, n4 - n3 + 1, (String)object, null);
            return nArray;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int removeTab(int n) {
        try {
            if (this.isTabInsertable) {
                int n2 = Math.max(0, n - this.lengthTab);
                if (!this.tab.equals(this.doc.getText(n2, this.lengthTab))) return 0;
                this.doc.remove(n2, this.lengthTab);
                return this.lengthTab;
            } else {
                this.untabifyLine(n);
            }
            return this.lengthTab;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return this.lengthTab;
    }

    public void untabifyLine(int n) {
        IndentScanner indentScanner = this.indent.getIndentScanner();
        int n2 = this.elem.getElementIndex(n);
        int n3 = indentScanner.getTabsAtBeginning(n2);
        try {
            if (n3 >= this.lengthTab) {
                this.doc.remove(this.elem.getElement(n2).getStartOffset(), this.lengthTab);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public int[] untabifyLines(int n, int n2) {
        int n3 = this.elem.getElement(this.elem.getElementIndex(n)).getStartOffset();
        int[] nArray = new int[2];
        nArray[0] = n;
        try {
            String string = this.doc.getText(n3, n2 - n3 + 1);
            String string2 = EOL + this.getBasicTabulationString();
            string = string.replaceAll(string2, EOL);
            IndentScanner indentScanner = this.indent.getIndentScanner();
            int n4 = indentScanner.getTabsAtBeginning(this.elem.getElementIndex(n3));
            if (n4 >= this.lengthTab) {
                string = string.substring(this.lengthTab);
                if (n - n3 + 1 >= this.lengthTab) {
                    nArray[0] = n - this.lengthTab;
                }
            }
            nArray[1] = n3 + string.length();
            this.doc.replace(n3, n2 - n3 + 1, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
        return nArray;
    }

    public static class Tabulation {
        public char tab;
        public int number;
        public int type;
        public char rep;

        public Tabulation(char c, int n, int n2, char c2) {
            this.tab = c;
            this.number = n;
            this.type = n2;
            this.rep = c2;
        }

        public Tabulation() {
            this.tab = (char)(SciNotesOptions.getSciNotesDisplay().useSpaces ? 32 : 9);
            this.number = SciNotesOptions.getSciNotesDisplay().tabSize;
            this.type = SciNotesOptions.getSciNotesDisplay().tabRepresentation;
            this.rep = (char)32;
        }
    }
}

