/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.ViewFactory;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabContext;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.actions.EncodingAction;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class ScilabEditorKit
extends DefaultEditorKit {
    private static final long serialVersionUID = 8005575461386086815L;
    public static final String MIMETYPE = "text/scilab";
    private static final int BUFFERCAPACITY = 8192;
    public static final String[] ENCODINGS = new String[]{"utf-8", "windows-1252", "iso-8859-1"};
    private static final Map<String, Integer> encPos = new HashMap<String, Integer>(ENCODINGS.length);
    private final char[] buffer = new char[8192];
    private ScilabContext preferences;
    private boolean plain;

    public ScilabEditorKit() {
    }

    public ScilabEditorKit(boolean bl) {
        this.plain = bl;
    }

    public boolean isPlain() {
        return this.plain;
    }

    @Override
    public String getContentType() {
        return MIMETYPE;
    }

    @Override
    public Document createDefaultDocument() {
        return new ScilabDocument();
    }

    public ScilabContext getStylePreferences() {
        if (this.preferences == null) {
            this.preferences = new ScilabContext(this.plain);
        }
        return this.preferences;
    }

    public void setStylePreferences(ScilabContext scilabContext) {
        this.preferences = scilabContext;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.getStylePreferences();
    }

    public static Charset tryToGuessEncoding(File file) throws IOException, CharacterCodingException {
        for (int i = 0; i < ENCODINGS.length; ++i) {
            if (!ScilabEditorKit.tryToGuessEncoding(file, Charset.forName(ENCODINGS[i]))) continue;
            return Charset.forName(ENCODINGS[i]);
        }
        throw new CharacterCodingException();
    }

    /*
     * Exception decompiling
     */
    public static boolean tryToGuessEncoding(File var0, Charset var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void read(SciNotes sciNotes, File file, Document document, int n) throws IOException, BadLocationException {
        Charset charset = Charset.forName(SciNotesOptions.getSciNotesPreferences().encoding);
        try {
            charset = ScilabEditorKit.tryToGuessEncoding(file);
        }
        catch (CharacterCodingException characterCodingException) {
            ScilabModalDialog.show((SimpleTab)sciNotes, (String)SciNotesMessages.CANNOT_GUESS_ENCODING, (String)SciNotesMessages.SCINOTES_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
        }
        ((ScilabDocument)document).setEncoding(charset.toString());
        EncodingAction.updateEncodingMenu((ScilabDocument)document);
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            this.read(bufferedReader, document, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        DocString docString = this.read(reader);
        ((ScilabDocument)document).setEOL(docString.eol);
        ((ScilabDocument)document).setBinary(docString.isBinary);
        document.insertString(n, docString.content, null);
    }

    public DocString read(Reader reader) throws IOException {
        int n;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        DocString docString = new DocString();
        StringBuilder stringBuilder = new StringBuilder(this.buffer.length);
        while ((n = reader.read(this.buffer, 0, this.buffer.length)) != -1) {
            int n3;
            if (bl3) {
                CharBuffer charBuffer = CharBuffer.wrap(this.buffer);
                byte[] byArray = Charset.forName("utf-8").encode(charBuffer).array();
                for (n3 = 0; n3 < n; ++n3) {
                    if (byArray[n3] != 0 || ++n2 != 2) continue;
                    bl4 = true;
                    break;
                }
                bl3 = false;
            }
            int n4 = 0;
            if (!bl4) {
                for (n3 = 0; n3 < n - 1; ++n3) {
                    if (this.buffer[n3] != '\r') continue;
                    this.buffer[n3] = 10;
                    stringBuilder.append(this.buffer, n4, n3 - n4 + 1);
                    if (this.buffer[n3 + 1] == '\n') {
                        ++n3;
                        if (!bl && !bl2) {
                            docString.eol = "\r\n";
                            bl = true;
                        }
                    } else if (!bl && !bl2) {
                        docString.eol = "\r";
                        bl2 = true;
                    }
                    n4 = n3 + 1;
                }
                if (n3 != n - 1) continue;
                if (this.buffer[n3] == '\r') {
                    if (!bl && !bl2) {
                        docString.eol = "\r";
                    }
                    this.buffer[n3] = 10;
                }
                stringBuilder.append(this.buffer, n4, n3 - n4 + 1);
                continue;
            }
            stringBuilder.append(this.buffer, 0, n);
        }
        if (!bl && !bl2) {
            docString.eol = "\n";
        }
        docString.isBinary = n2 == 2;
        docString.content = stringBuilder.toString();
        return docString;
    }

    static {
        for (int i = 0; i < ENCODINGS.length; ++i) {
            encPos.put(ENCODINGS[i], i);
        }
    }

    public static class DocString {
        public String eol;
        public boolean isBinary;
        public String content;

        DocString() {
        }
    }
}

