/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Color;
import java.text.DateFormat;
import java.util.Calendar;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.xml.ScilabXPathFactory;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.scinotes.SciNotesConfiguration;
import org.w3c.dom.Document;

public class SciNotesOptions {
    public static final String PREFERENCESPATH = "//scinotes/body/scinotes-preferences";
    public static final String DISPLAYPATH = "//scinotes/display/body/scinotes-display";
    public static final String AUTOSAVEPATH = "//scinotes/autosave/body/scinotes-autosave";
    public static final String HEADERPATH = "//scinotes/header/body/scinotes-header";
    public static final String KEYMAPPATH = "//general/shortcuts/body/actions/action-folder[@xconf-uid=\"scinotes\"]/action";
    private static Preferences prefs;
    private static Display display;
    private static Autosave autosave;
    private static Header header;
    private static Document doc;

    public static void invalidate(SciNotesConfiguration.Conf conf) {
        if (conf.preferences) {
            prefs = null;
            doc = null;
        }
        if (conf.display) {
            display = null;
            doc = null;
        }
        if (conf.autosave) {
            autosave = null;
            doc = null;
        }
        if (conf.header) {
            header = null;
            doc = null;
        }
    }

    public static final Preferences getSciNotesPreferences() {
        if (prefs == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            prefs = ((Preferences[])XConfiguration.get(Preferences.class, (Document)doc, (String)PREFERENCESPATH))[0];
        }
        return prefs;
    }

    public static final Display getSciNotesDisplay() {
        if (display == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            display = ((Display[])XConfiguration.get(Display.class, (Document)doc, (String)DISPLAYPATH))[0];
        }
        return display;
    }

    public static final Autosave getSciNotesAutosave() {
        if (autosave == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            autosave = ((Autosave[])XConfiguration.get(Autosave.class, (Document)doc, (String)AUTOSAVEPATH))[0];
        }
        return autosave;
    }

    public static final Header getSciNotesHeader() {
        if (header == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            header = ((Header[])XConfiguration.get(Header.class, (Document)doc, (String)HEADERPATH))[0];
        }
        return header;
    }

    @XConfiguration.XConfAttribute
    public static class Preferences {
        public boolean restartOpen;
        public boolean addLineTermination;
        public int numberOfRecentlyOpen;
        public String encoding;
        public String eol;
        public boolean useScinotes;
        public boolean externalCmd;
        public String cmd;
        public boolean completeAtEOL;

        private Preferences() {
        }

        @XConfiguration.XConfAttribute(tag="scinotes-preferences", attributes={"restart-reopen", "add-line-termination", "number-of-recently-open", "encoding", "eol", "scinotes", "cmd", "external-cmd", "complete-at-eol"})
        private void set(boolean bl, boolean bl2, int n, String string, String string2, boolean bl3, String string3, boolean bl4, boolean bl5) {
            this.restartOpen = bl;
            this.addLineTermination = bl2;
            this.numberOfRecentlyOpen = n > 0 ? n : 1;
            this.encoding = string.toLowerCase();
            if (string2.equals("")) {
                switch (OS.get()) {
                    case WINDOWS: {
                        this.eol = "\r\n";
                        break;
                    }
                    default: {
                        this.eol = "\n";
                        break;
                    }
                }
            } else {
                this.eol = string2.startsWith("Windows") ? "\r\n" : "\n";
            }
            this.useScinotes = bl3;
            this.externalCmd = bl4;
            this.cmd = string3;
            this.completeAtEOL = bl5;
        }
    }

    @XConfiguration.XConfAttribute
    public static class Display {
        public boolean highlightCurrentLine;
        public Color currentLineColor;
        public boolean showLineNumbers;
        public boolean wrapLines;
        public boolean keywordsColorization;
        public boolean highlightBrackets;
        public Color bracketsColor;
        public int bracketsHighlightment;
        public boolean bracketsOnmouseover;
        public boolean highlightKeywords;
        public Color keywordsColor;
        public int keywordsHighlightment;
        public boolean keywordsOnmouseover;
        public boolean whereami;
        public int tabSize;
        public int tabRepresentation;
        public boolean useSpaces;
        public int indentSize;
        public boolean automaticIndent;
        public boolean autoCompleteOpeners;
        public boolean autoCompleteKeywords;
        public Color backgroundColor;
        public Color caretColor;

        private Display() {
        }

        @XConfiguration.XConfAttribute(tag="scinotes-display", attributes={"highlight-current-line", "current-line-color", "show-line-numbers", "wrap-lines", "keywords-colorization", "highlight-brackets", "brackets-color", "brackets-highlightment", "brackets-onmouseover", "highlight-keywords", "keywords-color", "keywords-highlightment", "keywords-onmouseover", "whereami", "tab-size", "tab-representation", "use-spaces", "indent-size", "automatic-indent", "auto-complete-openers", "auto-complete-keywords", "background-color", "caret-color"})
        private void set(boolean bl, Color color, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Color color2, String string, boolean bl6, boolean bl7, Color color3, String string2, boolean bl8, boolean bl9, int n, String string3, boolean bl10, int n2, boolean bl11, boolean bl12, boolean bl13, Color color4, Color color5) {
            this.highlightCurrentLine = bl;
            this.currentLineColor = color;
            this.showLineNumbers = bl2;
            this.wrapLines = bl3;
            this.keywordsColorization = bl4;
            this.highlightBrackets = bl5;
            this.bracketsColor = color2;
            this.bracketsOnmouseover = bl6;
            this.highlightKeywords = bl7;
            this.keywordsColor = color3;
            this.keywordsOnmouseover = bl8;
            this.whereami = bl9;
            this.tabSize = n;
            this.tabRepresentation = string3.equalsIgnoreCase("chevrons") ? 1 : (string3.equalsIgnoreCase("hrule") ? 2 : (string3.equalsIgnoreCase("vrule") ? 0 : 4));
            this.useSpaces = bl10;
            this.indentSize = n2;
            this.automaticIndent = bl11;
            this.bracketsHighlightment = string.equalsIgnoreCase("filled") ? 0 : (string.equalsIgnoreCase("framed") ? 2 : 1);
            this.keywordsHighlightment = string2.equalsIgnoreCase("filled") ? 0 : (string2.equalsIgnoreCase("framed") ? 2 : 1);
            this.autoCompleteOpeners = bl12;
            this.autoCompleteKeywords = bl13;
            this.backgroundColor = color4;
            this.caretColor = color5;
        }
    }

    @XConfiguration.XConfAttribute
    public static class Autosave {
        public boolean autoSave;
        public int saveEvery;
        public boolean automaticDelete;
        public boolean appendFilename;
        public String appendWith;
        public String replaceWith;
        public boolean sourceFlag;
        public String singleDirectory;

        private Autosave() {
        }

        @XConfiguration.XConfAttribute(tag="scinotes-autosave", attributes={"enable", "save-every", "automatic-delete", "append-filename", "append-with", "replace-with", "source-flag", "single-directory"})
        private void set(boolean bl, int n, boolean bl2, boolean bl3, String string, String string2, boolean bl4, String string3) {
            this.autoSave = bl;
            this.saveEvery = n;
            this.automaticDelete = bl2;
            this.appendFilename = bl3;
            this.appendWith = string;
            this.replaceWith = string2;
            this.sourceFlag = bl4;
            this.singleDirectory = string3;
        }
    }

    @XConfiguration.XConfAttribute
    public static class Header {
        public String header;
        public boolean enable;

        @XConfiguration.XConfAttribute(tag="scinotes-header", attributes={"enable"})
        private void set(boolean bl) {
            this.enable = bl;
            if (bl) {
                XPathFactory xPathFactory = ScilabXPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                try {
                    this.header = (String)xPath.compile("string(//scinotes/header/body/scinotes-header)").evaluate(doc, XPathConstants.STRING);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    System.err.println(xPathExpressionException);
                }
                if (this.header != null) {
                    Calendar calendar = Calendar.getInstance();
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    this.header = this.header.replaceAll("\\{\\$current-year\\}", Integer.toString(calendar.get(1)));
                    this.header = this.header.replaceAll("\\{\\$current-date\\}", dateFormat.format(calendar.getTime()));
                }
            }
        }
    }
}

