/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Timer;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.utils.SaveFile;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class SciNotesAutosave
implements ActionListener {
    private static SciNotesAutosave instance;
    private static Set<File> toRemove;
    private boolean isChecking = false;
    private Object lock = new Object();
    private Timer timer;

    private SciNotesAutosave() {
        this.timer = new Timer(SciNotesOptions.getSciNotesAutosave().saveEvery * 60 * 1000, this);
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public static void autosave() {
        if (SciNotesOptions.getSciNotesAutosave().autoSave) {
            SciNotesAutosave.startAutosave();
        } else {
            SciNotesAutosave.stopAutosave();
        }
    }

    static void startAutosave() {
        if (instance == null && SciNotesOptions.getSciNotesAutosave().autoSave) {
            instance = new SciNotesAutosave();
        }
    }

    static void stopAutosave() {
        if (instance != null) {
            SciNotesAutosave.instance.timer.stop();
            instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isChecking() {
        Object object = this.lock;
        synchronized (object) {
            return this.isChecking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isChecking(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.isChecking = bl;
        }
    }

    private boolean checkSaveDir() {
        this.isChecking(true);
        SciNotesOptions.Autosave autosave = SciNotesOptions.getSciNotesAutosave();
        if (!autosave.singleDirectory.isEmpty()) {
            File file = new File(autosave.singleDirectory);
            if (!file.exists()) {
                if (ScilabModalDialog.AnswerOption.YES_OPTION == ScilabModalDialog.show(null, (String)String.format(SciNotesMessages.NO_EXISTING_DIR, autosave.singleDirectory), (String)SciNotesMessages.AUTOSAVE, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO_CANCEL)) {
                    if (file.mkdir()) {
                        this.isChecking(false);
                        return true;
                    }
                    ScilabModalDialog.show(null, (String)String.format(SciNotesMessages.UNABLE_TO_CREATE_DIR, autosave.singleDirectory), (String)SciNotesMessages.SCINOTES_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
                }
                this.isChecking(false);
                return false;
            }
            if (!file.isDirectory()) {
                ScilabModalDialog.show(null, (String)String.format(SciNotesMessages.NOT_A_DIR, autosave.singleDirectory), (String)SciNotesMessages.SCINOTES_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
                this.isChecking(false);
                return false;
            }
            try {
                File.createTempFile("autosave_test", null, file).delete();
            }
            catch (Exception exception) {
                System.err.println(exception);
                ScilabModalDialog.show(null, (String)String.format(SciNotesMessages.NOT_WRITABLE_DIR, autosave.singleDirectory), (String)SciNotesMessages.SCINOTES_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
                this.isChecking(false);
                return false;
            }
        }
        this.isChecking(false);
        return true;
    }

    public static File getBackupFile(String string) {
        boolean bl;
        SciNotesOptions.Autosave autosave = SciNotesOptions.getSciNotesAutosave();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        Object object = string;
        if (autosave.appendFilename) {
            object = (String)object + autosave.appendWith.replaceAll("%date", simpleDateFormat.format(new Date()));
        } else {
            int n = ((String)object).lastIndexOf(46);
            if (n != -1) {
                object = ((String)object).substring(0, n + 1) + autosave.replaceWith;
            }
        }
        File file = new File((String)object);
        String string2 = file.getName();
        if (!autosave.sourceFlag) {
            file = new File(autosave.singleDirectory, string2);
        }
        if (bl = new File(string).equals(file)) {
            return null;
        }
        return file;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SciNotesOptions.Autosave autosave = SciNotesOptions.getSciNotesAutosave();
        if (!this.isChecking() && autosave.autoSave && this.checkSaveDir()) {
            boolean bl = false;
            for (SciNotes sciNotes : SciNotes.getSciNotesList()) {
                int n = sciNotes.getTabPane().getTabCount();
                for (int i = 0; i < n; ++i) {
                    ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                    if (scilabEditorPane == null || scilabEditorPane.getName() == null || scilabEditorPane.getName().isEmpty() || scilabEditorPane.checkExternalModif() || !((ScilabDocument)scilabEditorPane.getDocument()).isContentModified() || !((ScilabDocument)scilabEditorPane.getDocument()).isContentModifiedSinceBackup()) continue;
                    String string = scilabEditorPane.getName();
                    File file = SciNotesAutosave.getBackupFile(string);
                    boolean bl2 = false;
                    if (file == null) {
                        bl2 = true;
                        file = new File(string);
                    }
                    boolean bl3 = SaveFile.doSave(scilabEditorPane, i, file, sciNotes.getEditorKit(), false, true, false);
                    String string2 = file.getName();
                    if (!bl) {
                        bl = true;
                    }
                    if (!bl3) {
                        sciNotes.getInfoBar().setText(String.format(SciNotesMessages.AUTOSAVE_ERROR, string2));
                        return;
                    }
                    ((ScilabDocument)scilabEditorPane.getDocument()).setContentModifiedSinceBackup(false);
                    if (bl2) {
                        ((ScilabDocument)scilabEditorPane.getDocument()).setContentModified(false);
                        scilabEditorPane.setLastModified(file.lastModified());
                        continue;
                    }
                    if (!autosave.automaticDelete) continue;
                    scilabEditorPane.addToRemove(file);
                }
                if (!bl) continue;
                sciNotes.getInfoBar().setText(SciNotesMessages.AUTOSAVE_FINISHED);
            }
        }
    }

    static {
        toRemove = new HashSet<File>();
    }
}

