/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.scilab.modules.scinotes.ScilabDocument;

public class CommentManager {
    private static final String COM = "//";
    private static final char DEMICOM = '/';
    private static final String EOL = "\n";
    private ScilabDocument doc;
    private Element elem;

    public CommentManager(ScilabDocument scilabDocument) {
        this.doc = scilabDocument;
        this.elem = scilabDocument.getDefaultRootElement();
    }

    public void commentLine(int n) {
        Element element = this.elem.getElement(n);
        int n2 = element.getStartOffset();
        try {
            this.doc.insertString(n2, COM, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return;
        }
    }

    public boolean uncommentLine(int n) {
        Element element = this.elem.getElement(n);
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset() - 1;
        try {
            String string = this.doc.getText(n2, n3 - n2);
            Pattern pattern = Pattern.compile("([ \t]*)//");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                string = matcher.replaceFirst("$1");
                this.doc.replace(n2, n3 - n2, string, null);
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return false;
    }

    public int[] commentLines(int n, int n2) {
        int n3 = this.elem.getElementIndex(n);
        int n4 = this.elem.getElementIndex(n2);
        int[] nArray = new int[]{n, n2};
        for (int i = n3; i <= n4; ++i) {
            this.commentLine(i);
            nArray[1] = nArray[1] + 2;
        }
        nArray[0] = nArray[0] + 2;
        return nArray;
    }

    public void commentText(int n) {
        try {
            this.doc.insertString(n, COM, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public int[] uncommentLines(int n, int n2) {
        int n3 = this.elem.getElementIndex(n);
        int n4 = this.elem.getElementIndex(n2);
        int n5 = this.elem.getElement(n3).getStartOffset();
        int[] nArray = new int[]{n, n2};
        boolean bl = this.uncommentLine(n3);
        if (bl) {
            nArray[0] = nArray[0] - Math.min(n - n5, 2);
            nArray[1] = nArray[1] - 2;
        }
        for (int i = n3 + 1; i <= n4; ++i) {
            bl = this.uncommentLine(i);
            if (!bl) continue;
            nArray[1] = nArray[1] - 2;
        }
        return nArray;
    }

    public void uncommentText(int n) {
        try {
            int n2 = this.elem.getElement(this.elem.getElementIndex(n)).getEndOffset();
            if (n2 - n >= 2 && COM.equals(this.doc.getText(n, 2))) {
                this.doc.remove(n, 2);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }
}

