/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor.actions;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;

public final class PasteAction
extends CommonCallBack {
    private static final String KEY = "OSSCKEY V";
    private static final String PASTE = "Paste";
    private final SwingScilabVariableEditor editor;

    public PasteAction(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        super(string);
        this.editor = swingScilabVariableEditor;
    }

    public static void registerAction(SwingScilabVariableEditor swingScilabVariableEditor, JTable jTable) {
        jTable.getActionMap().put(PASTE, (Action)((Object)new PasteAction(swingScilabVariableEditor, PASTE)));
        jTable.getInputMap().put(ScilabKeyStroke.getKeyStroke((String)KEY), PASTE);
    }

    public void callBack() {
        Vector vector;
        int n;
        JTable jTable = this.editor.getCurrentTable();
        int n2 = jTable.getSelectedColumn();
        int n3 = jTable.getSelectedRow();
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = 0;
        }
        jTable.setColumnSelectionInterval(n2, n2);
        jTable.setRowSelectionInterval(n3, n3);
        String string = "";
        this.editor.setCursor(Cursor.getPredefinedCursor(3));
        try {
            string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents((Object)this).getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.err.println(unsupportedFlavorException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n4 = stringTokenizer.countTokens();
        Vector<Vector> vector2 = new Vector<Vector>(n4);
        NumberFormat numberFormat = NumberFormat.getInstance();
        ParsePosition parsePosition = new ParsePosition(0);
        numberFormat.setParseIntegerOnly(false);
        for (int i = 0; i < n4; ++i) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "\t");
            n = stringTokenizer2.countTokens();
            vector = new Vector(n);
            for (int j = 0; j < n; ++j) {
                String string2 = stringTokenizer2.nextToken();
                Number number = numberFormat.parse(string2, parsePosition);
                if (parsePosition.getIndex() == string2.length()) {
                    vector.addElement(number.toString());
                } else {
                    vector.addElement(string2);
                }
                parsePosition.setIndex(0);
            }
            vector2.addElement(vector);
        }
        SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)jTable.getModel();
        int n5 = swingEditvarTableModel.getScilabMatrixRowCount();
        n = swingEditvarTableModel.getScilabMatrixColCount();
        if (vector2.size() == 1 && ((Vector)vector2.get(0)).size() == 1 && n3 < n5 && n2 < n) {
            swingEditvarTableModel.setValueAtAndUpdate(true, true, ((Vector)vector2.get(0)).get(0), n3, n2);
        } else {
            vector = swingEditvarTableModel.cloneDatas();
            swingEditvarTableModel.setValues(vector2, n3, n2);
            swingEditvarTableModel.updateFullMatrix(vector, n5, n);
        }
    }

    public static JButton createButton(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        JButton jButton = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        jButton.addActionListener((ActionListener)((Object)new PasteAction(swingScilabVariableEditor, string)));
        jButton.setToolTipText(string);
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"edit-paste"));
        jButton.setIcon(imageIcon);
        return jButton;
    }

    public static MenuItem createMenuItem(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback((CommonCallBack)new PasteAction(swingScilabVariableEditor, string));
        menuItem.setText(string);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(ScilabKeyStroke.getKeyStroke((String)KEY));
        return menuItem;
    }

    public static SwingScilabMenuItem createJMenuItem(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        return (SwingScilabMenuItem)PasteAction.createMenuItem(swingScilabVariableEditor, string).getAsSimpleMenuItem();
    }
}

