/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.rowheader.HeaderRenderer;
import org.scilab.modules.ui_data.rowheader.RowHeader;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;
import org.scilab.modules.ui_data.variableeditor.actions.InsertColumnAction;
import org.scilab.modules.ui_data.variableeditor.actions.RemoveColumnAction;

public class TableVariableEditor
extends JTable {
    private JScrollPane scrollPane;
    private int clickedColumn;
    private int[] selectedRows = new int[0];
    private int[] selectedCols = new int[0];
    private int popupRow;
    private int popupCol;
    private SwingScilabVariableEditor editor;

    public TableVariableEditor(SwingScilabVariableEditor swingScilabVariableEditor) {
        this.editor = swingScilabVariableEditor;
        this.scrollPane = new JScrollPane(this);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                BoundedRangeModel boundedRangeModel = TableVariableEditor.this.scrollPane.getVerticalScrollBar().getModel();
                if (boundedRangeModel.getMaximum() - boundedRangeModel.getExtent() - adjustmentEvent.getValue() <= 1) {
                    TableVariableEditor.this.addTenRows();
                }
            }
        });
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                BoundedRangeModel boundedRangeModel = TableVariableEditor.this.scrollPane.getHorizontalScrollBar().getModel();
                if (boundedRangeModel.getMaximum() - boundedRangeModel.getExtent() - adjustmentEvent.getValue() <= 1) {
                    TableVariableEditor.this.addTenCols();
                }
            }
        });
        this.scrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (((SwingEditvarTableModel)TableVariableEditor.this.getModel()).enlarge(TableVariableEditor.this.getMinimalRowNumber() + 1, TableVariableEditor.this.getMinimalColumnNumber() + 1)) {
                    ((SwingEditvarTableModel)TableVariableEditor.this.getModel()).fireTableChanged(new TableModelEvent(TableVariableEditor.this.getModel()));
                }
            }
        });
        this.getTableHeader().setDefaultRenderer(new HeaderRenderer(this, false));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (TableVariableEditor.this.getTableHeader().getCursor().getType() == 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    TableVariableEditor tableVariableEditor = TableVariableEditor.this;
                    int n = tableVariableEditor.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                    ListSelectionModel listSelectionModel = tableVariableEditor.getColumnModel().getSelectionModel();
                    int n2 = ((SwingEditvarTableModel)TableVariableEditor.this.getModel()).getScilabMatrixRowCount();
                    if (n2 == 0) {
                        n2 = 1;
                    }
                    if (mouseEvent.isShiftDown()) {
                        listSelectionModel.setSelectionInterval(n, TableVariableEditor.this.clickedColumn);
                        tableVariableEditor.setRowSelectionInterval(0, n2 - 1);
                    } else {
                        if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (tableVariableEditor.isColumnSelected(n)) {
                                listSelectionModel.removeSelectionInterval(n, n);
                            } else {
                                listSelectionModel.addSelectionInterval(n, n);
                                tableVariableEditor.setRowSelectionInterval(0, n2 - 1);
                            }
                        } else {
                            listSelectionModel.setSelectionInterval(n, n);
                            tableVariableEditor.setRowSelectionInterval(0, n2 - 1);
                        }
                        TableVariableEditor.this.clickedColumn = n;
                    }
                    tableVariableEditor.requestFocus();
                }
            }
        });
        this.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (TableVariableEditor.this.getTableHeader().getCursor().getType() == 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    TableVariableEditor tableVariableEditor = TableVariableEditor.this;
                    Point point = mouseEvent.getPoint();
                    int n = point.x >= tableVariableEditor.getTableHeader().getHeaderRect((int)(tableVariableEditor.getColumnCount() - 1)).x ? tableVariableEditor.getColumnCount() - 1 : tableVariableEditor.getColumnModel().getColumnIndexAtX(point.x);
                    ListSelectionModel listSelectionModel = tableVariableEditor.getColumnModel().getSelectionModel();
                    int n2 = listSelectionModel.getLeadSelectionIndex();
                    if (n2 != n) {
                        if (n == TableVariableEditor.this.getColumnCount() - 1) {
                            tableVariableEditor.addTenCols();
                        }
                        tableVariableEditor.scrollRectToVisible(tableVariableEditor.getTableHeader().getHeaderRect(n));
                        if (mouseEvent.isShiftDown()) {
                            listSelectionModel.setSelectionInterval(TableVariableEditor.this.clickedColumn, n);
                        } else if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (listSelectionModel.isSelectedIndex(n)) {
                                listSelectionModel.removeSelectionInterval(n2, n);
                                listSelectionModel.addSelectionInterval(TableVariableEditor.this.clickedColumn, n);
                            } else {
                                listSelectionModel.addSelectionInterval(TableVariableEditor.this.clickedColumn, n);
                            }
                        } else {
                            listSelectionModel.setSelectionInterval(TableVariableEditor.this.clickedColumn, n);
                        }
                        int n3 = ((SwingEditvarTableModel)TableVariableEditor.this.getModel()).getScilabMatrixRowCount();
                        if (n3 == 0) {
                            n3 = 1;
                        }
                        tableVariableEditor.setRowSelectionInterval(0, n3 - 1);
                        tableVariableEditor.requestFocus();
                    }
                }
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setComponentPopupMenu(this.createPopupMenu());
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", new JPanel());
        this.scrollPane.getCorner("UPPER_LEFT_CORNER").addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TableVariableEditor.this.selectAll();
            }
        });
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", new JPanel());
        this.scrollPane.getCorner("LOWER_LEFT_CORNER").addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TableVariableEditor.this.clearSelection();
            }
        });
        this.setFillsViewportHeight(true);
        this.setRowHeight(18);
        this.scrollPane.setRowHeaderView(new RowHeader(this));
        this.setSelectionMode(2);
        this.setCellSelectionEnabled(true);
        this.setBackground(Color.WHITE);
        this.setAutoResizeMode(0);
        if (this.getGridColor().equals(Color.WHITE)) {
            this.setGridColor(new Color(128, 128, 128));
        }
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.getSelectedRows();
        Vector<Integer> vector = this.getDifference(nArray, this.selectedRows);
        JTable jTable = ((RowHeader)this.scrollPane.getRowHeader().getView()).getTable();
        Object object = vector.iterator();
        while (object.hasNext()) {
            int n = object.next();
            jTable.repaint(jTable.getCellRect(n, 0, false));
        }
        this.selectedRows = nArray;
        object = (SwingEditvarTableModel)this.getModel();
        this.editor.getInfoBar().getAsSimpleTextBox().setText(((SwingEditvarTableModel)object).getScilabSubMatrix(nArray, this.getSelectedColumns()));
        super.valueChanged(listSelectionEvent);
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.getSelectedColumns();
        Vector<Integer> vector = this.getDifference(nArray, this.selectedCols);
        JTableHeader jTableHeader = this.getTableHeader();
        Object object = vector.iterator();
        while (object.hasNext()) {
            int n = object.next();
            jTableHeader.repaint(jTableHeader.getHeaderRect(n));
        }
        this.selectedCols = nArray;
        object = (SwingEditvarTableModel)this.getModel();
        this.editor.getInfoBar().getAsSimpleTextBox().setText(((SwingEditvarTableModel)object).getScilabSubMatrix(this.getSelectedRows(), nArray));
        super.columnSelectionChanged(listSelectionEvent);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            if (object != null && !object.toString().isEmpty()) {
                super.editingStopped(changeEvent);
            } else {
                this.editingCanceled(changeEvent);
            }
        }
    }

    @Override
    public void selectAll() {
        int n;
        SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)this.getModel();
        int n2 = swingEditvarTableModel.getScilabMatrixRowCount();
        if (n2 == 0) {
            n2 = 1;
        }
        if ((n = swingEditvarTableModel.getScilabMatrixColCount()) == 0) {
            n = 1;
        }
        this.setColumnSelectionInterval(0, n - 1);
        this.setRowSelectionInterval(0, n2 - 1);
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu(){

            @Override
            public void show(Component component, int n, int n2) {
                TableVariableEditor.this.setPopupColumn(TableVariableEditor.this.getColumnModel().getColumnIndexAtX(n));
                super.show(component, n, n2);
            }
        };
        jPopupMenu.setBorderPainted(true);
        jPopupMenu.add(InsertColumnAction.createMenuItem(this, UiDataMessages.INSERTC));
        jPopupMenu.add(RemoveColumnAction.createMenuItem(this, UiDataMessages.REMOVEC));
        return jPopupMenu;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public int getMinimalRowNumber() {
        Dimension dimension = this.scrollPane.getViewport().getSize();
        return (int)((double)dimension.height / (double)this.getRowHeight()) + 1;
    }

    public int getMinimalColumnNumber() {
        Dimension dimension = this.scrollPane.getViewport().getSize();
        return (int)((double)dimension.width / 75.0) + 1;
    }

    public void addTenRows() {
        int n = this.getRowCount();
        ((SwingEditvarTableModel)this.getModel()).addRows(10);
        ((SwingEditvarTableModel)this.getModel()).fireTableRowsInserted(n, n + 10);
    }

    public void addTenCols() {
        int n;
        ((SwingEditvarTableModel)this.getModel()).addColumns(10);
        for (int i = n = this.getColumnCount(); i < n + 10; ++i) {
            this.addColumn(new TableColumn(i));
        }
    }

    public void sizeColumnsToFit() {
        SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)this.getModel();
        for (int i = 0; i < swingEditvarTableModel.getScilabMatrixColCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            int n = 75;
            for (int j = 0; j < swingEditvarTableModel.getScilabMatrixRowCount(); ++j) {
                JLabel jLabel;
                String string;
                Component component = this.getCellRenderer(j, i).getTableCellRendererComponent(this, this.getValueAt(j, i), false, false, j, i);
                if (!(component instanceof JLabel) || (string = (jLabel = (JLabel)component).getText()) == null || string.isEmpty()) continue;
                int n2 = SwingUtilities.computeStringWidth(jLabel.getFontMetrics(jLabel.getFont()), jLabel.getText());
                n = Math.max(n, n2);
            }
            if (n != 75) {
                tableColumn.setPreferredWidth(n + 20);
                continue;
            }
            tableColumn.setPreferredWidth(75);
        }
        this.invalidate();
        this.doLayout();
        this.repaint();
    }

    public void setPopupRow(int n) {
        this.popupRow = n;
    }

    public int getPopupRow() {
        return this.popupRow;
    }

    public void setPopupColumn(int n) {
        this.popupCol = n;
    }

    public int getPopupColumn() {
        return this.popupCol;
    }

    private Vector<Integer> getDifference(int[] nArray, int[] nArray2) {
        Vector<Integer> vector = new Vector<Integer>(nArray.length + nArray2.length);
        for (int n : nArray) {
            if (Arrays.binarySearch(nArray2, n) >= 0) continue;
            vector.add(n);
        }
        for (int n : nArray2) {
            if (Arrays.binarySearch(nArray, n) >= 0) continue;
            vector.add(n);
        }
        return vector;
    }
}

