/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoManager;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.rowheader.RowHeader;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variableeditor.ScilabTabbedPane;
import org.scilab.modules.ui_data.variableeditor.SimpleVariableEditor;
import org.scilab.modules.ui_data.variableeditor.TableVariableEditor;
import org.scilab.modules.ui_data.variableeditor.actions.CloseAction;
import org.scilab.modules.ui_data.variableeditor.actions.CopyAction;
import org.scilab.modules.ui_data.variableeditor.actions.CopySelectionAsScilabCommandAction;
import org.scilab.modules.ui_data.variableeditor.actions.CopySelectionAsScilabMatrixAction;
import org.scilab.modules.ui_data.variableeditor.actions.CopySelectionAsScilabMatrixWithCRAction;
import org.scilab.modules.ui_data.variableeditor.actions.CreateNewVariableAction;
import org.scilab.modules.ui_data.variableeditor.actions.CreateVariableFromSelectionAction;
import org.scilab.modules.ui_data.variableeditor.actions.CutAction;
import org.scilab.modules.ui_data.variableeditor.actions.DuplicateVariableAction;
import org.scilab.modules.ui_data.variableeditor.actions.ExportToCsvAction;
import org.scilab.modules.ui_data.variableeditor.actions.ExportToCsvFromSelectionAction;
import org.scilab.modules.ui_data.variableeditor.actions.PasteAction;
import org.scilab.modules.ui_data.variableeditor.actions.PlotAction;
import org.scilab.modules.ui_data.variableeditor.actions.RedoAction;
import org.scilab.modules.ui_data.variableeditor.actions.RefreshAction;
import org.scilab.modules.ui_data.variableeditor.actions.SetPrecisionLongAction;
import org.scilab.modules.ui_data.variableeditor.actions.SetPrecisionLongeAction;
import org.scilab.modules.ui_data.variableeditor.actions.SetPrecisionShortAction;
import org.scilab.modules.ui_data.variableeditor.actions.SetPrecisionShorteAction;
import org.scilab.modules.ui_data.variableeditor.actions.SizeColumnsToFitAction;
import org.scilab.modules.ui_data.variableeditor.actions.SupprAction;
import org.scilab.modules.ui_data.variableeditor.actions.UndoAction;
import org.scilab.modules.ui_data.variableeditor.celleditor.CellEditorFactory;
import org.scilab.modules.ui_data.variableeditor.celleditor.ScilabGenericCellEditor;
import org.scilab.modules.ui_data.variableeditor.renderers.RendererFactory;
import org.scilab.modules.ui_data.variableeditor.undo.CellsUndoManager;

public class SwingScilabVariableEditor
extends SwingScilabDockablePanel
implements SimpleVariableEditor {
    public static final String PREFIX = "Var - ";
    private static final String APOS = "'";
    private static final long serialVersionUID = 1L;
    private final ScilabTabbedPane tabPane;
    private final JButton refreshButton;
    private final JButton undoButton;
    private final JButton redoButton;

    public SwingScilabVariableEditor(String string, String string2, Object[][] objectArray) {
        super(UiDataMessages.VARIABLE_EDITOR);
        this.setAssociatedXMLIDForHelp("editvar");
        this.setWindowIcon("rrze_table");
        this.refreshButton = RefreshAction.createButton(this, UiDataMessages.REFRESH);
        this.undoButton = UndoAction.createButton(this, UiDataMessages.UNDO);
        this.redoButton = RedoAction.createButton(this, UiDataMessages.REDO);
        this.enableUndoButton(false);
        this.enableRedoButton(false);
        this.tabPane = new ScilabTabbedPane(this);
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = SwingScilabVariableEditor.this.tabPane.getScilabTitleAt(SwingScilabVariableEditor.this.tabPane.getSelectedIndex());
                if (string.length() != 0) {
                    Object object;
                    string = string.substring(SwingScilabVariableEditor.PREFIX.length());
                    Object object2 = "";
                    if (string != null && SwingScilabVariableEditor.this.getCurrentModel() != null) {
                        object2 = UiDataMessages.REFRESH + SwingScilabVariableEditor.APOS + string + SwingScilabVariableEditor.APOS;
                        object = ((SwingEditvarTableModel)SwingScilabVariableEditor.this.getCurrentModel()).getType();
                        String string2 = UiDataMessages.VARIABLE_EDITOR + " - " + string + "  (" + (String)object + ")";
                        SwingScilabVariableEditor.this.setName(string2);
                        SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, SwingScilabVariableEditor.this.tabPane);
                        if (swingScilabWindow != null) {
                            swingScilabWindow.setTitle(string2);
                        }
                    }
                    object = ((SwingEditvarTableModel)SwingScilabVariableEditor.this.getCurrentModel()).getUndoManager();
                    SwingScilabVariableEditor.this.enableUndoButton(((UndoManager)object).canUndo());
                    SwingScilabVariableEditor.this.enableRedoButton(((UndoManager)object).canRedo());
                    SwingScilabVariableEditor.this.refreshButton.setToolTipText((String)object2);
                }
            }
        });
        this.setContentPane(this.tabPane);
        this.setData(string, string2, objectArray);
        WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)this);
        this.addToolBar(this.createToolBar());
        this.addMenuBar(this.createMenuBar());
    }

    public void addInfoBar(TextBox textBox) {
        this.setInfoBar(textBox);
    }

    public void addMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
    }

    public void addToolBar(ToolBar toolBar) {
        this.setToolBar(toolBar);
    }

    public ScilabTabbedPane getTabPane() {
        return this.tabPane;
    }

    public JTable getCurrentTable() {
        Component component = this.tabPane.getSelectedComponent();
        if (component != null) {
            return (JTable)((JScrollPane)component).getViewport().getComponent(0);
        }
        return null;
    }

    public TableModel getCurrentModel() {
        JTable jTable = this.getCurrentTable();
        if (jTable != null) {
            return jTable.getModel();
        }
        return null;
    }

    public ToolBar createToolBar() {
        ToolBar toolBar = ScilabToolBar.createToolBar();
        SwingScilabToolBar swingScilabToolBar = (SwingScilabToolBar)toolBar.getAsSimpleToolBar();
        swingScilabToolBar.add((Component)this.refreshButton);
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)CreateVariableFromSelectionAction.createButton(this, UiDataMessages.CREATE));
        swingScilabToolBar.add((Component)CreateNewVariableAction.createButton(this, UiDataMessages.CREATENEWVAR));
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)CutAction.createButton(this, UiDataMessages.CUT));
        swingScilabToolBar.add((Component)CopyAction.createButton(this, UiDataMessages.COPY));
        swingScilabToolBar.add((Component)PasteAction.createButton(this, UiDataMessages.PASTE));
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)this.undoButton);
        swingScilabToolBar.add((Component)this.redoButton);
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)SizeColumnsToFitAction.createButton(this, UiDataMessages.FIT));
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)SetPrecisionShortAction.createButton(this, UiDataMessages.SHORT));
        swingScilabToolBar.add((Component)SetPrecisionShorteAction.createButton(this, UiDataMessages.SHORTE));
        swingScilabToolBar.add((Component)SetPrecisionLongAction.createButton(this, UiDataMessages.LONG));
        swingScilabToolBar.add((Component)SetPrecisionLongeAction.createButton(this, UiDataMessages.LONGE));
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)PlotAction.createButton(this, UiDataMessages.PLOTSELECTION));
        return toolBar;
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBorderPainted(true);
        jPopupMenu.add((JMenuItem)UndoAction.createJMenuItem(this, UiDataMessages.UNDO));
        jPopupMenu.add((JMenuItem)RedoAction.createJMenuItem(this, UiDataMessages.REDO));
        jPopupMenu.addSeparator();
        jPopupMenu.add((JMenuItem)CutAction.createJMenuItem(this, UiDataMessages.CUT));
        jPopupMenu.add((JMenuItem)CopyAction.createJMenuItem(this, UiDataMessages.COPY));
        jPopupMenu.add((JMenuItem)PasteAction.createJMenuItem(this, UiDataMessages.PASTE));
        jPopupMenu.addSeparator();
        jPopupMenu.add((JMenuItem)CopySelectionAsScilabCommandAction.createJMenuItem(this, UiDataMessages.COPYASSCILABCOM));
        jPopupMenu.add((JMenuItem)CopySelectionAsScilabMatrixAction.createJMenuItem(this, UiDataMessages.COPYASSCILABMAT));
        jPopupMenu.add((JMenuItem)CopySelectionAsScilabMatrixWithCRAction.createJMenuItem(this, UiDataMessages.COPYASSCILABMATWITHCR));
        jPopupMenu.add((JMenuItem)ExportToCsvFromSelectionAction.createJMenuItem(this, UiDataMessages.EXPORTSELECTIONCSV));
        jPopupMenu.addSeparator();
        jPopupMenu.add((JMenuItem)CreateVariableFromSelectionAction.createJMenuItem(this, UiDataMessages.CREATE));
        jPopupMenu.add((JMenuItem)CreateNewVariableAction.createJMenuItem(this, UiDataMessages.CREATENEWVAR));
        jPopupMenu.add((JMenuItem)DuplicateVariableAction.createJMenuItem(this, UiDataMessages.DUPLICATE));
        jPopupMenu.add((JMenuItem)ExportToCsvAction.createJMenuItem(this, UiDataMessages.EXPORTCSV));
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu(UiDataMessages.PLOTSELECTION);
        jPopupMenu.add(jMenu);
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "plot2d", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "Matplot", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "grayplot", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "Sgrayplot", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "champ", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "histplot", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "mesh", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "surf", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "bar3d", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "contour2d", true));
        jMenu.add((JMenuItem)PlotAction.createJMenuItem(this, "pie", true));
        jPopupMenu.addSeparator();
        JMenu jMenu2 = new JMenu(UiDataMessages.PLOTALL);
        jPopupMenu.add(jMenu2);
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "plot2d", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "Matplot", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "grayplot", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "Sgrayplot", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "champ", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "histplot", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "mesh", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "surf", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "bar3d", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "contour2d", false));
        jMenu2.add((JMenuItem)PlotAction.createJMenuItem(this, "pie", false));
        return jPopupMenu;
    }

    public MenuBar createMenuBar() {
        MenuBar menuBar = ScilabMenuBar.createMenuBar();
        Menu menu = ScilabMenu.createMenu();
        menu.setText(UiDataMessages.FILE);
        menu.add(CreateVariableFromSelectionAction.createMenuItem(this, UiDataMessages.CREATE));
        menu.add(CreateNewVariableAction.createMenuItem(this, UiDataMessages.CREATENEWVAR));
        menu.add(DuplicateVariableAction.createMenuItem(this, UiDataMessages.DUPLICATE));
        menu.add(ExportToCsvAction.createMenuItem(this, UiDataMessages.EXPORTCSV));
        menu.addSeparator();
        menu.add(CloseAction.createMenuItem(this, UiDataMessages.CLOSE));
        menuBar.add(menu);
        Menu menu2 = ScilabMenu.createMenu();
        menu2.setText(UiDataMessages.EDITION);
        menu2.add(UndoAction.createMenuItem(this, UiDataMessages.UNDO));
        menu2.add(RedoAction.createMenuItem(this, UiDataMessages.REDO));
        menu2.addSeparator();
        menu2.add(CutAction.createMenuItem(this, UiDataMessages.CUT));
        menu2.add(CopyAction.createMenuItem(this, UiDataMessages.COPY));
        menu2.add(PasteAction.createMenuItem(this, UiDataMessages.PASTE));
        menu2.addSeparator();
        menu2.add(CopySelectionAsScilabCommandAction.createMenuItem(this, UiDataMessages.COPYASSCILABCOM));
        menu2.add(CopySelectionAsScilabMatrixAction.createMenuItem(this, UiDataMessages.COPYASSCILABMAT));
        menu2.add(CopySelectionAsScilabMatrixWithCRAction.createMenuItem(this, UiDataMessages.COPYASSCILABMATWITHCR));
        menu2.addSeparator();
        menu2.add(SizeColumnsToFitAction.createMenuItem(this, UiDataMessages.FIT));
        menuBar.add(menu2);
        return menuBar;
    }

    @Override
    public void setData(String string, String string2, Object[][] objectArray) {
        TableVariableEditor tableVariableEditor = new TableVariableEditor(this);
        CopyAction.registerAction(this, tableVariableEditor);
        CutAction.registerAction(this, tableVariableEditor);
        PasteAction.registerAction(this, tableVariableEditor);
        SupprAction.registerAction(this, tableVariableEditor);
        UndoAction.registerAction(this, tableVariableEditor);
        RedoAction.registerAction(this, tableVariableEditor);
        SizeColumnsToFitAction.registerAction(this, tableVariableEditor);
        SetPrecisionShortAction.registerAction(this, tableVariableEditor);
        SetPrecisionShorteAction.registerAction(this, tableVariableEditor);
        SetPrecisionLongAction.registerAction(this, tableVariableEditor);
        SetPrecisionLongeAction.registerAction(this, tableVariableEditor);
        CreateVariableFromSelectionAction.registerAction(this, tableVariableEditor);
        CreateNewVariableAction.registerAction(this, tableVariableEditor);
        tableVariableEditor.setComponentPopupMenu(this.createPopupMenu());
        ScilabGenericCellEditor scilabGenericCellEditor = (ScilabGenericCellEditor)CellEditorFactory.createCellEditor(string2);
        int n = Math.max(tableVariableEditor.getMinimalRowNumber(), tableVariableEditor.getModel().getRowCount());
        int n2 = tableVariableEditor.getModel().getColumnCount();
        SwingEditvarTableModel swingEditvarTableModel = new SwingEditvarTableModel(this, string, string2, objectArray, scilabGenericCellEditor, n, n2);
        swingEditvarTableModel.addTableModelListener(this.getRowHeader(tableVariableEditor));
        this.getRowHeader(tableVariableEditor).tableChanged(new TableModelEvent(swingEditvarTableModel));
        tableVariableEditor.setModel(swingEditvarTableModel);
        tableVariableEditor.setDefaultEditor(Object.class, scilabGenericCellEditor);
        tableVariableEditor.setDefaultRenderer(Object.class, RendererFactory.createRenderer(string2));
        this.tabPane.add(PREFIX + string, tableVariableEditor.getScrollPane());
        this.tabPane.setSelectedComponent(tableVariableEditor.getScrollPane());
    }

    public void updateData(JTable jTable, String string, String string2, Object[][] objectArray) {
        ScilabGenericCellEditor scilabGenericCellEditor = (ScilabGenericCellEditor)CellEditorFactory.createCellEditor(string2);
        int n = Math.max(((TableVariableEditor)jTable).getMinimalRowNumber(), jTable.getModel().getRowCount());
        int n2 = jTable.getModel().getColumnCount();
        CellsUndoManager cellsUndoManager = null;
        if (jTable.getModel() instanceof SwingEditvarTableModel) {
            cellsUndoManager = ((SwingEditvarTableModel)jTable.getModel()).getUndoManager();
        }
        SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)jTable.getModel();
        this.getRowHeader((TableVariableEditor)jTable).tableChanged(new TableModelEvent(swingEditvarTableModel));
        swingEditvarTableModel.changeData(string2, objectArray, scilabGenericCellEditor, n, n2);
        jTable.setDefaultEditor(Object.class, scilabGenericCellEditor);
        jTable.setDefaultRenderer(Object.class, RendererFactory.createRenderer(string2));
    }

    public void updateData(JTable jTable, String string, String string2, Object[][] objectArray, double[] dArray, double[] dArray2) {
        SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)jTable.getModel();
        if (!string2.equals(swingEditvarTableModel.getType())) {
            swingEditvarTableModel.refresh();
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray2.length; ++j) {
                    int n = (int)dArray[i] - 1;
                    int n2 = (int)dArray2[j] - 1;
                    swingEditvarTableModel.setValueAtAndUpdate(false, false, objectArray[i][j], n, n2);
                }
            }
        }
    }

    public void updateData(Component component, String string, String string2, Object[][] objectArray) {
        this.tabPane.setSelectedComponent(component);
        JTable jTable = (JTable)((JScrollPane)component).getViewport().getComponent(0);
        this.updateData(jTable, string, string2, objectArray);
    }

    public void updateData(Component component, String string, String string2, Object[][] objectArray, double[] dArray, double[] dArray2) {
        this.tabPane.setSelectedComponent(component);
        JTable jTable = (JTable)((JScrollPane)component).getViewport().getComponent(0);
        this.updateData(jTable, string, string2, objectArray, dArray, dArray2);
    }

    public RowHeader getRowHeader(TableVariableEditor tableVariableEditor) {
        return (RowHeader)tableVariableEditor.getScrollPane().getRowHeader().getView();
    }

    public SimpleTab getAsSimpleTab() {
        return this;
    }

    public void enableUndoButton(boolean bl) {
        if (this.undoButton != null) {
            this.undoButton.setEnabled(bl);
        }
    }

    public void enableRedoButton(boolean bl) {
        if (this.redoButton != null) {
            this.redoButton.setEnabled(bl);
        }
    }
}

