/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variablebrowser.actions;

import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variablebrowser.SwingScilabVariableBrowser;

public final class DeleteAction
extends CommonCallBack {
    private static final long serialVersionUID = 1L;
    private static ImageIcon icon = new ImageIcon(FindIconHelper.findIcon((String)"edit-delete"));
    private static final char MNEMONIC = 'D';
    private static final String KEY = "DELETE";
    private static final String SUPPR = "Suppr";
    private final SwingScilabVariableBrowser variableBrowser;

    public DeleteAction(SwingScilabVariableBrowser swingScilabVariableBrowser) {
        super("");
        this.variableBrowser = swingScilabVariableBrowser;
    }

    public static JButton createButton(SwingScilabVariableBrowser swingScilabVariableBrowser, String string) {
        JButton jButton = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        jButton.addActionListener((ActionListener)((Object)new DeleteAction(swingScilabVariableBrowser)));
        jButton.setToolTipText(string);
        jButton.setIcon(icon);
        return jButton;
    }

    public MenuItem createMenuItem() {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setText(UiDataMessages.DELETE + " '" + this.getSelectedVariable() + "'");
        menuItem.setMnemonic('D');
        menuItem.setCallback((CommonCallBack)this);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setIcon((Icon)icon);
        return menuItem;
    }

    public void callBack() {
        try {
            ScilabInterpreterManagement.asynchronousScilabExec(null, (String)("clear('" + this.getSelectedVariable() + "'); updatebrowsevar()"));
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            System.err.println("An error in the interpreter has been catched: " + interpreterException.getLocalizedMessage());
        }
    }

    private String getSelectedVariable() {
        int n = this.variableBrowser.getTable().getSelectedRow();
        if (n != -1) {
            return this.variableBrowser.getTable().getValueAt(n, 1).toString();
        }
        return "";
    }
}

