/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variablebrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.checkboxmenuitem.CheckBoxMenuItem;
import org.scilab.modules.gui.contextmenu.ContextMenu;
import org.scilab.modules.gui.contextmenu.ScilabContextMenu;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.types.ScilabTypeEnum;
import org.scilab.modules.ui_data.actions.BooleanFilteringAction;
import org.scilab.modules.ui_data.actions.CompiledFunctionFilteringAction;
import org.scilab.modules.ui_data.actions.DoubleFilteringAction;
import org.scilab.modules.ui_data.actions.FunctionLibFilteringAction;
import org.scilab.modules.ui_data.actions.GraphicHandlesFilteringAction;
import org.scilab.modules.ui_data.actions.HelpAction;
import org.scilab.modules.ui_data.actions.ImplicitPolynomialFilteringAction;
import org.scilab.modules.ui_data.actions.IntegerFilteringAction;
import org.scilab.modules.ui_data.actions.IntrinsicFunctionFilteringAction;
import org.scilab.modules.ui_data.actions.ListFilteringAction;
import org.scilab.modules.ui_data.actions.MListFilteringAction;
import org.scilab.modules.ui_data.actions.PointerFilteringAction;
import org.scilab.modules.ui_data.actions.PolynomialFilteringAction;
import org.scilab.modules.ui_data.actions.ScilabVarFilteringAction;
import org.scilab.modules.ui_data.actions.ScilabVarFilteringButtonAction;
import org.scilab.modules.ui_data.actions.SparseBoolFilteringAction;
import org.scilab.modules.ui_data.actions.SparseFilteringAction;
import org.scilab.modules.ui_data.actions.StringFilteringAction;
import org.scilab.modules.ui_data.actions.TListFilteringAction;
import org.scilab.modules.ui_data.datatable.SwingTableModel;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variablebrowser.SimpleVariableBrowser;
import org.scilab.modules.ui_data.variablebrowser.actions.CloseAction;
import org.scilab.modules.ui_data.variablebrowser.actions.DeleteAction;
import org.scilab.modules.ui_data.variablebrowser.actions.ModifyAction;
import org.scilab.modules.ui_data.variablebrowser.actions.RefreshAction;
import org.scilab.modules.ui_data.variablebrowser.rowfilter.VariableBrowserRowDataFilter;
import org.scilab.modules.ui_data.variablebrowser.rowfilter.VariableBrowserRowTypeFilter;
import org.scilab.modules.ui_data.variableeditor.actions.ExportToCsvAction;
import org.scilab.modules.ui_data.variableeditor.actions.PlotAction;

public final class SwingScilabVariableBrowser
extends SwingScilabDockablePanel
implements SimpleVariableBrowser {
    public static final String VARBROWSERUUID = "3b649047-6a71-4998-bd8e-00d367a4793c";
    private static final long serialVersionUID = 2169382559550113917L;
    private SwingTableModel<Object> dataModel;
    private JTable table;
    private MenuBar menuBar;
    private Menu fileMenu;
    private Menu helpMenu;
    private Menu filterMenu;
    private CheckBoxMenuItem filterDoubleCheckBox;
    private CheckBoxMenuItem filterPolynomialCheckBox;
    private CheckBoxMenuItem filterScilabVarCheckBox;
    private CheckBoxMenuItem filterBooleanCheckBox;
    private CheckBoxMenuItem filterSparseCheckBox;
    private CheckBoxMenuItem filterSparseBoolCheckBox;
    private CheckBoxMenuItem filterIntegerCheckBox;
    private CheckBoxMenuItem filterGraphicHandlesCheckBox;
    private CheckBoxMenuItem filterStringCheckBox;
    private CheckBoxMenuItem filtercompiledFuncCheckBox;
    private CheckBoxMenuItem filterFunctionLibCheckBox;
    private CheckBoxMenuItem filterListCheckBox;
    private CheckBoxMenuItem filterTListCheckBox;
    private CheckBoxMenuItem filterMListCheckBox;
    private CheckBoxMenuItem filterPointerCheckBox;
    private CheckBoxMenuItem filterIntrinsicFunctionCheckBox;
    private CheckBoxMenuItem filterImplicitPolynomialCheckBox;
    private JButton filteringButton;
    private boolean isSetData = false;
    private TableRowSorter<?> rowSorter;

    public SwingScilabVariableBrowser(String[] stringArray, int[] nArray) {
        super(UiDataMessages.VARIABLE_BROWSER, VARBROWSERUUID);
        this.setAssociatedXMLIDForHelp("browsevar");
        this.buildMenuBar();
        this.addMenuBar(this.menuBar);
        ToolBar toolBar = ScilabToolBar.createToolBar();
        SwingScilabToolBar swingScilabToolBar = (SwingScilabToolBar)toolBar.getAsSimpleToolBar();
        swingScilabToolBar.add((Component)RefreshAction.createButton(UiDataMessages.REFRESH));
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)ModifyAction.createButton(this, UiDataMessages.MODIFY));
        swingScilabToolBar.add((Component)DeleteAction.createButton(this, UiDataMessages.DELETE));
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)HelpAction.createButton(UiDataMessages.HELP));
        this.filteringButton = ScilabVarFilteringButtonAction.createButton("Show/hide Scilab variable");
        this.addToolBar(toolBar);
        this.dataModel = new SwingTableModel(stringArray);
        this.table = new JTable(this.dataModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = null;
                TableModel tableModel = ((JTable)mouseEvent.getSource()).getModel();
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                if (n >= 0) {
                    n = this.convertRowIndexToModel(n);
                    int n2 = this.columnAtPoint(point);
                    if (n2 == 3) {
                        try {
                            string = Messages.gettext((String)"Scilab type:") + " " + tableModel.getValueAt(n, 7).toString();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                return string;
            }
        };
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(4);
        this.table.setAutoCreateRowSorter(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(9);
        this.table.removeColumn(tableColumn);
        tableColumn = this.table.getColumnModel().getColumn(8);
        this.table.removeColumn(tableColumn);
        tableColumn = this.table.getColumnModel().getColumn(7);
        this.table.removeColumn(tableColumn);
        tableColumn = this.table.getColumnModel().getColumn(6);
        this.table.removeColumn(tableColumn);
        tableColumn = this.table.getColumnModel().getColumn(5);
        this.table.addMouseListener(new BrowseVarMouseListener());
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setBackground(Color.WHITE);
        if (this.table.getGridColor().equals(Color.WHITE)) {
            this.table.setGridColor(new Color(128, 128, 128));
        }
        this.table.setShowHorizontalLines(true);
        this.table.setShowVerticalLines(true);
        for (int i = 0; i < nArray.length; ++i) {
            SwingScilabVariableBrowser.align(this.table, stringArray[i], nArray[i]);
        }
        ExportToCsvAction.registerAction(this, this.table);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.setContentPane(jScrollPane);
        WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)this);
    }

    public void addInfoBar(TextBox textBox) {
        this.setInfoBar(textBox);
    }

    public void addMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
    }

    public void addToolBar(ToolBar toolBar) {
        this.setToolBar(toolBar);
    }

    @Override
    public void setColumnNames(String[] stringArray) {
        this.dataModel.setColumnNames(stringArray);
    }

    @Override
    public void setData(Object[][] objectArray) {
        this.isSetData = true;
        this.dataModel.setData((Object[][])objectArray);
        this.rowSorter = new TableRowSorter<SwingTableModel<Object>>(this.dataModel);
        this.updateRowFiltering();
    }

    private static void align(JTable jTable, String string, int n) {
        if (n != -1) {
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(n);
            try {
                TableColumn tableColumn = jTable.getColumn(string);
                if (tableColumn != null) {
                    tableColumn.setCellRenderer(defaultTableCellRenderer);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void updateRowFiltering() {
        if (!this.isSetData) {
            try {
                ScilabInterpreterManagement.synchronousScilabExec((String)"browsevar");
                this.isSetData = true;
            }
            catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
                System.err.println((Object)interpreterException);
            }
        }
        VariableBrowserRowTypeFilter variableBrowserRowTypeFilter = new VariableBrowserRowTypeFilter(this.getFilteredTypeValues());
        VariableBrowserRowDataFilter variableBrowserRowDataFilter = new VariableBrowserRowDataFilter(this.getFilteredDataValues());
        ArrayList<RowFilter> arrayList = new ArrayList<RowFilter>();
        RowFilter rowFilter = null;
        arrayList.add(variableBrowserRowTypeFilter);
        arrayList.add(variableBrowserRowDataFilter);
        rowFilter = RowFilter.andFilter(arrayList);
        this.rowSorter.setRowFilter(rowFilter);
        this.table.setRowSorter(this.rowSorter);
    }

    public void buildMenuBar() {
        this.menuBar = ScilabMenuBar.createMenuBar();
        this.fileMenu = ScilabMenu.createMenu();
        this.fileMenu.setText(UiDataMessages.FILE);
        this.fileMenu.setMnemonic(70);
        this.fileMenu.add(RefreshAction.createMenuItem(UiDataMessages.REFRESH));
        this.fileMenu.addSeparator();
        this.fileMenu.add(CloseAction.createMenu());
        this.menuBar.add(this.fileMenu);
        this.filterMenu = ScilabMenu.createMenu();
        this.filterMenu.setText(UiDataMessages.FILTER);
        this.filterMenu.setMnemonic(73);
        this.filterScilabVarCheckBox = ScilabVarFilteringAction.createCheckBoxMenu();
        this.filterScilabVarCheckBox.setChecked(true);
        this.filterMenu.add(this.filterScilabVarCheckBox);
        this.filterMenu.addSeparator();
        this.filterBooleanCheckBox = BooleanFilteringAction.createCheckBoxMenu();
        this.filterBooleanCheckBox.setChecked(true);
        this.filterMenu.add(this.filterBooleanCheckBox);
        this.filterDoubleCheckBox = DoubleFilteringAction.createCheckBoxMenu();
        this.filterDoubleCheckBox.setChecked(true);
        this.filterMenu.add(this.filterDoubleCheckBox);
        this.filterPolynomialCheckBox = PolynomialFilteringAction.createCheckBoxMenu();
        this.filterPolynomialCheckBox.setChecked(true);
        this.filterMenu.add(this.filterPolynomialCheckBox);
        this.filterFunctionLibCheckBox = FunctionLibFilteringAction.createCheckBoxMenu();
        this.filterMenu.add(this.filterFunctionLibCheckBox);
        this.filterStringCheckBox = StringFilteringAction.createCheckBoxMenu();
        this.filterStringCheckBox.setChecked(true);
        this.filterMenu.add(this.filterStringCheckBox);
        this.filterSparseCheckBox = SparseFilteringAction.createCheckBoxMenu();
        this.filterSparseCheckBox.setChecked(true);
        this.filterMenu.add(this.filterSparseCheckBox);
        this.filterSparseBoolCheckBox = SparseBoolFilteringAction.createCheckBoxMenu();
        this.filterSparseBoolCheckBox.setChecked(true);
        this.filterMenu.add(this.filterSparseBoolCheckBox);
        this.filterIntegerCheckBox = IntegerFilteringAction.createCheckBoxMenu();
        this.filterIntegerCheckBox.setChecked(true);
        this.filterMenu.add(this.filterIntegerCheckBox);
        this.filterGraphicHandlesCheckBox = GraphicHandlesFilteringAction.createCheckBoxMenu();
        this.filterGraphicHandlesCheckBox.setChecked(true);
        this.filterMenu.add(this.filterGraphicHandlesCheckBox);
        this.filtercompiledFuncCheckBox = CompiledFunctionFilteringAction.createCheckBoxMenu();
        this.filterMenu.add(this.filtercompiledFuncCheckBox);
        this.filterListCheckBox = ListFilteringAction.createCheckBoxMenu();
        this.filterListCheckBox.setChecked(true);
        this.filterMenu.add(this.filterListCheckBox);
        this.filterTListCheckBox = TListFilteringAction.createCheckBoxMenu();
        this.filterTListCheckBox.setChecked(true);
        this.filterMenu.add(this.filterTListCheckBox);
        this.filterMListCheckBox = MListFilteringAction.createCheckBoxMenu();
        this.filterMListCheckBox.setChecked(true);
        this.filterMenu.add(this.filterMListCheckBox);
        this.filterPointerCheckBox = PointerFilteringAction.createCheckBoxMenu();
        this.filterPointerCheckBox.setChecked(true);
        this.filterMenu.add(this.filterPointerCheckBox);
        this.filterIntrinsicFunctionCheckBox = IntrinsicFunctionFilteringAction.createCheckBoxMenu();
        this.filterMenu.add(this.filterIntrinsicFunctionCheckBox);
        this.filterImplicitPolynomialCheckBox = ImplicitPolynomialFilteringAction.createCheckBoxMenu();
        this.filterMenu.add(this.filterImplicitPolynomialCheckBox);
        this.menuBar.add(this.filterMenu);
        this.helpMenu = ScilabMenu.createMenu();
        this.helpMenu.setText("?");
        this.helpMenu.setMnemonic(63);
        this.helpMenu.add(HelpAction.createMenuItem(UiDataMessages.HELP));
        this.menuBar.add(this.helpMenu);
    }

    public boolean getFilteredDataValues() {
        return this.filterScilabVarCheckBox.isChecked();
    }

    public HashSet<ScilabTypeEnum> getFilteredTypeValues() {
        HashSet<ScilabTypeEnum> hashSet = new HashSet<ScilabTypeEnum>();
        if (!this.filterBooleanCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_boolean);
        }
        if (!this.filterDoubleCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_matrix);
        }
        if (!this.filterFunctionLibCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_lib);
        }
        if (!this.filterStringCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_strings);
        }
        if (!this.filterPolynomialCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_poly);
        }
        if (!this.filterSparseCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_sparse);
        }
        if (!this.filterSparseBoolCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_boolean_sparse);
        }
        if (!this.filterIntegerCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_ints);
        }
        if (!this.filterGraphicHandlesCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_handles);
        }
        if (!this.filtercompiledFuncCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_c_function);
        }
        if (!this.filterListCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_list);
        }
        if (!this.filterTListCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_tlist);
        }
        if (!this.filterMListCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_mlist);
        }
        if (!this.filterPointerCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_pointer);
        }
        if (!this.filterIntrinsicFunctionCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_intrinsic_function);
        }
        if (!this.filterImplicitPolynomialCheckBox.isChecked()) {
            hashSet.add(ScilabTypeEnum.sci_implicit_poly);
        }
        return hashSet;
    }

    public SwingScilabDockablePanel getBrowserTab() {
        return this;
    }

    public JTable getTable() {
        return this.table;
    }

    public void startEditVar(String string, String string2) {
        if (string.equals("global")) {
            ScilabModalDialog.show((SimpleTab)this.getBrowserTab(), (String)UiDataMessages.GLOBAL_NOT_EDITABLE, (String)UiDataMessages.VARIABLE_EDITOR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
            return;
        }
        try {
            ScilabInterpreterManagement.asynchronousScilabExec(null, (String)("if exists(\"" + string2 + "\") == 1 then   if or(type(" + string2 + ")==[9 13 14 15 16 17])     browsevar_seeSpecial(" + string2 + ",\"" + string2 + "\");   else     try       editvar(\"" + string2 + "\");     catch       messagebox(\"Variables of type \"\"\" + typeof (" + string2 + ") + \"\"\" can not be edited.\",\"" + UiDataMessages.VARIABLE_EDITOR + "\", \"error\", \"modal\");      clear ans;    end   end else   messagebox(\"Variable \"\"" + string2 + "\"\" no more exists.\",\"" + UiDataMessages.VARIABLE_EDITOR + "\", \"error\", \"modal\");  clear ans;  browsevar();end"));
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            System.err.println("An error in the interpreter has been catched: " + interpreterException.getLocalizedMessage());
        }
    }

    private class BrowseVarMouseListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if ((mouseEvent.getClickCount() == 1 && SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) && (n = ((JTable)mouseEvent.getSource()).rowAtPoint(mouseEvent.getPoint())) != -1) {
                SwingScilabVariableBrowser.this.table.setRowSelectionInterval(n, n);
                SwingScilabVariableBrowser.this.table.setEditingRow(n);
                this.displayContextMenu();
            }
            if (mouseEvent.getClickCount() >= 2 && (n = ((JTable)mouseEvent.getSource()).rowAtPoint(mouseEvent.getPoint())) != -1) {
                String string = SwingScilabVariableBrowser.this.table.getValueAt(n, 1).toString();
                String string2 = ((JTable)mouseEvent.getSource()).getValueAt(((JTable)mouseEvent.getSource()).getSelectedRow(), 4).toString();
                SwingScilabVariableBrowser.this.startEditVar(string2, string);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        private void displayContextMenu() {
            ContextMenu contextMenu = ScilabContextMenu.createContextMenu();
            ModifyAction modifyAction = new ModifyAction(SwingScilabVariableBrowser.this);
            contextMenu.add(modifyAction.createMenuItem());
            DeleteAction deleteAction = new DeleteAction(SwingScilabVariableBrowser.this);
            contextMenu.add(deleteAction.createMenuItem());
            contextMenu.add(ExportToCsvAction.createMenuItem(SwingScilabVariableBrowser.this, UiDataMessages.EXPORTCSV));
            Menu menu = ScilabMenu.createMenu();
            menu.setText(UiDataMessages.PLOTALL);
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "plot2d", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "Matplot", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "grayplot", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "Sgrayplot", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "champ", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "histplot", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "mesh", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "surf", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "bar3d", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "contour2d", false));
            menu.add(PlotAction.createMenuItem(SwingScilabVariableBrowser.this, "pie", false));
            contextMenu.add(menu);
            contextMenu.setVisible(true);
            ((SwingScilabContextMenu)contextMenu.getAsSimpleContextMenu()).setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        }
    }
}

