/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.newsfeed;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;
import org.scilab.modules.ui_data.newsfeed.News;
import org.scilab.modules.ui_data.newsfeed.NewsFeedErrorEvent;
import org.scilab.modules.ui_data.newsfeed.NewsFeedEvent;
import org.scilab.modules.ui_data.newsfeed.NewsFeedEventListener;
import org.scilab.modules.ui_data.newsfeed.NewsFeedSettings;
import org.scilab.modules.ui_data.newsfeed.NewsFeedUIMessages;
import org.scilab.modules.ui_data.newsfeed.NewsFetcher;

public class NewsFeedController
implements ActionListener {
    private List<News> news;
    private News currentNews = new News();
    private static final int NO_TIME_INTERVAL = -1;
    private static final int ONE_SECOND = 1000;
    private Timer newsChangeTimer;
    private int newsChangeTimeInterval = -1;
    private Timer feedUpdateTimer;
    private int feedUpdateTimeInterval = 14400000;
    private NewsFetcher newsFetcher = new NewsFetcher();
    private ArrayList<NewsFeedEventListener> listeners;

    public NewsFeedController() {
        this.news = new ArrayList<News>();
        this.listeners = new ArrayList();
        this.readSettings();
        if (this.newsChangeTimeInterval != -1) {
            this.newsChangeTimer = new Timer(this.newsChangeTimeInterval, this);
            this.newsChangeTimer.setRepeats(true);
        } else {
            this.newsChangeTimer = new Timer(1000, this);
            this.newsChangeTimer.setRepeats(false);
        }
        this.newsChangeTimer.setInitialDelay(1000);
        if (this.feedUpdateTimeInterval != -1) {
            this.feedUpdateTimer = new Timer(this.feedUpdateTimeInterval, this);
            this.feedUpdateTimer.setInitialDelay(0);
            this.feedUpdateTimer.setRepeats(true);
        } else {
            this.feedUpdateTimer = new Timer(0, this);
            this.feedUpdateTimer.setRepeats(false);
        }
    }

    public void start() {
        this.newsChangeTimer.start();
        this.feedUpdateTimer.start();
    }

    public void stop() {
        this.newsChangeTimer.stop();
        this.feedUpdateTimer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newsChangeTimer) {
            if (this.isOK()) {
                this.nextNews();
            }
        } else if (actionEvent.getSource() == this.feedUpdateTimer) {
            this.updateNewsFeed();
        }
    }

    public NewsFetcher getNewsFetcher() {
        return this.newsFetcher;
    }

    public News getCurrentNews() {
        return this.currentNews;
    }

    public void addNewsFeedEventListener(NewsFeedEventListener newsFeedEventListener) {
        this.listeners.add(newsFeedEventListener);
    }

    public void removeNewsFeedEventListener(NewsFeedEventListener newsFeedEventListener) {
        this.listeners.remove(newsFeedEventListener);
    }

    public void previousNews() {
        if (this.news.isEmpty()) {
            this.currentNews = new News();
            this.fireNewsFeedEvent(1);
            return;
        }
        int n = this.news.indexOf(this.currentNews);
        this.currentNews = --n >= 0 ? this.news.get(n) : this.news.get(this.news.size() - 1);
        this.fireNewsFeedEvent(1);
    }

    public void nextNews() {
        if (this.news.isEmpty()) {
            this.currentNews = new News();
            this.fireNewsFeedEvent(1);
            return;
        }
        int n = this.news.indexOf(this.currentNews);
        this.currentNews = ++n < this.news.size() ? this.news.get(n) : this.news.get(0);
        this.fireNewsFeedEvent(1);
    }

    private boolean isOK() {
        return this.news != null && !this.news.isEmpty();
    }

    public void updateNewsFeed() {
        this.news = new ArrayList<News>();
        try {
            this.newsFetcher.readSettings();
            if (!this.newsFetcher.isOK()) {
                return;
            }
            this.newsFetcher.fetchNews(this, this.news);
        }
        catch (Exception exception) {
            System.err.println(exception);
            this.fireNewsFeedErrorEvent(NewsFeedUIMessages.NEWS_FEED_UNAVAILABLE_ERROR);
        }
    }

    private void readSettings() {
        try {
            this.newsFetcher.readSettings();
            this.newsChangeTimeInterval = NewsFeedSettings.getIntSetting("newsChangeTimeInterval");
            if (this.newsChangeTimeInterval != -1) {
                this.newsChangeTimeInterval *= 1000;
            }
            this.feedUpdateTimeInterval = NewsFeedSettings.getIntSetting("feedUpdateTimeInterval");
            if (this.feedUpdateTimeInterval != -1) {
                this.feedUpdateTimeInterval *= 1000;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            this.fireNewsFeedErrorEvent(NewsFeedUIMessages.NEWS_FEED_CONFIGURATION_ERROR);
        }
    }

    public void fireNewsFeedEvent(int n) {
        NewsFeedEvent newsFeedEvent = new NewsFeedEvent(this, n);
        Iterator<NewsFeedEventListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().newsFeedEventReceived(newsFeedEvent);
        }
    }

    private void fireNewsFeedErrorEvent(String string) {
        NewsFeedErrorEvent newsFeedErrorEvent = new NewsFeedErrorEvent((Object)this, string);
        Iterator<NewsFeedEventListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().newsFeedEventReceived(newsFeedErrorEvent);
        }
    }
}

