/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.TreePath;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.filebrowser.FileBrowserRowSorter;
import org.scilab.modules.ui_data.filebrowser.FileNode;
import org.scilab.modules.ui_data.filebrowser.ScilabFileBrowserHistory;
import org.scilab.modules.ui_data.filebrowser.ScilabFileBrowserModel;
import org.scilab.modules.ui_data.filebrowser.ScilabFileSelectorComboBox;
import org.scilab.modules.ui_data.filebrowser.ScilabTreeTableCellRenderer;
import org.scilab.modules.ui_data.filebrowser.ScilabTreeTableModel;
import org.scilab.modules.ui_data.filebrowser.ScilabTreeTableModelAdapter;
import org.scilab.modules.ui_data.filebrowser.actions.ChangeCWDAction;
import org.scilab.modules.ui_data.filebrowser.actions.EditFileWithDefaultAppAction;
import org.scilab.modules.ui_data.filebrowser.actions.ExecuteFileInConsoleAction;
import org.scilab.modules.ui_data.filebrowser.actions.ExecuteFileInXcosAction;
import org.scilab.modules.ui_data.filebrowser.actions.ExecuteMatFileAction;
import org.scilab.modules.ui_data.filebrowser.actions.LoadFileAsGraphAction;
import org.scilab.modules.ui_data.filebrowser.actions.LoadFileInScilabAction;
import org.scilab.modules.ui_data.filebrowser.actions.OpenFileInSciNotesAction;
import org.scilab.modules.ui_data.filebrowser.actions.OpenFileWithDefaultAppAction;
import org.scilab.modules.ui_data.filebrowser.actions.ValidateAction;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class SwingScilabTreeTable
extends JTable {
    private static final Insets INSETS = new Insets(0, 2, 0, 0);
    private static final DateFormat DATEFORMAT = DateFormat.getDateTimeInstance(3, 2);
    private static final Border BORDER = new AbstractBorder(){

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawLine(n, n2, n, n2 + n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            return INSETS;
        }
    };
    private SwingWorker dirRefresher;
    private ScilabFileBrowserModel model;
    private Method isLocationInExpandControl;
    protected ScilabTreeTableCellRenderer tree;
    protected ScilabFileSelectorComboBox combobox;
    protected ScilabFileBrowserHistory history;

    public SwingScilabTreeTable(ScilabTreeTableModel scilabTreeTableModel, ScilabFileSelectorComboBox scilabFileSelectorComboBox) {
        this.combobox = scilabFileSelectorComboBox;
        scilabFileSelectorComboBox.setTreeTable(this);
        this.history = new ScilabFileBrowserHistory(this);
        this.tree = new ScilabTreeTableCellRenderer(this, scilabTreeTableModel);
        super.setModel(new ScilabTreeTableModelAdapter(scilabTreeTableModel, this.tree));
        this.setDefaultRenderer(ScilabTreeTableModel.class, this.tree);
        this.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            {
                this.setHorizontalTextPosition(2);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setText(DATEFORMAT.format((Date)object));
                if (n2 == 1) {
                    jLabel.setBorder(BORDER);
                }
                return jLabel;
            }
        });
        this.setDefaultRenderer(ScilabFileBrowserModel.FileSize.class, new DefaultTableCellRenderer(){
            {
                this.setHorizontalTextPosition(2);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setBorder(BORDER);
                }
                return component;
            }
        });
        this.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){
            {
                this.setHorizontalTextPosition(2);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setBorder(BORDER);
                }
                return component;
            }
        });
        this.setShowGrid(false);
        this.setFillsViewportHeight(true);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowSorter(new FileBrowserRowSorter(this.tree, this));
        this.setAutoResizeMode(1);
        try {
            this.isLocationInExpandControl = BasicTreeUI.class.getDeclaredMethod("isLocationInExpandControl", TreePath.class, Integer.TYPE, Integer.TYPE);
            this.isLocationInExpandControl.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = SwingScilabTreeTable.this.columnAtPoint(point);
                if (SwingScilabTreeTable.this.getColumnClass(n) == ScilabTreeTableModel.class && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    MouseEvent mouseEvent2 = mouseEvent;
                    if (SwingScilabTreeTable.this.isLocationInExpandControl != null) {
                        try {
                            int n2 = SwingScilabTreeTable.this.rowAtPoint(point);
                            TreePath treePath = SwingScilabTreeTable.this.tree.getPathForRow(n2);
                            boolean bl = (Boolean)SwingScilabTreeTable.this.isLocationInExpandControl.invoke((Object)SwingScilabTreeTable.this.tree.getUI(), treePath, mouseEvent.getX(), mouseEvent.getY());
                            Rectangle rectangle = SwingScilabTreeTable.this.tree.getRowBounds(n2);
                            if (!bl && !rectangle.contains(point)) {
                                mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), rectangle.x, rectangle.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    SwingScilabTreeTable.this.tree.dispatchEvent(mouseEvent2);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (Character.isLetter(c)) {
                    int n = 1;
                    if (Character.isUpperCase(c)) {
                        n = -1;
                    }
                    c = Character.toLowerCase(c);
                    int[] nArray = SwingScilabTreeTable.this.getSelectedRows();
                    int n2 = SwingScilabTreeTable.this.getRowCount();
                    int n3 = 0;
                    if (nArray != null && nArray.length != 0) {
                        n3 = SwingScilabTreeTable.modulo(nArray[0] + n, n2);
                    }
                    int n4 = n3;
                    while (n4 != n3 - n) {
                        char c2 = ((FileNode)SwingScilabTreeTable.this.tree.getPathForRow(n4).getLastPathComponent()).toString().charAt(0);
                        if ((c2 = Character.toLowerCase(c2)) == c) {
                            SwingScilabTreeTable.this.scrollRectToVisible(SwingScilabTreeTable.this.tree.getRowBounds(n4));
                            SwingScilabTreeTable.this.setRowSelectionInterval(n4, n4);
                            break;
                        }
                        n4 = SwingScilabTreeTable.modulo(n4 + n, n2);
                    }
                }
            }
        });
        this.initActions();
        this.setComponentPopupMenu(this.createPopup());
    }

    public JButton getNextButton() {
        return this.history.getNextButton();
    }

    public JButton getPreviousButton() {
        return this.history.getPreviousButton();
    }

    public ScilabFileSelectorComboBox getComboBox() {
        return this.combobox;
    }

    public String[] getSelectedPaths() {
        int[] nArray = this.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            TreePath treePath = this.tree.getPathForRow(nArray[i]);
            FileNode fileNode = (FileNode)treePath.getLastPathComponent();
            stringArray[i] = fileNode.getFile().getAbsolutePath();
        }
        return stringArray;
    }

    public File[] getSelectedFiles() {
        int[] nArray = this.getSelectedRows();
        File[] fileArray = new File[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            TreePath treePath = this.tree.getPathForRow(nArray[i]);
            FileNode fileNode = (FileNode)treePath.getLastPathComponent();
            fileArray[i] = fileNode.getFile();
        }
        return fileArray;
    }

    @Override
    public int getRowHeight(int n) {
        return this.getRowHeight();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public void setBaseDir(String string) {
        this.setBaseDir(string, true);
    }

    public synchronized void setBaseDir(String string, boolean bl) {
        ScilabFileBrowserModel scilabFileBrowserModel;
        boolean bl2 = false;
        if (this.dirRefresher != null) {
            this.dirRefresher.cancel(true);
            this.dirRefresher = null;
            scilabFileBrowserModel = this.model;
            this.model = null;
            bl2 = true;
        } else {
            scilabFileBrowserModel = (ScilabFileBrowserModel)this.tree.getModel();
        }
        this.combobox.setBaseDir(string);
        if (scilabFileBrowserModel != null) {
            boolean bl3 = string.equals(scilabFileBrowserModel.getBaseDir());
            File file = new File(string);
            if (bl2 || !bl3 && file.exists() && file.isDirectory() && file.canRead()) {
                this.tree.setModel(null);
                if (bl) {
                    this.history.addPathInHistory(string);
                }
                scilabFileBrowserModel.setBaseDir(string, this);
            }
        }
    }

    public void setFilter(Pattern pattern) {
        ScilabFileBrowserModel scilabFileBrowserModel = (ScilabFileBrowserModel)this.tree.getModel();
        TreePath treePath = new TreePath(scilabFileBrowserModel.getRoot());
        this.tree.setModel(null);
        scilabFileBrowserModel.setFilter(pattern);
        this.reload(scilabFileBrowserModel);
    }

    public void reload(ScilabFileBrowserModel scilabFileBrowserModel) {
        this.tree.setModel(scilabFileBrowserModel);
        this.tree.setRowHeight(this.getRowHeight());
        this.tree.setLargeModel(true);
        TreePath treePath = new TreePath(scilabFileBrowserModel.getRoot());
        this.tree.collapsePath(treePath);
        ((JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this)).getVerticalScrollBar().setValue(0);
        this.tree.expandPath(treePath);
        if (this.getRowCount() >= 1) {
            this.repaint(this.tree.getRowBounds(0));
        }
        this.editingRow = 0;
    }

    @Override
    public int getEditingRow() {
        if (this.getColumnClass(this.editingColumn) == ScilabTreeTableModel.class) {
            return -1;
        }
        return this.editingRow;
    }

    private void initActions() {
        final ActionMap actionMap = this.getActionMap();
        actionMap.put("scinotes", (Action)((Object)new OpenFileInSciNotesAction(this)));
        actionMap.put("xcos", (Action)((Object)new ExecuteFileInXcosAction(this)));
        actionMap.put("mat", (Action)((Object)new ExecuteMatFileAction(this)));
        actionMap.put("console", (Action)((Object)new ExecuteFileInConsoleAction(this)));
        actionMap.put("load", (Action)((Object)new LoadFileInScilabAction(this)));
        actionMap.put("graph", (Action)((Object)new LoadFileAsGraphAction(this)));
        actionMap.put("cwd", (Action)((Object)new ChangeCWDAction(this)));
        if (EditFileWithDefaultAppAction.isSupported()) {
            actionMap.put("edit", (Action)((Object)new EditFileWithDefaultAppAction(this)));
        }
        if (OpenFileWithDefaultAppAction.isSupported()) {
            actionMap.put("open", (Action)((Object)new OpenFileWithDefaultAppAction(this)));
        }
        actionMap.put("validate", (Action)((Object)new ValidateAction(this)));
        actionMap.put("validateorexpand", (Action)new CommonCallBack(null){

            public void callBack() {
                int[] nArray = SwingScilabTreeTable.this.getSelectedRows();
                if (nArray != null && nArray.length != 0) {
                    TreePath treePath = SwingScilabTreeTable.this.tree.getPathForRow(nArray[0]);
                    FileNode fileNode = (FileNode)treePath.getLastPathComponent();
                    if (fileNode.isLeaf()) {
                        ((CommonCallBack)actionMap.get("validate")).callBack();
                    } else {
                        if (SwingScilabTreeTable.this.tree.isExpanded(treePath)) {
                            SwingScilabTreeTable.this.tree.collapsePath(treePath);
                        } else {
                            SwingScilabTreeTable.this.tree.expandPath(treePath);
                        }
                        SwingScilabTreeTable.this.setRowSelectionInterval(nArray[0], nArray[0]);
                    }
                }
            }
        });
        this.combobox.setAction((CommonCallBack)actionMap.get("cwd"));
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "validateorexpand");
    }

    private JPopupMenu createPopup() {
        ActionMap actionMap = this.getActionMap();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(UiDataMessages.OPENINSCINOTES);
        jMenuItem.addActionListener(actionMap.get("scinotes"));
        jMenuItem.setIcon(new ImageIcon(FindIconHelper.findIcon((String)"accessories-text-editor")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(UiDataMessages.EXECINCONSOLE);
        jMenuItem.addActionListener(actionMap.get("console"));
        jMenuItem.setIcon(new ImageIcon(FindIconHelper.findIcon((String)"media-playback-start")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(UiDataMessages.OPENINXCOS);
        jMenuItem.addActionListener(actionMap.get("xcos"));
        jMenuItem.setIcon(new ImageIcon(FindIconHelper.findIcon((String)"utilities-system-monitor")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(UiDataMessages.LOADINSCILAB);
        jMenuItem.addActionListener(actionMap.get("load"));
        jMenuItem.setIcon(new ImageIcon(FindIconHelper.findIcon((String)"scilab")));
        jPopupMenu.add(jMenuItem);
        if (actionMap.get("edit") != null || actionMap.get("open") != null) {
            jPopupMenu.addSeparator();
        }
        if (actionMap.get("edit") != null) {
            jMenuItem = new JMenuItem(UiDataMessages.EDITWITHDEFAULT);
            jMenuItem.addActionListener(actionMap.get("edit"));
            jPopupMenu.add(jMenuItem);
        }
        if (actionMap.get("open") != null) {
            jMenuItem = new JMenuItem(UiDataMessages.OPENWITHDEFAULT);
            jMenuItem.addActionListener(actionMap.get("open"));
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.pack();
        return jPopupMenu;
    }

    public synchronized void setDirRefresher(SwingWorker swingWorker, ScilabFileBrowserModel scilabFileBrowserModel) {
        this.dirRefresher = swingWorker;
        this.model = scilabFileBrowserModel;
    }

    private static final int modulo(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        return n2 - -n % n2;
    }
}

