/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.filebrowser.FileNode;
import org.scilab.modules.ui_data.filebrowser.FileUtils;
import org.scilab.modules.ui_data.filebrowser.ScilabFileBrowserModel;
import org.scilab.modules.ui_data.filebrowser.SwingScilabTreeTable;

public class ScilabTreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private SwingScilabTreeTable table;
    protected int visibleRow;

    public ScilabTreeTableCellRenderer(SwingScilabTreeTable swingScilabTreeTable, TreeModel treeModel) {
        super(treeModel);
        this.table = swingScilabTreeTable;
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                FileNode fileNode = (FileNode)object;
                if (bl3) {
                    if (fileNode instanceof ScilabFileBrowserModel.ParentNode) {
                        this.setLeafIcon(FileUtils.getUpDirIcon());
                    } else {
                        this.setLeafIcon(fileNode.getIcon());
                    }
                } else if (fileNode.isUserHome()) {
                    this.setClosedIcon(FileUtils.getClosedUserHomeIcon());
                    this.setOpenIcon(FileUtils.getOpenUserHomeIcon());
                } else if (fileNode.isSCI()) {
                    this.setClosedIcon(FileUtils.getSCIIcon());
                    this.setOpenIcon(FileUtils.getOpenSCIIcon());
                } else {
                    this.setClosedIcon(FileUtils.getClosedDirIcon());
                    this.setOpenIcon(FileUtils.getOpenDirIcon());
                }
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                return this;
            }
        };
        this.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                ScilabTreeTableCellRenderer.this.table.setSelectionModel(this.listSelectionModel);
            }

            @Override
            public void setSelectionPaths(TreePath[] treePathArray) {
            }

            @Override
            public void addSelectionPaths(TreePath[] treePathArray) {
            }

            @Override
            public void removeSelectionPaths(TreePath[] treePathArray) {
            }
        });
        this.setCellRenderer(defaultTreeCellRenderer);
        this.setRootVisible(true);
        this.setRowHeight(swingScilabTreeTable.getRowHeight());
        this.setLargeModel(true);
        this.setEditable(true);
        this.setToggleClickCount(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = ScilabTreeTableCellRenderer.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = ScilabTreeTableCellRenderer.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    switch (mouseEvent.getClickCount()) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            ((CommonCallBack)ScilabTreeTableCellRenderer.this.table.getActionMap().get("validate")).callBack();
                            mouseEvent.consume();
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
                Container container = SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, ScilabTreeTableCellRenderer.this.table);
                if (container != null) {
                    container.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Container container = SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, ScilabTreeTableCellRenderer.this.table);
                if (container != null) {
                    container.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }
        };
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, 0, n3, this.table.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.translate(0, -this.visibleRow * this.getRowHeight());
        try {
            this.ui.update(graphics, this);
        }
        catch (NullPointerException nullPointerException) {
            graphics.translate(0, this.visibleRow * this.getRowHeight());
            this.paint(graphics);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        this.visibleRow = n;
        return this;
    }
}

