/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.filebrowser.SwingScilabTreeTable;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class ScilabFileSelectorComboBox
extends JComboBox
implements DocumentListener {
    private static final FileFilter DIRFILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static boolean isWindows = OS.get() == OS.WINDOWS;
    private int lastSize = -1;
    private String oldName = "";
    private TreeSet<String> currentSet;
    private JTextComponent textComponent;
    private boolean disableUpdateCombo;
    private boolean disableShowPopup;
    private boolean isValidate;
    private CommonCallBack validation;
    private SwingScilabTreeTable stt;
    private Color defaultFg;

    public ScilabFileSelectorComboBox() {
        this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.textComponent = (JTextComponent)this.getEditor().getEditorComponent();
        this.textComponent.getDocument().addDocumentListener(this);
        this.defaultFg = this.textComponent.getForeground();
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n != 27 && n != 10) {
                    ScilabFileSelectorComboBox.this.showPopup();
                } else if (n == 10) {
                    if (!ScilabFileSelectorComboBox.this.isValidate) {
                        ScilabFileSelectorComboBox.this.updateComboBoxLater();
                        if (!ScilabFileSelectorComboBox.this.currentSet.isEmpty()) {
                            ScilabFileSelectorComboBox.this.showPopup();
                        }
                    } else {
                        ScilabFileSelectorComboBox.this.isValidate = false;
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                ScilabFileSelectorComboBox.this.disableUpdateCombo = n == 40 || n == 225 || n == 34 || n == 38 || n == 224 || n == 33 || n == 35 || n == 65368;
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                if (keyEvent.getKeyCode() == 9 && keyEvent.getID() == 402 && keyEvent.getSource() == ScilabFileSelectorComboBox.this.textComponent) {
                    ScilabFileSelectorComboBox.this.updateComboBoxLater();
                    String string = ScilabFileSelectorComboBox.this.getCommonPart();
                    ScilabFileSelectorComboBox.this.getEditor().setItem(string);
                    ScilabFileSelectorComboBox.this.showPopup();
                    keyEvent.consume();
                }
            }
        }, 8L);
        this.setEditable(true);
        this.textComponent.setComponentPopupMenu(this.createPopup());
    }

    public void setTreeTable(SwingScilabTreeTable swingScilabTreeTable) {
        this.stt = swingScilabTreeTable;
    }

    public void setAction(CommonCallBack commonCallBack) {
        this.validation = commonCallBack;
        this.textComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ScilabFileSelectorComboBox.this.isValidate = true;
                    ScilabFileSelectorComboBox.this.validation.callBack();
                    ScilabFileSelectorComboBox.this.hidePopup();
                    keyEvent.consume();
                }
            }
        });
    }

    public void setBaseDirAndValidate(String string) {
        this.disableUpdateCombo = true;
        this.textComponent.getDocument().removeDocumentListener(this);
        this.getEditor().setItem(string);
        this.validation.callBack();
        this.disableUpdateCombo = false;
    }

    public void setBaseDir(String object) {
        if (!((String)object).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        this.disableShowPopup = true;
        this.textComponent.setText((String)object);
        this.disableShowPopup = false;
    }

    public String getBaseDir() {
        return ScilabFileSelectorComboBox.getTruePath(this.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.testPathValidity();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.testPathValidity();
    }

    private void testPathValidity() {
        File file = new File(this.getText());
        if (file.exists() && file.isDirectory() && file.canRead()) {
            this.textComponent.setForeground(this.defaultFg);
            this.updateComboBox();
        } else {
            this.textComponent.setForeground(Color.RED);
        }
    }

    private String getText() {
        int n = this.textComponent.getDocument().getLength();
        try {
            return this.textComponent.getDocument().getText(0, n);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private static final String getTruePath(String string) {
        if (string != null) {
            if (string.startsWith("SCI\\") || string.startsWith("SCI/") || string.startsWith("SCI")) {
                return string.replaceFirst("SCI", ScilabConstants.SCI.getAbsolutePath());
            }
            if (string.startsWith("~\\") || string.startsWith("~/") || string.startsWith("~")) {
                return string.replaceFirst("~", ScilabConstants.USERHOME);
            }
            if (string.startsWith("TMPDIR\\") || string.startsWith("TMPDIR/") || string.startsWith("TMPDIR")) {
                return string.replaceFirst("TMPDIR", ScilabConstants.TMPDIR.getAbsolutePath());
            }
        }
        boolean bl = true;
        for (int i = 0; i < 5 && bl; ++i) {
            try {
                string = new File(string).getCanonicalPath();
                bl = false;
                continue;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    private static final String getTruePath(String string, String string2) {
        if (string != null && string2 != null) {
            if (string2.equals("SCI")) {
                return string.replaceFirst("SCI", ScilabConstants.SCI.getAbsolutePath());
            }
            if (string2.equals("~")) {
                return string.replaceFirst("~", ScilabConstants.USERHOME);
            }
            if (string2.equals("TMPDIR")) {
                return string.replaceFirst("TMPDIR", ScilabConstants.TMPDIR.getAbsolutePath());
            }
        }
        return string;
    }

    private static final String getJoker(String string) {
        if (string != null) {
            if (string.startsWith("SCI\\") || string.startsWith("SCI/")) {
                return "SCI";
            }
            if (string.startsWith("~\\") || string.startsWith("~/")) {
                return "~";
            }
            if (string.startsWith("TMPDIR\\") || string.startsWith("TMPDIR/")) {
                return "TMPDIR";
            }
        }
        return null;
    }

    private static final String getFakePath(String string, String string2) {
        if (string != null && string2 != null) {
            if (string2.equals("SCI")) {
                return string.replaceFirst(ScilabConstants.SCI.getAbsolutePath(), "SCI");
            }
            if (string2.equals("~")) {
                return string.replaceFirst(ScilabConstants.USERHOME, "~");
            }
            if (string2.equals("TMPDIR")) {
                return string.replaceFirst(ScilabConstants.TMPDIR.getAbsolutePath(), "TMPDIR");
            }
        }
        return string;
    }

    private static final File getFileDirectory(String string) {
        File file = new File(string);
        if (string.endsWith(File.separator) && file.isDirectory()) {
            return file;
        }
        File file2 = file.getParentFile();
        if (file2 != null && file2.isDirectory()) {
            return file2;
        }
        return null;
    }

    private String getCommonPart() {
        if (this.currentSet != null && !this.currentSet.isEmpty()) {
            if (this.currentSet.size() == 1) {
                return this.currentSet.first();
            }
            String string = new File(this.currentSet.first()).getParent();
            int n = 0;
            if (string != null) {
                n = string.length();
            }
            int n2 = Integer.MAX_VALUE;
            char[][] cArrayArray = new char[this.currentSet.size()][];
            int n3 = 0;
            for (String string2 : this.currentSet) {
                cArrayArray[n3] = string2.substring(n).toCharArray();
                if (cArrayArray[n3].length < n2) {
                    n2 = cArrayArray[n3].length;
                }
                ++n3;
            }
            int n4 = cArrayArray.length;
            for (n3 = 0; n3 < n2 && n4 == cArrayArray.length; ++n3) {
                char c;
                if (isWindows) {
                    c = Character.toLowerCase(cArrayArray[0][n3]);
                    for (n4 = 1; n4 < cArrayArray.length && Character.toLowerCase(cArrayArray[n4][n3]) == c; ++n4) {
                    }
                    continue;
                }
                c = cArrayArray[0][n3];
                for (n4 = 1; n4 < cArrayArray.length && cArrayArray[n4][n3] == c; ++n4) {
                }
            }
            String string3 = new String(cArrayArray[0], 0, n3 - 1);
            if (isWindows) {
                int n5 = n3 - 1;
                for (n4 = 1; n4 < cArrayArray.length && n5 == n3 - 1; ++n4) {
                    for (n5 = 0; n5 < n3 - 1 && cArrayArray[n4][n5] == cArrayArray[0][n5]; ++n5) {
                    }
                }
                if (n4 != cArrayArray.length) {
                    string3 = string3.toLowerCase();
                }
            }
            if (n != 0) {
                return string + string3;
            }
            return string3;
        }
        return this.getText();
    }

    private void updateComboBox() {
        final boolean bl = this.disableShowPopup;
        this.textComponent.getDocument().removeDocumentListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ScilabFileSelectorComboBox.this.disableUpdateCombo) {
                    ScilabFileSelectorComboBox.this.updateComboBoxLater(bl);
                }
                ScilabFileSelectorComboBox.this.textComponent.getDocument().addDocumentListener(ScilabFileSelectorComboBox.this);
            }
        });
    }

    private void updateComboBoxLater() {
        this.updateComboBoxLater(false);
    }

    /*
     * WARNING - void declaration
     */
    private void updateComboBoxLater(boolean bl) {
        String string = this.getText();
        if (string != null && !string.equals(this.oldName)) {
            File object;
            String string2 = ScilabFileSelectorComboBox.getJoker(string);
            String string3 = ScilabFileSelectorComboBox.getTruePath(string, string2);
            this.oldName = string;
            TreeSet<Object> treeSet = null;
            File[] fileArray = string3.isEmpty() ? File.listRoots() : ((object = ScilabFileSelectorComboBox.getFileDirectory(string3)) != null ? object.listFiles(DIRFILTER) : File.listRoots());
            treeSet = isWindows ? new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    int n = string.compareToIgnoreCase(string2);
                    if (n == 0) {
                        n = string.compareTo(string2);
                    }
                    return n;
                }

                @Override
                public boolean equals(Object object) {
                    return false;
                }
            }) : new TreeSet();
            for (File file : fileArray) {
                String string4 = File.separator;
                if (file.getParent() == null) {
                    string4 = "";
                }
                treeSet.add(ScilabFileSelectorComboBox.getFakePath(file.getAbsolutePath(), string2) + string4);
            }
            if (treeSet != null) {
                String string5 = "";
                int n = string.length();
                if (n != 0) {
                    void var7_13;
                    if (n == 1) {
                        String string6 = new String(new char[]{(char)(string.charAt(0) + '\u0001')});
                    } else {
                        String string8 = string.substring(0, n - 1);
                        string8 = string8 + (char)(string.charAt(n - 1) + '\u0001');
                    }
                    this.currentSet = (TreeSet)treeSet.subSet(string, true, var7_13, false);
                } else {
                    this.currentSet = treeSet;
                }
                if (this.currentSet != null && this.currentSet.size() != this.lastSize) {
                    this.hidePopup();
                    this.removeAllItems();
                    for (String string9 : this.currentSet) {
                        this.addItem(string9);
                    }
                    this.lastSize = this.currentSet.size();
                }
            }
            this.setSelectedIndex(-1);
            this.getEditor().setItem(string);
            this.textComponent.setSelectionStart(this.textComponent.getSelectionEnd());
            if (this.isShowing()) {
                this.setPopupVisible(!bl);
            }
        }
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(UiDataMessages.CUT);
        jMenuItem.addActionListener(new DefaultEditorKit.CutAction());
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(UiDataMessages.COPY);
        jMenuItem.addActionListener(new DefaultEditorKit.CopyAction());
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(UiDataMessages.PASTE);
        jMenuItem.addActionListener(new DefaultEditorKit.PasteAction());
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(UiDataMessages.CLEAR);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScilabFileSelectorComboBox.this.textComponent.setText("");
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }
}

