/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.filebrowser.SwingScilabTreeTable;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class ScilabFileBrowserHistory {
    private static final String PREVIOUSICON = FindIconHelper.findIcon((String)"go-previous");
    private static final String NEXTICON = FindIconHelper.findIcon((String)"go-next");
    private final SwingScilabTreeTable stt;
    private final List<String> history = new ArrayList<String>();
    private int position = -1;
    private final JButton previous;
    private final JButton next;
    private final JPopupMenu popup;
    private Timer timer;

    public ScilabFileBrowserHistory(SwingScilabTreeTable swingScilabTreeTable) {
        this.stt = swingScilabTreeTable;
        this.popup = new JPopupMenu();
        this.popup.setBorderPainted(true);
        this.previous = new JButton();
        this.previous.setIcon(new ImageIcon(PREVIOUSICON));
        ScilabLAF.setDefaultProperties((AbstractButton)this.previous);
        this.previous.setToolTipText(UiDataMessages.PREVIOUSDIR);
        this.previous.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ScilabFileBrowserHistory.this.timer == null) {
                    ScilabFileBrowserHistory.this.timer = new Timer();
                    ScilabFileBrowserHistory.this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (!ScilabFileBrowserHistory.this.popup.isVisible() || ScilabFileBrowserHistory.this.popup.getInvoker() != ScilabFileBrowserHistory.this.next) {
                                ScilabFileBrowserHistory.this.showPopup(true);
                            }
                        }
                    }, 1000L);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (ScilabFileBrowserHistory.this.timer != null) {
                    ScilabFileBrowserHistory.this.timer.cancel();
                    ScilabFileBrowserHistory.this.timer = null;
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && ScilabFileBrowserHistory.this.previous.isEnabled() && (!ScilabFileBrowserHistory.this.popup.isVisible() || ScilabFileBrowserHistory.this.popup.getInvoker() != ScilabFileBrowserHistory.this.previous)) {
                    ScilabFileBrowserHistory.this.showPopup(true);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && !ScilabFileBrowserHistory.this.popup.isVisible() && ScilabFileBrowserHistory.this.previous.isEnabled()) {
                    ScilabFileBrowserHistory.this.stt.setBaseDir(ScilabFileBrowserHistory.this.history.get(ScilabFileBrowserHistory.this.position - 1), false);
                    ScilabFileBrowserHistory.chDir(ScilabFileBrowserHistory.this.history.get(ScilabFileBrowserHistory.this.position - 1));
                    ScilabFileBrowserHistory.this.setPositionInHistory(ScilabFileBrowserHistory.this.position - 1);
                }
            }
        });
        this.next = new JButton();
        this.next.setIcon(new ImageIcon(NEXTICON));
        ScilabLAF.setDefaultProperties((AbstractButton)this.next);
        this.next.setToolTipText(UiDataMessages.NEXTDIR);
        this.next.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ScilabFileBrowserHistory.this.timer == null) {
                    ScilabFileBrowserHistory.this.timer = new Timer();
                    ScilabFileBrowserHistory.this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (!ScilabFileBrowserHistory.this.popup.isVisible() || ScilabFileBrowserHistory.this.popup.getInvoker() != ScilabFileBrowserHistory.this.next) {
                                ScilabFileBrowserHistory.this.showPopup(false);
                            }
                        }
                    }, 1000L);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (ScilabFileBrowserHistory.this.timer != null) {
                    ScilabFileBrowserHistory.this.timer.cancel();
                    ScilabFileBrowserHistory.this.timer = null;
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && ScilabFileBrowserHistory.this.next.isEnabled() && (!ScilabFileBrowserHistory.this.popup.isVisible() || ScilabFileBrowserHistory.this.popup.getInvoker() != ScilabFileBrowserHistory.this.next)) {
                    ScilabFileBrowserHistory.this.showPopup(false);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && !ScilabFileBrowserHistory.this.popup.isVisible() && ScilabFileBrowserHistory.this.next.isEnabled()) {
                    ScilabFileBrowserHistory.this.stt.setBaseDir(ScilabFileBrowserHistory.this.history.get(ScilabFileBrowserHistory.this.position + 1), false);
                    ScilabFileBrowserHistory.chDir(ScilabFileBrowserHistory.this.history.get(ScilabFileBrowserHistory.this.position + 1));
                    ScilabFileBrowserHistory.this.setPositionInHistory(ScilabFileBrowserHistory.this.position + 1);
                }
            }
        });
        this.updateButton(0);
    }

    private void showPopup(boolean bl) {
        this.popup.removeAll();
        if (bl) {
            var2_2 = this.position - 1;
            while (var2_2 >= 0) {
                JMenuItem jMenuItem = new JMenuItem(this.history.get(var2_2));
                final int n = var2_2--;
                jMenuItem.addActionListener((ActionListener)new CommonCallBack(null){

                    public void callBack() {
                        ScilabFileBrowserHistory.this.stt.setBaseDir(ScilabFileBrowserHistory.this.history.get(n), false);
                        ScilabFileBrowserHistory.chDir(ScilabFileBrowserHistory.this.history.get(n));
                        ScilabFileBrowserHistory.this.setPositionInHistory(n);
                    }
                });
                this.popup.add(jMenuItem);
            }
        } else {
            var2_2 = this.position + 1;
            while (var2_2 < this.history.size()) {
                JMenuItem jMenuItem = new JMenuItem(this.history.get(var2_2));
                final int n = var2_2++;
                jMenuItem.addActionListener((ActionListener)new CommonCallBack(null){

                    public void callBack() {
                        ScilabFileBrowserHistory.this.stt.setBaseDir(ScilabFileBrowserHistory.this.history.get(n), false);
                        ScilabFileBrowserHistory.chDir(ScilabFileBrowserHistory.this.history.get(n));
                        ScilabFileBrowserHistory.this.setPositionInHistory(n);
                    }
                });
                this.popup.add(jMenuItem);
            }
        }
        this.popup.pack();
        JButton jButton = bl ? this.previous : this.next;
        this.popup.show(jButton, 0, jButton.getBounds(null).height);
    }

    private static final void chDir(String string) {
        File file = new File(string);
        if (file.exists() && file.isDirectory() && file.canRead()) {
            InterpreterManagement.requestScilabExec((String)("chdir('" + string + "');"));
        }
    }

    public void addPathInHistory(String string) {
        this.history.add(string);
        this.setPositionInHistory(this.position + 1);
    }

    public JButton getPreviousButton() {
        return this.previous;
    }

    public JButton getNextButton() {
        return this.next;
    }

    private void setPositionInHistory(int n) {
        this.position = n;
        this.updateButton(n);
    }

    private void updateButton(int n) {
        this.previous.setEnabled(this.history.size() >= 2 && n != 0);
        this.next.setEnabled(this.history.size() >= 2 && n != this.history.size() - 1);
    }
}

