/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.awt.Component;
import javax.swing.SwingUtilities;
import org.flexdock.view.View;
import org.scilab.modules.commons.gui.ScilabGUIUtilities;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.ui_data.filebrowser.SwingScilabFileBrowser;
import org.scilab.modules.ui_data.tabfactory.FileBrowserTab;
import org.scilab.modules.ui_data.tabfactory.FileBrowserTabFactory;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public final class ScilabFileBrowser {
    private static SwingScilabFileBrowser instance;

    private ScilabFileBrowser() {
        TextBox textBox = ScilabTextBox.createTextBox();
        instance = new SwingScilabFileBrowser();
        instance.addInfoBar(textBox);
        instance.setTitle(UiDataMessages.FILE_BROWSER);
    }

    public static SwingScilabFileBrowser createFileBrowserTab() {
        if (instance == null) {
            new ScilabFileBrowser();
        }
        return instance;
    }

    public static boolean isFileBrowserOpened() {
        return instance != null;
    }

    public static void setBaseDir(String string) {
        if (instance != null) {
            instance.setBaseDir(string);
        }
    }

    public static SwingScilabFileBrowser getFileBrowser() {
        if (instance == null) {
            boolean bl = WindowsConfigurationManager.restoreUUID((String)"3b649047-6a71-4998-bd8e-00d367a4793d");
            if (!bl) {
                FileBrowserTab.getFileBrowserInstance();
                SwingScilabWindow swingScilabWindow = SwingScilabWindow.createWindow((boolean)true);
                swingScilabWindow.addTab((SwingScilabPanel)instance);
                swingScilabWindow.setLocation(0, 0);
                swingScilabWindow.setSize(500, 500);
                swingScilabWindow.setVisible(true);
            }
        } else {
            int n;
            SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)instance));
            if (swingScilabWindow != null && ((n = swingScilabWindow.getExtendedState()) & 1) == 1) {
                swingScilabWindow.setExtendedState(n - 1);
            }
        }
        ScilabGUIUtilities.toFront((View)instance, (String)UiDataMessages.FILE_BROWSER);
        return instance;
    }

    public static void closeFileBrowser() {
        if (instance != null) {
            instance.close();
            instance = null;
        }
    }

    public void close() {
        instance = null;
    }

    public void setVisible(boolean bl) {
        instance.setVisible(bl);
    }

    static {
        ScilabTabFactory.getInstance().addTabFactory((AbstractScilabTabFactory)FileBrowserTabFactory.getInstance());
    }
}

