/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.bridge.checkboxmenuitem.SwingScilabCheckBoxMenuItem;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.checkboxmenuitem.CheckBoxMenuItem;
import org.scilab.modules.gui.checkboxmenuitem.ScilabCheckBoxMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;

public abstract class DefaultAction
extends CommonCallBack {
    public DefaultAction() {
        super("", -1);
        this.installProperties();
    }

    private void installProperties() {
        String string = "";
        ImageIcon imageIcon = null;
        int n = 0;
        int n2 = 0;
        try {
            string = (String)((Object)((Object)this)).getClass().getField("NAME").get(null);
            String string2 = (String)((Object)((Object)this)).getClass().getField("SMALL_ICON").get(null);
            if (string2 != null && !string2.isEmpty()) {
                imageIcon = new ImageIcon(FindIconHelper.findIcon((String)string2));
            }
            n = ((Object)((Object)this)).getClass().getField("MNEMONIC_KEY").getInt(null);
            n2 = ((Object)((Object)this)).getClass().getField("ACCELERATOR_KEY").getInt(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        assert (!"".equals(string));
        this.putValue("Name", string);
        this.putValue("ShortDescription", string);
        this.putValue("LongDescription", string);
        if (imageIcon != null) {
            this.putValue("SmallIcon", imageIcon);
        }
        if (n != 0) {
            this.putValue("MnemonicKey", n);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(n, n2));
        }
    }

    protected static MenuItem createMenu(CommonCallBack commonCallBack) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        SwingScilabMenuItem swingScilabMenuItem = (SwingScilabMenuItem)menuItem.getAsSimpleMenuItem();
        swingScilabMenuItem.setAction((Action)commonCallBack);
        return menuItem;
    }

    protected static JButton createButton(CommonCallBack commonCallBack) {
        JButton jButton = new JButton();
        jButton.setAction((Action)commonCallBack);
        jButton.setText("");
        return jButton;
    }

    protected static CheckBoxMenuItem createCheckBoxMenu(CommonCallBack commonCallBack) {
        CheckBoxMenuItem checkBoxMenuItem = ScilabCheckBoxMenuItem.createCheckBoxMenuItem();
        SwingScilabCheckBoxMenuItem swingScilabCheckBoxMenuItem = (SwingScilabCheckBoxMenuItem)checkBoxMenuItem.getAsSimpleCheckBoxMenuItem();
        swingScilabCheckBoxMenuItem.setAction((Action)commonCallBack);
        return checkBoxMenuItem;
    }

    public abstract void actionPerformed(ActionEvent var1);

    public void callBack() {
        assert ("Must never be called as we bypass Callback.java".equals(""));
    }
}

