/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.utils;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SplitBlock;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.Orientation;

public abstract class XcosRouteUtils {
    public static final double ALIGN_STRICT_ERROR = 2.0;
    public static final double ALIGN_SPLITBLOCK_ERROR = 10.0;
    public static final double BEAUTY_AWAY_DISTANCE = 40.0;
    public static final double BEAUTY_AWAY_REVISION = 10.0;
    public static final double SPLITBLOCK_AWAY_DISTANCE = 15.0;
    public static final double NORMAL_BLOCK_SIZE = 40.0;
    public static final int TRY_TIMES = 3;

    protected static boolean isStrictlyAligned(double d, double d2, double d3, double d4) {
        double d5 = 2.0;
        if (Math.abs(d3 - d) < d5) {
            return true;
        }
        return Math.abs(d4 - d2) < d5;
    }

    protected static List<mxPoint> getLinkPoints(BasicLink basicLink) {
        mxPoint mxPoint2;
        mxGeometry mxGeometry2;
        mxGeometry mxGeometry3;
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(0);
        mxICell mxICell2 = basicLink.getSource();
        if (mxICell2 != null) {
            mxGeometry3 = mxICell2.getGeometry();
            double d = mxGeometry3.getCenterX();
            double d2 = mxGeometry3.getCenterY();
            mxICell mxICell3 = mxICell2.getParent();
            mxGeometry2 = mxICell3.getGeometry();
            if (mxGeometry2 == null) {
                mxGeometry2 = new mxGeometry(0.0, 0.0, 0.0, 0.0);
            }
            if ((mxPoint2 = mxGeometry3.getOffset()) == null) {
                mxPoint2 = new mxPoint(0.0, 0.0);
            }
            if (mxGeometry3.isRelative()) {
                d = mxGeometry2.getX() + mxGeometry3.getX() * mxGeometry2.getWidth() + mxPoint2.getX();
                d2 = mxGeometry2.getY() + mxGeometry3.getY() * mxGeometry2.getHeight() + mxPoint2.getY();
            } else {
                d = mxGeometry2.getX() + mxGeometry3.getX() + mxPoint2.getX();
                d2 = mxGeometry2.getY() + mxGeometry3.getY() + mxPoint2.getY();
            }
            arrayList.add(new mxPoint(d, d2));
        }
        if (basicLink.getGeometry().getPoints() != null) {
            arrayList.addAll(basicLink.getGeometry().getPoints());
        }
        if ((mxGeometry3 = basicLink.getTarget()) != null) {
            mxGeometry mxGeometry4 = mxGeometry3.getGeometry();
            double d = mxGeometry4.getCenterX();
            double d3 = mxGeometry4.getCenterY();
            mxGeometry2 = mxGeometry3.getParent();
            mxGeometry mxGeometry5 = mxGeometry2.getGeometry();
            if (mxGeometry5 == null) {
                mxGeometry5 = new mxGeometry(0.0, 0.0, 0.0, 0.0);
            }
            if ((mxPoint2 = mxGeometry4.getOffset()) == null) {
                mxPoint2 = new mxPoint(0.0, 0.0);
            }
            if (mxGeometry4.isRelative()) {
                d = mxGeometry5.getX() + mxGeometry4.getX() * mxGeometry5.getWidth() + mxPoint2.getX();
                d3 = mxGeometry5.getY() + mxGeometry4.getY() * mxGeometry5.getHeight() + mxPoint2.getY();
            } else {
                d = mxGeometry5.getX() + mxGeometry4.getX() + mxPoint2.getX();
                d3 = mxGeometry5.getY() + mxGeometry4.getY() + mxPoint2.getY();
            }
            arrayList.add(new mxPoint(d, d3));
        }
        return arrayList;
    }

    protected static boolean checkObstacle(double d, double d2, double d3, double d4, Object[] objectArray) {
        return XcosRouteUtils.checkObstacle(d, d2, d3, d4, objectArray, false);
    }

    protected static boolean checkObstacle(double d, double d2, double d3, double d4, Object[] objectArray, boolean bl) {
        for (Object object : objectArray) {
            mxPoint mxPoint2;
            BasicLink basicLink;
            if (!(object instanceof mxCell)) continue;
            mxCell mxCell2 = (mxCell)object;
            if (mxCell2 instanceof BasicLink) {
                basicLink = (BasicLink)mxCell2;
                if (XcosRouteUtils.checkLinesIntersection(d, d2, d3, d4, basicLink) && bl) {
                    return true;
                }
                if (XcosRouteUtils.checkLinesCoincide(d, d2, d3, d4, basicLink)) {
                    return true;
                }
                if (!XcosRouteUtils.pointInLink(d, d2, basicLink) && !XcosRouteUtils.pointInLink(d3, d4, basicLink)) continue;
                return true;
            }
            basicLink = mxCell2.getGeometry();
            mxGeometry mxGeometry2 = new mxGeometry(basicLink.getX(), basicLink.getY(), basicLink.getWidth(), basicLink.getHeight());
            if (mxCell2.getParent().getGeometry() != null && mxCell2 instanceof BasicPort) {
                double d5 = mxCell2.getParent().getGeometry().getX() + mxGeometry2.getX();
                mxGeometry2.setX(d5);
                double d6 = mxCell2.getParent().getGeometry().getY() + mxGeometry2.getY();
                mxGeometry2.setY(d6);
            }
            if ((mxPoint2 = mxGeometry2.intersectLine(d, d2, d3, d4)) == null) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkPointInBlocks(double d, double d2, Object[] objectArray) {
        for (Object object : objectArray) {
            if (!(object instanceof BasicBlock)) continue;
            BasicBlock basicBlock = (BasicBlock)object;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            mxGeometry mxGeometry2 = basicBlock.getGeometry();
            for (int i = 0; i < basicBlock.getChildCount(); ++i) {
                mxICell mxICell2 = basicBlock.getChildAt(i);
                if (mxICell2.getGeometry() == null) continue;
                mxGeometry mxGeometry3 = new mxGeometry(mxICell2.getGeometry().getX(), mxICell2.getGeometry().getY(), mxICell2.getGeometry().getWidth(), mxICell2.getGeometry().getHeight());
                if (mxICell2.getGeometry().isRelative()) {
                    mxGeometry3.setX(mxGeometry2.getWidth() * mxGeometry3.getX());
                    mxGeometry3.setY(mxGeometry2.getHeight() * mxGeometry3.getY());
                }
                if (mxGeometry3.getX() < 0.0) {
                    d3 = mxGeometry3.getX();
                    d5 = Math.abs(d3);
                }
                if (mxGeometry3.getX() + mxGeometry3.getWidth() > mxGeometry2.getWidth()) {
                    d5 += mxGeometry3.getX() + mxGeometry3.getWidth() - mxGeometry2.getWidth();
                }
                if (mxGeometry3.getY() < 0.0) {
                    d4 = mxGeometry3.getY();
                    d6 = Math.abs(d4);
                }
                if (!(mxGeometry3.getY() + mxGeometry3.getHeight() > Math.max(basicBlock.getGeometry().getHeight(), d6))) continue;
                d6 += mxGeometry3.getY() + mxGeometry3.getHeight() - mxGeometry2.getHeight();
            }
            double d7 = mxGeometry2.getX() + d3;
            double d8 = mxGeometry2.getY() + d4;
            double d9 = mxGeometry2.getWidth() + d5;
            double d10 = mxGeometry2.getHeight() + d6;
            if (!(d >= d7) || !(d <= d7 + d9) || !(d2 >= d8) || !(d2 <= d8 + d10)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkPointInGeometry(double d, double d2, mxGeometry mxGeometry2) {
        boolean bl = false;
        bl = d >= mxGeometry2.getX() && d <= mxGeometry2.getX() + mxGeometry2.getWidth() && d2 >= mxGeometry2.getY() && d2 <= mxGeometry2.getY() + mxGeometry2.getHeight();
        return bl;
    }

    private static boolean checkLinesIntersection(double d, double d2, double d3, double d4, BasicLink basicLink) {
        List<mxPoint> list = XcosRouteUtils.getLinkPoints(basicLink);
        if (list != null && list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                double d5;
                double d6;
                double d7;
                mxPoint mxPoint2 = list.get(i - 1);
                mxPoint mxPoint3 = list.get(i);
                double d8 = mxPoint2.getX();
                mxPoint mxPoint4 = mxUtils.intersection((double)d, (double)d2, (double)d3, (double)d4, (double)d8, (double)(d7 = mxPoint2.getY()), (double)(d6 = mxPoint3.getX()), (double)(d5 = mxPoint3.getY()));
                if (mxPoint4 == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkLinesCoincide(double d, double d2, double d3, double d4, BasicLink basicLink) {
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(0);
        if (basicLink.getGeometry().getPoints() != null && basicLink.getGeometry().getPoints().size() != 0) {
            if (XcosRouteUtils.getLinkPortPosition(basicLink, true) != null) {
                arrayList.add(XcosRouteUtils.getLinkPortPosition(basicLink, true));
            }
            arrayList.addAll(basicLink.getGeometry().getPoints());
            if (XcosRouteUtils.getLinkPortPosition(basicLink, false) != null) {
                arrayList.add(XcosRouteUtils.getLinkPortPosition(basicLink, false));
            }
            for (int i = 1; i < arrayList.size(); ++i) {
                double d5;
                double d6;
                double d7;
                mxPoint mxPoint2 = (mxPoint)arrayList.get(i - 1);
                mxPoint mxPoint3 = (mxPoint)arrayList.get(i);
                double d8 = mxPoint2.getX();
                if (!XcosRouteUtils.linesCoincide(d, d2, d3, d4, d8, d7 = mxPoint2.getY(), d6 = mxPoint3.getX(), d5 = mxPoint3.getY())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean linesCoincide(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        block4: {
            block3: {
                if (XcosRouteUtils.linesStrictlyCoincide(d = (double)Math.round(d), d2 = (double)Math.round(d2), d3 = (double)Math.round(d3), d4 = (double)Math.round(d4), d5 = (double)Math.round(d5), d6 = (double)Math.round(d6), d7 = (double)Math.round(d7), d8 = (double)Math.round(d8))) {
                    return true;
                }
                if (d != d3) break block3;
                for (double d9 = d - 2.0; d9 < d + 2.0; d9 += 1.0) {
                    if (!XcosRouteUtils.linesStrictlyCoincide(d9 = (double)Math.round(d9), d2, d9, d4, d5, d6, d7, d8)) continue;
                    return true;
                }
                break block4;
            }
            if (d2 != d4) break block4;
            for (double d10 = d2 - 2.0; d10 < d2 + 2.0; d10 += 1.0) {
                if (!XcosRouteUtils.linesStrictlyCoincide(d, d10 = (double)Math.round(d10), d3, d10, d5, d6, d7, d8)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean linesStrictlyCoincide(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (XcosRouteUtils.pointInLineSegment(d, d2, d5, d6, d7, d8) && XcosRouteUtils.pointInLineSegment(d3, d4, d5, d6, d7, d8)) {
            return true;
        }
        if (XcosRouteUtils.pointInLineSegment(d5, d6, d, d2, d3, d4) && XcosRouteUtils.pointInLineSegment(d7, d8, d, d2, d3, d4)) {
            return true;
        }
        double d9 = (d - d3) * (d6 - d8) - (d2 - d4) * (d5 - d7);
        return d9 == 0.0 && (XcosRouteUtils.pointInLineSegment(d, d2, d5, d6, d7, d8) || XcosRouteUtils.pointInLineSegment(d3, d4, d5, d6, d7, d8) || XcosRouteUtils.pointInLineSegment(d5, d6, d, d2, d3, d4) || XcosRouteUtils.pointInLineSegment(d7, d8, d, d2, d3, d4));
    }

    public static mxPoint getIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (XcosRouteUtils.linesStrictlyCoincide(d = (double)Math.round(d), d2 = (double)Math.round(d2), d3 = (double)Math.round(d3), d4 = (double)Math.round(d4), d5 = (double)Math.round(d5), d6 = (double)Math.round(d6), d7 = (double)Math.round(d7), d8 = (double)Math.round(d8))) {
            if (XcosRouteUtils.pointInLineSegment(d3, d4, d5, d6, d7, d8)) {
                return new mxPoint(d3, d4);
            }
            if (XcosRouteUtils.pointInLineSegment(d7, d8, d, d2, d3, d4)) {
                return new mxPoint(d7, d8);
            }
        }
        return mxUtils.intersection((double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6, (double)d7, (double)d8);
    }

    private static boolean pointInLink(double d, double d2, BasicLink basicLink) {
        List<mxPoint> list = basicLink.getPoints(0, false);
        return XcosRouteUtils.pointInLink(d, d2, list);
    }

    protected static boolean pointInLink(double d, double d2, List<mxPoint> list) {
        if (list != null && list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                mxPoint mxPoint2 = list.get(i - 1);
                mxPoint mxPoint3 = list.get(i);
                double d3 = mxPoint2.getX();
                double d4 = mxPoint2.getY();
                double d5 = mxPoint3.getX();
                double d6 = mxPoint3.getY();
                if (d3 == d5 && d != d3 || d4 == d6 && d2 != d4 || !XcosRouteUtils.pointInLineSegment(d, d2, d3, d4, d5, d6)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean pointInLineSegment(double d, double d2, double d3, double d4, double d5, double d6) {
        return (d5 - d3) * (d2 - d4) == (d - d3) * (d6 - d4) && d >= Math.min(d3, d5) && d <= Math.max(d3, d5) && d2 >= Math.min(d4, d6) && d2 <= Math.max(d4, d6);
    }

    public static List<mxPoint> getSimpleRoute(mxPoint mxPoint2, mxPoint mxPoint3, Object[] objectArray) {
        return XcosRouteUtils.getSimpleRoute(mxPoint2, null, mxPoint3, null, objectArray);
    }

    public static List<mxPoint> getSimpleRoute(mxPoint mxPoint2, Orientation orientation, mxPoint mxPoint3, Orientation orientation2, Object[] objectArray) {
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(0);
        ArrayList<Double> arrayList2 = new ArrayList<Double>(0);
        ArrayList<Double> arrayList3 = new ArrayList<Double>(0);
        double d = 40.0;
        double d2 = mxPoint2.getX();
        double d3 = mxPoint2.getY();
        double d4 = mxPoint3.getX();
        double d5 = mxPoint3.getY();
        if (orientation == Orientation.EAST || orientation == Orientation.WEST) {
            if (!XcosRouteUtils.checkObstacle(d2, d3, d4, d3, objectArray) && !XcosRouteUtils.checkObstacle(d4, d3, d4, d5, objectArray)) {
                arrayList.add(new mxPoint(d4, d3));
                if (orientation2 != Orientation.NORTH && orientation2 != Orientation.SOUTH) {
                    arrayList.add(mxPoint3);
                }
                return arrayList;
            }
            if (!XcosRouteUtils.checkObstacle(d2, d3, d2, d5, objectArray) && !XcosRouteUtils.checkObstacle(d2, d5, d4, d5, objectArray)) {
                arrayList.add(mxPoint2);
                arrayList.add(new mxPoint(d2, d5));
                if (orientation2 != Orientation.EAST && orientation2 != Orientation.WEST) {
                    arrayList.add(mxPoint3);
                }
                return arrayList;
            }
        } else if (orientation == Orientation.NORTH || orientation == Orientation.SOUTH) {
            if (!XcosRouteUtils.checkObstacle(d2, d3, d2, d5, objectArray) && !XcosRouteUtils.checkObstacle(d2, d5, d4, d5, objectArray)) {
                arrayList.add(new mxPoint(d2, d5));
                if (orientation2 != Orientation.EAST && orientation2 != Orientation.WEST) {
                    arrayList.add(mxPoint3);
                }
                return arrayList;
            }
            if (!XcosRouteUtils.checkObstacle(d2, d3, d4, d3, objectArray) && !XcosRouteUtils.checkObstacle(d4, d3, d4, d5, objectArray)) {
                arrayList.add(mxPoint2);
                arrayList.add(new mxPoint(d4, d3));
                if (orientation2 != Orientation.NORTH && orientation2 != Orientation.SOUTH) {
                    arrayList.add(mxPoint3);
                }
                return arrayList;
            }
        }
        if (orientation == Orientation.EAST || orientation == Orientation.WEST) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10 = Math.max(d2 + d, d4 + d);
            for (d9 = d8 = Math.min(d2 - d, d4 - d); d9 <= d10; d9 += 1.0) {
                if (XcosRouteUtils.checkObstacle(d2, d3, d9, d3, objectArray) || XcosRouteUtils.checkObstacle(d9, d3, d9, d5, objectArray) || XcosRouteUtils.checkObstacle(d9, d5, d4, d5, objectArray)) continue;
                arrayList2.add(d9);
            }
            if (arrayList2.size() > 0) {
                d9 = XcosRouteUtils.choosePoint(arrayList2, d2, d4);
                arrayList.add(new mxPoint(d9, d3));
                arrayList.add(new mxPoint(d9, d5));
                if (orientation2 != Orientation.EAST && orientation2 != Orientation.WEST) {
                    arrayList.add(mxPoint3);
                }
                return arrayList;
            }
            d9 = Math.max(d3 + d, d5 + d);
            for (d7 = d6 = Math.min(d3 - d, d5 - d); d7 <= d9; d7 += 1.0) {
                if (XcosRouteUtils.checkObstacle(d2, d3, d2, d7, objectArray) || XcosRouteUtils.checkObstacle(d2, d7, d4, d7, objectArray) || XcosRouteUtils.checkObstacle(d4, d7, d4, d5, objectArray)) continue;
                arrayList3.add(d7);
            }
            if (arrayList3.size() > 0) {
                d7 = XcosRouteUtils.choosePoint(arrayList3, d3, d5);
                arrayList.add(mxPoint2);
                arrayList.add(new mxPoint(d2, d7));
                arrayList.add(new mxPoint(d4, d7));
                if (orientation2 != Orientation.NORTH && orientation2 != Orientation.SOUTH) {
                    arrayList.add(mxPoint3);
                }
                return arrayList;
            }
        } else if (orientation == Orientation.NORTH || orientation == Orientation.SOUTH) {
            double d11;
            double d12;
            double d13;
            double d14;
            double d15 = Math.max(d3 + d, d5 + d);
            for (d14 = d13 = Math.min(d3 - d, d5 - d); d14 <= d15; d14 += 1.0) {
                if (XcosRouteUtils.checkObstacle(d2, d3, d2, d14, objectArray) || XcosRouteUtils.checkObstacle(d2, d14, d4, d14, objectArray) || XcosRouteUtils.checkObstacle(d4, d14, d4, d5, objectArray)) continue;
                arrayList3.add(d14);
            }
            if (arrayList3.size() > 0) {
                d14 = XcosRouteUtils.choosePoint(arrayList3, d3, d5);
                arrayList.add(new mxPoint(d2, d14));
                arrayList.add(new mxPoint(d4, d14));
                if (orientation2 != Orientation.NORTH && orientation2 != Orientation.SOUTH) {
                    arrayList.add(mxPoint3);
                }
                return arrayList;
            }
            d14 = Math.max(d2 + d, d4 + d);
            for (d12 = d11 = Math.min(d2 - d, d4 - d); d12 <= d14; d12 += 1.0) {
                if (XcosRouteUtils.checkObstacle(d2, d3, d12, d3, objectArray) || XcosRouteUtils.checkObstacle(d12, d3, d12, d5, objectArray) || XcosRouteUtils.checkObstacle(d12, d5, d4, d5, objectArray)) continue;
                arrayList2.add(d12);
            }
            if (arrayList2.size() > 0) {
                d12 = XcosRouteUtils.choosePoint(arrayList2, d2, d4);
                arrayList.add(mxPoint2);
                arrayList.add(new mxPoint(d12, d3));
                arrayList.add(new mxPoint(d12, d5));
                if (orientation2 != Orientation.EAST && orientation2 != Orientation.WEST) {
                    arrayList.add(mxPoint3);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    private static double choosePoint(List<Double> list, double d, double d2) {
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        Collections.sort(list);
        double d3 = Math.max(d, d2);
        double d4 = Math.min(d, d2);
        double d5 = list.get(0);
        double d6 = list.get(0);
        double d7 = list.get(0);
        double d8 = list.get(0);
        double d9 = (d8 + d6) / 2.0;
        double d10 = (d7 + d5) / 2.0;
        boolean bl = true;
        for (int i = 1; i < list.size(); ++i) {
            if (Math.abs(list.get(i) - list.get(i - 1)) <= 1.1) {
                d8 = list.get(i);
                bl = false;
                continue;
            }
            if (bl) {
                d6 = list.get(i);
                continue;
            }
            d9 = (d8 + d6) / 2.0;
            d10 = (d7 + d5) / 2.0;
            if ((d9 < d4 || d9 > d3) && d10 < d3 && d10 > d4) {
                d6 = list.get(i);
                d8 = list.get(i);
                bl = true;
                continue;
            }
            if (!(Math.abs(d8 - d6) > Math.abs(d7 - d5)) && (!(d9 < d3) || !(d9 > d4) || !(d10 < d4) && !(d10 > d3))) continue;
            d5 = d6;
            d7 = d8;
            d6 = list.get(i);
            d8 = list.get(i);
            bl = true;
        }
        d9 = (d8 + d6) / 2.0;
        d10 = (d7 + d5) / 2.0;
        if ((!(d9 < d4) && !(d9 > d3) || !(d10 < d3) || !(d10 > d4)) && (Math.abs(d8 - d6) > Math.abs(d7 - d5) || d9 < d3 && d9 > d4 && (d10 < d4 || d10 > d3))) {
            d5 = d6;
            d7 = d8;
        }
        return (d5 + d7) / 2.0;
    }

    public static List<mxPoint> getComplexRoute(mxPoint mxPoint2, Orientation orientation, mxPoint mxPoint3, Orientation orientation2, Object[] objectArray, int n) {
        if (n <= 0) {
            return null;
        }
        double d = 40.0;
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(0);
        List<Object> list = new ArrayList(0);
        arrayList.add(mxPoint2);
        LinkedHashMap<Orientation, Object> linkedHashMap = new LinkedHashMap<Orientation, Object>(0);
        if (orientation == Orientation.EAST || orientation == null) {
            var11_10 = new mxPoint(mxPoint2.getX() + d, mxPoint2.getY());
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), var11_10.getX(), var11_10.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute((mxPoint)var11_10, Orientation.EAST, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.EAST, var11_10);
            }
            mxPoint entry = new mxPoint(mxPoint2.getX(), mxPoint2.getY() - d);
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), entry.getX(), entry.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute(entry, Orientation.NORTH, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.NORTH, entry);
            }
            var13_18 = new mxPoint(mxPoint2.getX(), mxPoint2.getY() + d);
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), var13_18.getX(), var13_18.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute(var13_18, Orientation.SOUTH, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.SOUTH, var13_18);
            }
            if (orientation == null) {
                mxPoint mxPoint4 = new mxPoint(mxPoint2.getX() - d, mxPoint2.getY());
                if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), mxPoint4.getX(), mxPoint4.getY(), objectArray)) {
                    list = XcosRouteUtils.getSimpleRoute(mxPoint4, Orientation.WEST, mxPoint3, orientation2, objectArray);
                    if (list != null && list.size() > 0) {
                        arrayList.addAll(list);
                        return arrayList;
                    }
                    linkedHashMap.put(Orientation.WEST, mxPoint4);
                }
            }
        } else if (orientation == Orientation.SOUTH) {
            var11_10 = new mxPoint(mxPoint2.getX(), mxPoint2.getY() + d);
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), var11_10.getX(), var11_10.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute((mxPoint)var11_10, Orientation.SOUTH, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.SOUTH, var11_10);
            }
            mxPoint mxPoint5 = new mxPoint(mxPoint2.getX() - d, mxPoint2.getY());
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), mxPoint5.getX(), mxPoint5.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute(mxPoint5, Orientation.WEST, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.WEST, mxPoint5);
            }
            var13_18 = new mxPoint(mxPoint2.getX() + d, mxPoint2.getY());
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), var13_18.getX(), var13_18.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute(var13_18, Orientation.EAST, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.EAST, var13_18);
            }
        } else if (orientation == Orientation.WEST) {
            var11_10 = new mxPoint(mxPoint2.getX() - d, mxPoint2.getY());
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), var11_10.getX(), var11_10.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute((mxPoint)var11_10, Orientation.WEST, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.WEST, var11_10);
            }
            mxPoint mxPoint6 = new mxPoint(mxPoint2.getX(), mxPoint2.getY() - d);
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), mxPoint6.getX(), mxPoint6.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute(mxPoint6, Orientation.NORTH, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.NORTH, mxPoint6);
            }
            var13_18 = new mxPoint(mxPoint2.getX(), mxPoint2.getY() + d);
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), var13_18.getX(), var13_18.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute(var13_18, Orientation.SOUTH, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.SOUTH, var13_18);
            }
        } else if (orientation == Orientation.NORTH) {
            var11_10 = new mxPoint(mxPoint2.getX(), mxPoint2.getY() - d);
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), var11_10.getX(), var11_10.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute((mxPoint)var11_10, Orientation.NORTH, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.NORTH, var11_10);
            }
            mxPoint mxPoint7 = new mxPoint(mxPoint2.getX() - d, mxPoint2.getY());
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), mxPoint7.getX(), mxPoint7.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute(mxPoint7, Orientation.WEST, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.WEST, mxPoint7);
            }
            var13_18 = new mxPoint(mxPoint2.getX() + d, mxPoint2.getY());
            if (!XcosRouteUtils.checkObstacle(mxPoint2.getX(), mxPoint2.getY(), var13_18.getX(), var13_18.getY(), objectArray)) {
                list = XcosRouteUtils.getSimpleRoute(var13_18, Orientation.EAST, mxPoint3, orientation2, objectArray);
                if (list != null && list.size() > 0) {
                    arrayList.addAll(list);
                    return arrayList;
                }
                linkedHashMap.put(Orientation.EAST, var13_18);
            }
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            list = XcosRouteUtils.getComplexRoute((mxPoint)entry.getValue(), (Orientation)((Object)entry.getKey()), mxPoint3, orientation2, objectArray, n - 1);
            if (list == null || list.size() <= 1) continue;
            arrayList.addAll(list);
            return arrayList;
        }
        arrayList.clear();
        return arrayList;
    }

    protected Orientation getPortOrientation(BasicPort basicPort) {
        if (basicPort.getParent() == null) {
            return Orientation.EAST;
        }
        mxGeometry mxGeometry2 = basicPort.getGeometry();
        double d = mxGeometry2.getCenterX();
        double d2 = mxGeometry2.getCenterY();
        mxICell mxICell2 = basicPort.getParent();
        mxGeometry mxGeometry3 = mxICell2.getGeometry();
        double d3 = mxGeometry3.getWidth();
        double d4 = mxGeometry3.getHeight();
        if (mxGeometry2.isRelative()) {
            d *= d3;
            d2 *= d4;
        }
        d -= d3 / 2.0;
        d2 -= d4 / 2.0;
        Orientation orientation = Orientation.EAST;
        if (d >= d3 * Math.abs(d2) / d4) {
            orientation = Orientation.EAST;
        } else if (d2 >= d4 * Math.abs(d) / d3) {
            orientation = Orientation.SOUTH;
        } else if (d <= -d3 * Math.abs(d2) / d4) {
            orientation = Orientation.WEST;
        } else if (d2 <= -d4 * Math.abs(d) / d3) {
            orientation = Orientation.NORTH;
        }
        return orientation;
    }

    private static mxPoint getLinkPortPosition(BasicLink basicLink, boolean bl) {
        mxPoint mxPoint2 = new mxPoint();
        mxICell mxICell2 = null;
        mxICell2 = bl ? basicLink.getSource() : basicLink.getTarget();
        if (mxICell2 == null) {
            return null;
        }
        if (mxICell2.getParent() instanceof SplitBlock) {
            SplitBlock splitBlock = (SplitBlock)mxICell2.getParent();
            mxPoint2.setX(splitBlock.getGeometry().getCenterX());
            mxPoint2.setY(splitBlock.getGeometry().getCenterY());
        } else if (mxICell2.getParent() instanceof BasicBlock) {
            mxGeometry mxGeometry2 = mxICell2.getGeometry();
            double d = mxGeometry2.getCenterX();
            double d2 = mxGeometry2.getCenterY();
            double d3 = mxGeometry2.getWidth();
            double d4 = mxGeometry2.getHeight();
            BasicBlock basicBlock = (BasicBlock)mxICell2.getParent();
            mxGeometry mxGeometry3 = basicBlock.getGeometry();
            double d5 = mxGeometry3.getX();
            double d6 = mxGeometry3.getY();
            double d7 = mxGeometry3.getWidth();
            double d8 = mxGeometry3.getHeight();
            if (mxGeometry2.isRelative()) {
                d *= d7;
                d2 *= d8;
            }
            mxPoint2.setX(d5 + d + d3 / 2.0);
            mxPoint2.setY(d6 + d2 + d4 / 2.0);
        }
        return mxPoint2;
    }

    protected static boolean isPointCoincident(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = 2.0;
        if (bl) {
            d5 = 10.0;
        }
        return Math.abs(d2 - d4) <= d5 && Math.abs(d - d3) <= d5 && Math.abs(d2 - d4) + Math.abs(d - d3) < d5 * 2.0;
    }

    protected static boolean isOrientationParallel(double d, double d2, double d3, double d4, Orientation orientation, Orientation orientation2) {
        if (orientation == orientation2) {
            return true;
        }
        double d5 = 2.0;
        if (Math.abs(d2 - d4) > d5) {
            if (orientation == Orientation.EAST && orientation2 == Orientation.WEST) {
                return true;
            }
            if (orientation == Orientation.WEST && orientation2 == Orientation.EAST) {
                return true;
            }
        }
        if (Math.abs(d - d3) > d5) {
            if (orientation == Orientation.SOUTH && orientation2 == Orientation.NORTH) {
                return true;
            }
            if (orientation == Orientation.NORTH && orientation2 == Orientation.SOUTH) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isLineParallel(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        double d9 = (d - d3) * (d6 - d8) - (d2 - d4) * (d5 - d7);
        return d9 == 0.0 && (bl || !XcosRouteUtils.pointInLineSegment(d, d2, d5, d6, d7, d8) && !XcosRouteUtils.pointInLineSegment(d3, d4, d5, d6, d7, d8) && !XcosRouteUtils.pointInLineSegment(d5, d6, d, d2, d3, d4) && !XcosRouteUtils.pointInLineSegment(d7, d8, d, d2, d3, d4));
    }
}

