/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.preferences;

import java.awt.Color;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.preferences.XcosConfiguration;
import org.w3c.dom.Document;

public class XcosOptions {
    protected static final String PREFERENCES_XPATH = "//xcos/body/xcos-preferences";
    protected static final String EDITION_XPATH = "//xcos/edition/body/xcos-edition";
    protected static final String SIMULATION_XPATH = "//xcos/simulation/body/xcos-simulation";
    private static Preferences preferences;
    private static Edition edition;
    private static Simulation simulation;

    public static void invalidate(XcosConfiguration.Options options) {
        if (options.preferences) {
            preferences = null;
        }
        if (options.edition) {
            edition = null;
        }
        if (options.simulation) {
            simulation = null;
        }
    }

    public static final Preferences getPreferences() {
        if (preferences == null) {
            preferences = ((Preferences[])XConfiguration.get(Preferences.class, (Document)XConfiguration.getXConfigurationDocument(), (String)PREFERENCES_XPATH))[0];
        }
        return preferences;
    }

    public static final Edition getEdition() {
        if (edition == null) {
            edition = ((Edition[])XConfiguration.get(Edition.class, (Document)XConfiguration.getXConfigurationDocument(), (String)EDITION_XPATH))[0];
        }
        return edition;
    }

    public static final Simulation getSimulation() {
        if (simulation == null) {
            simulation = ((Simulation[])XConfiguration.get(Simulation.class, (Document)XConfiguration.getXConfigurationDocument(), (String)SIMULATION_XPATH))[0];
        }
        return simulation;
    }

    public static class Preferences {
        private int numberOfRecentlyOpen = 5;
        private XcosFileType fileFormat = XcosFileType.SSP;

        private Preferences() {
        }

        public void setNumberOfRecentlyOpen(int n) {
            this.numberOfRecentlyOpen = n;
        }

        public void setFileFormat(int n) {
            this.fileFormat = XcosFileType.values()[n];
        }

        public int getNumberOfRecentlyOpen() {
            return this.numberOfRecentlyOpen;
        }

        public XcosFileType getFileFormat() {
            return this.fileFormat;
        }
    }

    public static class Edition {
        private String edgeStyle = "";
        private Color graphBackground;
        private boolean graphGridEnable = true;
        private int graphGrid = 10;

        private Edition() {
        }

        public void setEdgeStyle(int n) {
            switch (n) {
                case 0: {
                    this.edgeStyle = "";
                    break;
                }
                case 1: {
                    this.edgeStyle = ";noEdgeStyle=0;edgeStyle=elbowEdgeStyle;elbow=horizontal";
                    break;
                }
                case 2: {
                    this.edgeStyle = ";noEdgeStyle=0;edgeStyle=elbowEdgeStyle;elbow=vertical";
                }
            }
        }

        public void setGraphBackground(Color color) {
            this.graphBackground = color;
        }

        public void setGraphGridEnable(boolean bl) {
            this.graphGridEnable = bl;
        }

        public void setGraphGrid(int n) {
            this.graphGrid = n;
        }

        public String getEdgeStyle() {
            return this.edgeStyle;
        }

        public Color getGraphBackground() {
            return this.graphBackground;
        }

        public boolean isGraphGridEnable() {
            return this.graphGridEnable;
        }

        public int getGraphGrid() {
            return this.graphGrid;
        }
    }

    @XConfiguration.XConfAttribute
    public static class Simulation {
        private Simulation() {
        }

        @XConfiguration.XConfAttribute(tag="xcos-simulation", attributes={"final-integration-time", "integrator-absolute-tolerance", "integrator-relative-tolerance", "tolerance-on-time", "max-integration-interval", "real-time-scaling", "solver", "max-step-size", "trace"})
        private void set(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, int n2) {
            VectorOfDouble vectorOfDouble = new VectorOfDouble(8L);
            vectorOfDouble.set(0, Double.parseDouble(string));
            vectorOfDouble.set(1, Double.parseDouble(string2));
            vectorOfDouble.set(2, Double.parseDouble(string3));
            vectorOfDouble.set(3, Double.parseDouble(string4));
            vectorOfDouble.set(4, Double.parseDouble(string5));
            vectorOfDouble.set(7, Double.parseDouble(string7));
            vectorOfDouble.set(5, Double.parseDouble(string6));
            vectorOfDouble.set(6, n);
            ScicosParameters.DEFAULT_PARAMETERS = vectorOfDouble;
            ScicosParameters.DEFAULT_DEBUG_LEVEL = n2;
        }
    }
}

