/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.preferences;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.KeyStroke;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.graph.actions.CopyAction;
import org.scilab.modules.graph.actions.CutAction;
import org.scilab.modules.graph.actions.DeleteAction;
import org.scilab.modules.graph.actions.InvertSelectionAction;
import org.scilab.modules.graph.actions.PasteAction;
import org.scilab.modules.graph.actions.RedoAction;
import org.scilab.modules.graph.actions.SelectAllAction;
import org.scilab.modules.graph.actions.UndoAction;
import org.scilab.modules.graph.actions.ZoomInAction;
import org.scilab.modules.graph.actions.ZoomOutAction;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.graph.actions.base.GraphActionManager;
import org.scilab.modules.xcos.actions.AboutXcosAction;
import org.scilab.modules.xcos.actions.CloseAction;
import org.scilab.modules.xcos.actions.CompileAction;
import org.scilab.modules.xcos.actions.DebugLevelAction;
import org.scilab.modules.xcos.actions.DiagramBackgroundAction;
import org.scilab.modules.xcos.actions.ExportAction;
import org.scilab.modules.xcos.actions.FitDiagramToViewAction;
import org.scilab.modules.xcos.actions.NewDiagramAction;
import org.scilab.modules.xcos.actions.NormalViewAction;
import org.scilab.modules.xcos.actions.OpenAction;
import org.scilab.modules.xcos.actions.OpenInSciAction;
import org.scilab.modules.xcos.actions.PrintAction;
import org.scilab.modules.xcos.actions.QuitAction;
import org.scilab.modules.xcos.actions.SaveAction;
import org.scilab.modules.xcos.actions.SaveAsAction;
import org.scilab.modules.xcos.actions.SetContextAction;
import org.scilab.modules.xcos.actions.SetupAction;
import org.scilab.modules.xcos.actions.ShowHideShadowAction;
import org.scilab.modules.xcos.actions.StartAction;
import org.scilab.modules.xcos.actions.StopAction;
import org.scilab.modules.xcos.actions.ViewDiagramBrowserAction;
import org.scilab.modules.xcos.actions.ViewViewportAction;
import org.scilab.modules.xcos.actions.XcosDemonstrationsAction;
import org.scilab.modules.xcos.actions.XcosDocumentationAction;
import org.scilab.modules.xcos.block.actions.BlockDocumentationAction;
import org.scilab.modules.xcos.block.actions.BlockParametersAction;
import org.scilab.modules.xcos.block.actions.BorderColorAction;
import org.scilab.modules.xcos.block.actions.CodeGenerationAction;
import org.scilab.modules.xcos.block.actions.FilledColorAction;
import org.scilab.modules.xcos.block.actions.FlipAction;
import org.scilab.modules.xcos.block.actions.MirrorAction;
import org.scilab.modules.xcos.block.actions.RegionToSuperblockAction;
import org.scilab.modules.xcos.block.actions.RotateAction;
import org.scilab.modules.xcos.block.actions.ViewDetailsAction;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionBottom;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionCenter;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionLeft;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionMiddle;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionRight;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionTop;
import org.scilab.modules.xcos.link.actions.StyleHorizontalAction;
import org.scilab.modules.xcos.link.actions.StyleStraightAction;
import org.scilab.modules.xcos.link.actions.StyleVerticalAction;
import org.scilab.modules.xcos.palette.actions.ViewPaletteBrowserAction;
import org.scilab.modules.xcos.preferences.XcosConfiguration;
import org.w3c.dom.Document;

public final class XcosKeyMap {
    protected static final String KEYMAP_XPATH = "//general/shortcuts/body/actions/action-folder[@xconf-uid=\"xcos\"]/action";
    private static Map<String, KeyStroke> actionKeys;
    private static String[] actionMapKeys;
    private static Class<? extends DefaultAction>[] actionMapValues;

    private XcosKeyMap() {
    }

    private static Map<String, KeyStroke> getActionKeys() {
        if (actionKeys == null) {
            Document document = XConfiguration.getXConfigurationDocument();
            actionKeys = XConfiguration.get((Document)document, (String)"name", String.class, (String)"key", KeyStroke.class, (String)KEYMAP_XPATH);
        }
        return actionKeys;
    }

    public static void invalidate(XcosConfiguration.KeyMap keyMap) {
        if (keyMap.keymap) {
            actionKeys = null;
        }
    }

    public static void updateActionKeys() {
        Map<String, KeyStroke> map = XcosKeyMap.getActionKeys();
        for (Map.Entry<String, KeyStroke> entry : map.entrySet()) {
            int n = Arrays.binarySearch(actionMapKeys, entry.getKey());
            if (n < 0) continue;
            GraphActionManager.updateActionKeyStroke(actionMapValues[n], (KeyStroke)entry.getValue());
        }
    }

    static {
        TreeMap<String, Class> treeMap = new TreeMap<String, Class>();
        treeMap.put("xcos-new", NewDiagramAction.class);
        treeMap.put("xcos-open", OpenAction.class);
        treeMap.put("xcos-open-in-sci", OpenInSciAction.class);
        treeMap.put("xcos-save", SaveAction.class);
        treeMap.put("xcos-save-as", SaveAsAction.class);
        treeMap.put("xcos-export", ExportAction.class);
        treeMap.put("xcos-print", PrintAction.class);
        treeMap.put("xcos-close", CloseAction.class);
        treeMap.put("xcos-quit", QuitAction.class);
        treeMap.put("xcos-undo", UndoAction.class);
        treeMap.put("xcos-redo", RedoAction.class);
        treeMap.put("xcos-cut", CutAction.class);
        treeMap.put("xcos-copy", CopyAction.class);
        treeMap.put("xcos-paste", PasteAction.class);
        treeMap.put("xcos-delete", DeleteAction.class);
        treeMap.put("xcos-select-all", SelectAllAction.class);
        treeMap.put("xcos-invert-selection", InvertSelectionAction.class);
        treeMap.put("xcos-block-parameters", BlockParametersAction.class);
        treeMap.put("xcos-region-to-superblock", RegionToSuperblockAction.class);
        treeMap.put("xcos-zoom-in", ZoomInAction.class);
        treeMap.put("xcos-zoom-out", ZoomOutAction.class);
        treeMap.put("xcos-fit-diagram", FitDiagramToViewAction.class);
        treeMap.put("xcos-zoom-normal", NormalViewAction.class);
        treeMap.put("xcos-view-palette", ViewPaletteBrowserAction.class);
        treeMap.put("xcos-view-diagram", ViewDiagramBrowserAction.class);
        treeMap.put("xcos-view-viewport", ViewViewportAction.class);
        treeMap.put("xcos-view-details", ViewDetailsAction.class);
        treeMap.put("xcos-setup", SetupAction.class);
        treeMap.put("xcos-debug-level", DebugLevelAction.class);
        treeMap.put("xcos-set-context", SetContextAction.class);
        treeMap.put("xcos-compile", CompileAction.class);
        treeMap.put("xcos-start", StartAction.class);
        treeMap.put("xcos-stop", StopAction.class);
        treeMap.put("xcos-rotate", RotateAction.class);
        treeMap.put("xcos-flip", FlipAction.class);
        treeMap.put("xcos-mirror", MirrorAction.class);
        treeMap.put("xcos-shadow", ShowHideShadowAction.class);
        treeMap.put("xcos-align-left", AlignBlockActionLeft.class);
        treeMap.put("xcos-align-center", AlignBlockActionCenter.class);
        treeMap.put("xcos-align-right", AlignBlockActionRight.class);
        treeMap.put("xcos-align-top", AlignBlockActionTop.class);
        treeMap.put("xcos-align-middle", AlignBlockActionMiddle.class);
        treeMap.put("xcos-align-bottom", AlignBlockActionBottom.class);
        treeMap.put("xcos-border-color", BorderColorAction.class);
        treeMap.put("xcos-fill-color", FilledColorAction.class);
        treeMap.put("xcos-link-horizontal", StyleHorizontalAction.class);
        treeMap.put("xcos-link-straight", StyleStraightAction.class);
        treeMap.put("xcos-fill-vertical", StyleVerticalAction.class);
        treeMap.put("xcos-background", DiagramBackgroundAction.class);
        treeMap.put("xcos-grid", DiagramBackgroundAction.class);
        treeMap.put("xcos-code-generation", CodeGenerationAction.class);
        treeMap.put("xcos-help", XcosDocumentationAction.class);
        treeMap.put("xcos-help-block", BlockDocumentationAction.class);
        treeMap.put("xcos-demo", XcosDemonstrationsAction.class);
        treeMap.put("xcos-about", AboutXcosAction.class);
        int n = treeMap.size();
        actionMapKeys = treeMap.keySet().toArray(new String[n]);
        actionMapValues = treeMap.values().toArray(new Class[n]);
    }
}

