/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.graph.PaletteDiagram;
import org.scilab.modules.xcos.palette.PaletteBlockCtrl;
import org.scilab.modules.xcos.palette.PaletteCtrl;
import org.scilab.modules.xcos.palette.PaletteManager;
import org.scilab.modules.xcos.palette.actions.NavigationAction;
import org.scilab.modules.xcos.palette.actions.ZoomAction;
import org.scilab.modules.xcos.palette.listener.PaletteManagerMouseListener;
import org.scilab.modules.xcos.palette.listener.PaletteManagerTreeSelectionListener;
import org.scilab.modules.xcos.palette.listener.PaletteTreeTransferHandler;
import org.scilab.modules.xcos.palette.model.Category;
import org.scilab.modules.xcos.palette.model.Custom;
import org.scilab.modules.xcos.palette.model.PaletteBlock;
import org.scilab.modules.xcos.palette.model.PaletteNode;
import org.scilab.modules.xcos.palette.model.PreLoaded;
import org.scilab.modules.xcos.palette.view.PaletteBlockView;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.palette.view.PaletteSearchView;
import org.scilab.modules.xcos.palette.view.PaletteTreeModel;
import org.scilab.modules.xcos.palette.view.PaletteView;
import org.scilab.modules.xcos.utils.Stack;
import org.scilab.modules.xcos.utils.XcosConstants;

public class PaletteManagerPanel
extends JSplitPane {
    public static final String RECENTLY_USED_BLOCKS = "Recently Used Blocks";
    private static final int NUMBER_OF_DUMMY_BLOCKS = 10;
    private static final int LOAD_DUMMY_BLOCK_DELAY = 200;
    private static XcosConstants.PaletteBlockSize currentSize;
    private final PaletteManager controller;
    private CustomMouseWheelListener mouseWheelListener;
    private JTree tree;
    private PaletteDiagram diagramInstance;
    private List<TreePath> historyNext;
    private List<TreePath> historyPrev;
    private TreePath currentPath;

    public PaletteManagerPanel(PaletteManager paletteManager) {
        super(1);
        this.controller = paletteManager;
        this.mouseWheelListener = new CustomMouseWheelListener();
        this.historyNext = new ArrayList<TreePath>();
        this.historyPrev = new ArrayList<TreePath>();
        this.currentPath = null;
        currentSize = XcosConstants.PaletteBlockSize.NORMAL;
        this.fillUpContentPane();
    }

    private void fillUpContentPane() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBackground(Color.WHITE);
        this.setUpScrollBar(jScrollPane, currentSize);
        JPanel jPanel = new JPanel();
        Category category = this.controller.getRoot();
        this.tree = new JTree(new PaletteTreeModel(category));
        JScrollPane jScrollPane2 = new JScrollPane(this.tree);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new PaletteManagerMouseListener());
        this.tree.addTreeSelectionListener(new PaletteManagerTreeSelectionListener(this, jScrollPane));
        this.tree.setEditable(false);
        this.tree.setDragEnabled(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setDropMode(DropMode.INSERT);
        this.tree.setTransferHandler(new PaletteTreeTransferHandler());
        this.setLeftComponent(jScrollPane2);
        jScrollPane.setViewportView(jPanel);
        this.setRightComponent(jScrollPane);
    }

    public static XcosConstants.PaletteBlockSize getCurrentSize() {
        return currentSize;
    }

    public void addRecentltyUsedBlock(PaletteBlock paletteBlock) {
        Object object;
        PaletteNode paletteNode = (PaletteNode)this.tree.getLastSelectedPathComponent();
        if (paletteNode != null && paletteNode.getName().equals(RECENTLY_USED_BLOCKS)) {
            return;
        }
        Category category = PaletteManager.getInstance().getRoot();
        ArrayList<PaletteNode> arrayList = new ArrayList<PaletteNode>(category.getNode());
        PreLoaded preLoaded = null;
        while (preLoaded == null && !arrayList.isEmpty()) {
            object = arrayList.get(arrayList.size() - 1);
            arrayList.remove(arrayList.size() - 1);
            if (object instanceof PreLoaded && ((PaletteNode)object).getName().equals(RECENTLY_USED_BLOCKS)) {
                preLoaded = (PreLoaded)object;
                break;
            }
            if (!(object instanceof Category)) continue;
            arrayList.addAll(((Category)object).getNode());
        }
        if (preLoaded == null) {
            return;
        }
        object = preLoaded.getBlock();
        Iterator<PaletteBlock> iterator = object.iterator();
        while (iterator.hasNext()) {
            PaletteBlock paletteBlock2 = iterator.next();
            if (!paletteBlock2.getName().equals(paletteBlock.getName())) continue;
            return;
        }
        object.remove(object.size() - 1);
        object.add(0, paletteBlock);
    }

    private void zoom(XcosConstants.PaletteBlockSize paletteBlockSize) {
        if (paletteBlockSize == null || paletteBlockSize == currentSize) {
            return;
        }
        currentSize = paletteBlockSize;
        try {
            JScrollPane jScrollPane = (JScrollPane)this.getRightComponent();
            Dimension dimension = jScrollPane.getPreferredSize();
            this.setUpScrollBar(jScrollPane, paletteBlockSize);
            PaletteNode paletteNode = (PaletteNode)this.tree.getLastSelectedPathComponent();
            if (paletteNode instanceof PreLoaded || paletteNode == null) {
                Object object;
                PaletteView paletteView;
                Component component = jScrollPane.getViewport().getComponent(0);
                String string = component.getName();
                if (string.equals("PaletteView")) {
                    paletteView = (PaletteView)component;
                } else if (string.equals("PaletteSearchView")) {
                    object = (PaletteSearchView)component;
                    paletteView = (PaletteView)((Container)object).getComponent(1);
                } else {
                    return;
                }
                for (Object object2 : object = paletteView.getComponents()) {
                    PaletteBlockView paletteBlockView = (PaletteBlockView)object2;
                    paletteBlockView.initComponents();
                }
                paletteView.revalidate();
            } else if (paletteNode instanceof Custom) {
                jScrollPane = this.openDiagramAsPal(paletteNode);
                jScrollPane.setPreferredSize(dimension);
                this.setRightComponent(jScrollPane);
            } else {
                return;
            }
            if (paletteBlockSize.next() == null) {
                ZoomAction.setEnabledZoomIn(false);
                ZoomAction.setEnabledZoomOut(true);
            } else if (paletteBlockSize.previous() == null) {
                ZoomAction.setEnabledZoomIn(true);
                ZoomAction.setEnabledZoomOut(false);
            } else {
                ZoomAction.setEnabledZoomIn(true);
                ZoomAction.setEnabledZoomOut(true);
            }
            jScrollPane.revalidate();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public void zoomIn() {
        this.zoom(currentSize.next());
    }

    public void zoomOut() {
        this.zoom(currentSize.previous());
    }

    public JScrollPane openDiagramAsPal(PaletteNode paletteNode) {
        String string = ((Custom)paletteNode).getPath().getEvaluatedPath();
        JavaController javaController = new JavaController();
        this.diagramInstance = new PaletteDiagram(javaController.createObject(Kind.DIAGRAM));
        this.diagramInstance.openDiagramAsPal(string);
        return this.diagramInstance.getAsComponent();
    }

    private void setUpScrollBar(JScrollPane jScrollPane, XcosConstants.PaletteBlockSize paletteBlockSize) {
        MouseWheelListener[] mouseWheelListenerArray;
        jScrollPane.getVerticalScrollBar().setBlockIncrement(paletteBlockSize.getBlockDimension().height + 5);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(paletteBlockSize.getBlockDimension().height + 5);
        jScrollPane.getHorizontalScrollBar().setBlockIncrement(paletteBlockSize.getBlockDimension().width + 5);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(paletteBlockSize.getBlockDimension().width + 5);
        this.mouseWheelListener.setVerticalScrollBar(jScrollPane.getVerticalScrollBar());
        for (MouseWheelListener mouseWheelListener : mouseWheelListenerArray = jScrollPane.getMouseWheelListeners()) {
            jScrollPane.removeMouseWheelListener(mouseWheelListener);
        }
        jScrollPane.addMouseWheelListener(this.mouseWheelListener);
    }

    public void performStartUpLayout() {
        Object object = this.tree.getModel().getRoot();
        Object object2 = this.tree.getModel().getChild(object, 0);
        Object object3 = this.tree.getModel().getChild(object2, 0);
        this.tree.setSelectionPath(new TreePath(new Object[]{object, object2, object3}));
        this.tree.setRootVisible(false);
        this.tree.setScrollsOnExpand(true);
        this.setContinuousLayout(true);
        Timer timer = new Timer(200, new LoadBlock(this.controller, 10));
        timer.setRepeats(false);
        timer.start();
    }

    public void updateHistory() {
        TreePath treePath = this.currentPath;
        this.currentPath = this.tree.getSelectionPath();
        if (treePath != null && !this.currentPath.equals(treePath)) {
            int n;
            if (this.historyPrev.isEmpty()) {
                this.historyPrev.add(treePath);
            } else {
                n = this.historyPrev.size() - 1;
                if (this.currentPath.equals(this.historyPrev.get(n))) {
                    this.historyNext.add(treePath);
                    this.historyPrev.remove(n);
                    this.updateHistorySettings();
                    return;
                }
                this.historyPrev.add(treePath);
            }
            if (!this.historyNext.isEmpty()) {
                n = this.historyNext.size() - 1;
                if (this.currentPath.equals(this.historyNext.get(n))) {
                    this.historyNext.remove(n);
                } else {
                    this.historyNext.clear();
                }
            }
            this.updateHistorySettings();
        }
    }

    private void updateHistorySettings() {
        if (this.historyNext.size() + this.historyPrev.size() > 20) {
            this.historyPrev.remove(0);
        }
        NavigationAction.setEnabledNext(this.historyNext.size() > 0);
        NavigationAction.setEnabledPrev(this.historyPrev.size() > 0);
    }

    public void goNext() {
        try {
            this.tree.setSelectionPath(this.historyNext.get(this.historyNext.size() - 1));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            NavigationAction.setEnabledNext(false);
        }
    }

    public void goPrevious() {
        try {
            this.tree.setSelectionPath(this.historyPrev.get(this.historyPrev.size() - 1));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            NavigationAction.setEnabledPrev(false);
        }
    }

    private static final class CustomMouseWheelListener
    implements MouseWheelListener {
        private JScrollBar verticalScrollBar;

        public void setVerticalScrollBar(JScrollBar jScrollBar) {
            this.verticalScrollBar = jScrollBar;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (this.verticalScrollBar == null) {
                return;
            }
            int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
            if ((mouseWheelEvent.getModifiersEx() & n) == n) {
                if (mouseWheelEvent.getWheelRotation() < 0) {
                    PaletteManagerView.get().getPanel().zoomIn();
                } else if (mouseWheelEvent.getWheelRotation() > 0) {
                    PaletteManagerView.get().getPanel().zoomOut();
                }
            } else {
                int n2 = this.verticalScrollBar.getValue();
                n2 = mouseWheelEvent.getWheelRotation() < 0 ? (n2 -= this.verticalScrollBar.getUnitIncrement()) : (n2 += this.verticalScrollBar.getUnitIncrement());
                this.verticalScrollBar.setValue(n2);
            }
        }
    }

    private static final class LoadBlock
    implements ActionListener {
        private final PaletteManager controller;
        private int loadedBlocks;
        private Stack<TreeNode> nodeStack;
        private Stack<PaletteBlock> blocksStack;

        LoadBlock(PaletteManager paletteManager, int n) {
            this.controller = paletteManager;
            this.loadedBlocks = n;
            this.nodeStack = new Stack();
            this.nodeStack.push(paletteManager.getRoot());
            this.blocksStack = new Stack();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (this.loadedBlocks <= 0) {
                object = (Timer)actionEvent.getSource();
                ((Timer)object).stop();
            }
            if (this.blocksStack.size() != 0) {
                this.loadTransferable(this.blocksStack.pop());
                return;
            }
            while (this.nodeStack.size() != 0) {
                object = this.nodeStack.pop();
                if (object instanceof PreLoaded) {
                    this.blocksStack.addAll(((PreLoaded)object).getBlock());
                    if (this.blocksStack.size() == 0) continue;
                    this.loadTransferable(this.blocksStack.pop());
                    return;
                }
                for (int i = 0; i < object.getChildCount(); ++i) {
                    this.nodeStack.push(object.getChildAt(i));
                }
            }
        }

        private void loadTransferable(PaletteBlock paletteBlock) {
            new PaletteBlockCtrl(new PaletteCtrl(), paletteBlock).getPaletteCtrl().getTransferable();
            --this.loadedBlocks;
        }
    }
}

