/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.view;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.flexdock.plaf.common.border.ShadowBorder;
import org.scilab.modules.xcos.palette.PaletteBlockCtrl;
import org.scilab.modules.xcos.palette.actions.ZoomAction;
import org.scilab.modules.xcos.palette.view.PaletteManagerPanel;
import org.scilab.modules.xcos.utils.XcosConstants;

public final class PaletteBlockView
extends JLabel {
    private static final int DEFAULT_ICON_TEXT_GAP = 5;
    private static final Border SELECTED_BORDER = new ShadowBorder();
    private static final Border HOVER_BORDER = BorderFactory.createEtchedBorder(1);
    private static final Border NON_SELECTED_BORDER = BorderFactory.createEmptyBorder();
    private StatusUI statusUI;
    private PaletteBlockCtrl controller;

    public PaletteBlockView(PaletteBlockCtrl paletteBlockCtrl) {
        super(paletteBlockCtrl.getModel().getName(), 0);
        this.controller = paletteBlockCtrl;
        this.setStatusUI(StatusUI.NON_SELECTED);
        ZoomAction.registerKeyAction(this.getActionMap(), this.getInputMap());
        this.initComponents();
    }

    public void initComponents() {
        XcosConstants.PaletteBlockSize paletteBlockSize = PaletteManagerPanel.getCurrentSize();
        this.setPreferredSize(paletteBlockSize.getBlockDimension());
        this.setFont(new Font(this.getFont().getFamily(), 0, paletteBlockSize.getFontSize()));
        this.setIcon(this.controller.getModel().getLoadedIcon(paletteBlockSize.getMaxIconWidth(), paletteBlockSize.getMaxIconHeight()));
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setIconTextGap(5);
        String string = this.controller.getModel().getName();
        this.setToolTipText(string);
        this.setText(string);
    }

    public PaletteBlockCtrl getController() {
        return this.controller;
    }

    public StatusUI getStatusUI() {
        return this.statusUI;
    }

    public void setStatusUI(StatusUI statusUI) {
        this.statusUI = statusUI;
        if (statusUI == StatusUI.SELECTED) {
            this.setBorder(SELECTED_BORDER);
        } else if (statusUI == StatusUI.HOVER) {
            this.setBorder(HOVER_BORDER);
        } else {
            this.setBorder(NON_SELECTED_BORDER);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    public static enum StatusUI {
        SELECTED,
        NON_SELECTED,
        HOVER;

    }
}

