/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.listener;

import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.scilab.modules.xcos.palette.PaletteBlockCtrl;
import org.scilab.modules.xcos.palette.PaletteCtrl;
import org.scilab.modules.xcos.palette.model.Category;
import org.scilab.modules.xcos.palette.model.Custom;
import org.scilab.modules.xcos.palette.model.PaletteBlock;
import org.scilab.modules.xcos.palette.model.PaletteNode;
import org.scilab.modules.xcos.palette.model.PreLoaded;
import org.scilab.modules.xcos.palette.view.PaletteConfiguratorListView;
import org.scilab.modules.xcos.palette.view.PaletteManagerPanel;

public class PaletteManagerTreeSelectionListener
implements TreeSelectionListener {
    private final JScrollPane panel;
    private PaletteManagerPanel paletteManagerPanel;

    public PaletteManagerTreeSelectionListener(PaletteManagerPanel paletteManagerPanel, JScrollPane jScrollPane) {
        this.paletteManagerPanel = paletteManagerPanel;
        this.panel = jScrollPane;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        JTree jTree = (JTree)treeSelectionEvent.getSource();
        JSplitPane jSplitPane = (JSplitPane)jTree.getParent().getParent().getParent();
        PaletteNode paletteNode = (PaletteNode)jTree.getLastSelectedPathComponent();
        if (paletteNode == null) {
            return;
        }
        JScrollPane jScrollPane = null;
        Dimension dimension = jSplitPane.getRightComponent().getPreferredSize();
        if (paletteNode instanceof Category) {
            PaletteConfiguratorListView.PaletteListModel paletteListModel = new PaletteConfiguratorListView.PaletteListModel((Category)paletteNode);
            PaletteConfiguratorListView paletteConfiguratorListView = new PaletteConfiguratorListView(paletteListModel);
            jScrollPane = new JScrollPane(paletteConfiguratorListView);
        } else if (paletteNode instanceof PreLoaded) {
            PreLoaded preLoaded = (PreLoaded)paletteNode;
            PaletteCtrl paletteCtrl = new PaletteCtrl();
            for (PaletteBlock paletteBlock : preLoaded.getBlock()) {
                new PaletteBlockCtrl(paletteCtrl, paletteBlock);
            }
            this.panel.setViewportView(paletteCtrl.getView());
            jScrollPane = this.panel;
        } else if (paletteNode instanceof Custom) {
            jScrollPane = this.paletteManagerPanel.openDiagramAsPal(paletteNode);
        } else {
            Logger.getLogger(PaletteManagerTreeSelectionListener.class.getName()).severe("tree selection is not handled");
            return;
        }
        this.paletteManagerPanel.updateHistory();
        jScrollPane.setPreferredSize(dimension);
        jSplitPane.setRightComponent(jScrollPane);
        jScrollPane.validate();
    }
}

