/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.listener;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.InvalidDnDOperationException;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.xcos.palette.PaletteBlockCtrl;
import org.scilab.modules.xcos.palette.PaletteCtrl;
import org.scilab.modules.xcos.palette.view.PaletteBlockView;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class PaletteDragGestureListener
implements DragGestureListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        PaletteBlockCtrl paletteBlockCtrl = ((PaletteBlockView)dragGestureEvent.getComponent()).getController();
        PaletteCtrl paletteCtrl = paletteBlockCtrl.getPaletteCtrl();
        if (paletteCtrl == null) {
            return;
        }
        if (!paletteBlockCtrl.isSelected()) {
            PaletteCtrl.clearSelections();
        }
        paletteBlockCtrl.setSelected(true);
        if (PaletteManagerView.get() == null) {
            PaletteManagerView.restore();
        }
        PaletteManagerView paletteManagerView = PaletteManagerView.get();
        paletteManagerView.setInfo(XcosMessages.LOADING_BLOCKS);
        try {
            Transferable transferable = paletteCtrl.getTransferable();
            if (transferable != null) {
                dragGestureEvent.startDrag(null, null, new Point(), transferable, null);
            }
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            ScilabModalDialog.show((SimpleTab)paletteManagerView, (String)XcosMessages.UNABLE_TO_LOAD_SELECTED_BLOCKS, (String)XcosMessages.XCOS_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
        }
        finally {
            paletteManagerView.setInfo("");
        }
    }
}

