/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.listener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.palette.PaletteBlockCtrl;
import org.scilab.modules.xcos.palette.PaletteCtrl;
import org.scilab.modules.xcos.palette.view.PaletteBlockView;
import org.scilab.modules.xcos.palette.view.PaletteManagerPanel;
import org.scilab.modules.xcos.palette.view.PaletteView;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.XcosConstants;

public final class PaletteBlockKeyListener
implements KeyListener {
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            List<XcosDiagram> list = Xcos.getInstance().openedDiagrams();
            PaletteBlockCtrl paletteBlockCtrl = ((PaletteBlockView)keyEvent.getSource()).getController();
            int n = list.size();
            assert (n != 0);
            XcosDiagram xcosDiagram = list.get(n - 1);
            Object[] objectArray = paletteBlockCtrl.getPaletteCtrl().getSelectedBlocks();
            if (objectArray != null) {
                BlockPositioning.updatePortsPosition(xcosDiagram, objectArray);
                xcosDiagram.addCells(objectArray);
            }
        } else if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 9) {
            PaletteCtrl.clearSelections();
            PaletteBlockView paletteBlockView = (PaletteBlockView)keyEvent.getSource();
            paletteBlockView.transferFocusUpCycle();
        } else if (keyEvent.getKeyCode() == 32) {
            PaletteBlockView paletteBlockView = (PaletteBlockView)keyEvent.getSource();
            boolean bl = paletteBlockView.getController().isSelected();
            if ((keyEvent.getModifiers() & 2) == 0) {
                PaletteCtrl.clearSelections();
            }
            paletteBlockView.getController().setSelected(!bl);
            paletteBlockView.requestFocus();
        } else if (keyEvent.getKeyCode() == 40) {
            this.getNextBlock(keyEvent, 0, 1);
        } else if (keyEvent.getKeyCode() == 38) {
            this.getNextBlock(keyEvent, 0, -1);
        } else if (keyEvent.getKeyCode() == 39) {
            this.getNextBlock(keyEvent, 1, 0);
        } else if (keyEvent.getKeyCode() == 37) {
            this.getNextBlock(keyEvent, -1, 0);
        }
    }

    private void getNextBlock(KeyEvent keyEvent, int n, int n2) {
        PaletteBlockView paletteBlockView = (PaletteBlockView)keyEvent.getSource();
        XcosConstants.PaletteBlockSize paletteBlockSize = PaletteManagerPanel.getCurrentSize();
        n *= paletteBlockSize.getBlockDimension().width + 5;
        n2 *= paletteBlockSize.getBlockDimension().height + 5;
        if ((n += paletteBlockView.getLocation().x) < 0 || (n2 += paletteBlockView.getLocation().y) < 0) {
            return;
        }
        try {
            PaletteView paletteView = paletteBlockView.getController().getPaletteCtrl().getView();
            PaletteBlockView paletteBlockView2 = (PaletteBlockView)paletteView.getComponentAt(n, n2);
            boolean bl = (keyEvent.getModifiers() & 2) != 0;
            boolean bl2 = paletteBlockView2.getController().isSelected();
            if (!bl) {
                PaletteCtrl.clearSelections();
                paletteBlockView2.getController().setSelected(!bl2);
            } else if (keyEvent.getKeyCode() == 32) {
                paletteBlockView2.getController().setSelected(!bl2);
            } else if (!bl2) {
                paletteBlockView2.setStatusUI(PaletteBlockView.StatusUI.HOVER);
            }
            paletteView.scrollRectToVisible(paletteBlockView2.getBounds());
            paletteBlockView2.requestFocus();
            if (paletteBlockView.getStatusUI().equals((Object)PaletteBlockView.StatusUI.HOVER)) {
                paletteBlockView.setStatusUI(PaletteBlockView.StatusUI.NON_SELECTED);
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

