/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxStylesheet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.utils.XcosMessages;

public class StyleElement
extends AbstractElement<mxStylesheet> {
    private static final List<String> DATA_FIELD_NAMES = Arrays.asList("palette", "name", "blockNames", "icons", "style");
    private ScilabTList data;

    public StyleElement() {
        super(null);
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabTList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0));
    }

    @Override
    public mxStylesheet decode(ScilabType scilabType, mxStylesheet mxStylesheet2) throws ScicosFormatException {
        this.data = (ScilabTList)scilabType;
        mxStylesheet mxStylesheet3 = mxStylesheet2;
        this.validate();
        if (mxStylesheet2 == null) {
            throw new NullPointerException("No place to decode data");
        }
        int n = 2;
        String[][] stringArray = ((ScilabString)this.data.get(n)).getData();
        ++n;
        String[][] stringArray2 = ((ScilabString)this.data.get(++n)).getData();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (mxStylesheet3.getStyles().containsKey(stringArray[i][j])) continue;
                Map map = mxStylesheet3.getCellStyle(stringArray2[i][j], mxStylesheet3.getCellStyle("Icon", mxStylesheet3.getDefaultVertexStyle()));
                if (map.containsKey(mxConstants.STYLE_IMAGE)) {
                    String string = (String)map.get(mxConstants.STYLE_IMAGE);
                    string = this.validateURL(string);
                    map.put(mxConstants.STYLE_IMAGE, string);
                }
                mxStylesheet3.putCellStyle(stringArray[i][j], map);
            }
        }
        return mxStylesheet3;
    }

    private String validateURL(String string) {
        File file;
        URL uRL;
        try {
            uRL = new URL(string);
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        if (file.exists()) {
            return uRL.toString();
        }
        throw new RuntimeException(String.format(XcosMessages.IMAGE_URL_DOESNT_EXIST, string));
    }

    private void validate() throws ScicosFormatException {
        if (!this.canDecode((ScilabType)this.data)) {
            throw new ScicosFormatException.WrongElementException();
        }
        int n = 0;
        if (this.data.size() != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.data.get(n)).getData()[0];
        if (stringArray.length != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        ++n;
        if (!(this.data.get(++n) instanceof ScilabString) || ((ScilabType)this.data.get(n)).getWidth() != 1) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        ++n;
        if (!(this.data.get(++n) instanceof ScilabString) || ((ScilabType)this.data.get(n)).getWidth() != 1) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
    }
}

