/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.util.mxGraphTransferable;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.palette.PaletteBlockCtrl;
import org.scilab.modules.xcos.palette.listener.PaletteMouseListener;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.palette.view.PaletteView;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.XcosConstants;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class PaletteCtrl {
    private static XcosDiagram internalGraph;
    private static final PaletteMouseListener MOUSE_LISTENER;
    private static final Logger LOG;
    private static final int BLOCKS_BY_ROW = 5;
    private static final Dimension BLOCK_POSITION;
    private static final List<PaletteBlockCtrl> BLOCKS;
    private final PaletteView view = new PaletteView();

    public PaletteCtrl() {
        this.view.addMouseListener(MOUSE_LISTENER);
        this.view.addMouseMotionListener(MOUSE_LISTENER);
    }

    public PaletteView getView() {
        return this.view;
    }

    public void clear() {
        BLOCKS.clear();
        this.view.removeAll();
    }

    public static void clearSelections() {
        for (PaletteBlockCtrl paletteBlockCtrl : BLOCKS) {
            paletteBlockCtrl.setSelected(false);
        }
    }

    public void addBlock(PaletteBlockCtrl paletteBlockCtrl) {
        BLOCKS.add(paletteBlockCtrl);
        this.view.add(paletteBlockCtrl.getView());
    }

    public Object[] getSelectedBlocks() {
        int n = 0;
        int n2 = 0;
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>();
        for (PaletteBlockCtrl objectArray2 : BLOCKS) {
            if (!objectArray2.isSelected()) continue;
            BasicBlock i = null;
            try {
                i = XcosCellFactory.createBlock(objectArray2.getModel().getName());
            }
            catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
                // empty catch block
            }
            if (i == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest(String.format(XcosMessages.UNABLE_TO_LOAD_BLOCK, objectArray2.getModel().getData().getEvaluatedPath()));
                }
                this.getView().setEnabled(false);
                continue;
            }
            PaletteManagerView interpreterException = PaletteManagerView.get();
            if (interpreterException != null) {
                interpreterException.getPanel().addRecentltyUsedBlock(objectArray2.getModel());
            }
            double d = internalGraph.getGridSize();
            i.getGeometry().setX(d + (double)(PaletteCtrl.BLOCK_POSITION.width * n2));
            i.getGeometry().setY(d + (double)(PaletteCtrl.BLOCK_POSITION.height * n));
            if (++n2 >= 5) {
                n2 = 0;
                ++n;
            }
            arrayList.add(i);
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            return null;
        }
        Object[] objectArray = new Object[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray[i] = arrayList.get(i);
        }
        return objectArray;
    }

    public Transferable getTransferable() {
        mxGraphTransferable mxGraphTransferable2 = null;
        Object[] objectArray = this.getSelectedBlocks();
        if (objectArray == null) {
            return null;
        }
        BlockPositioning.updatePortsPosition(internalGraph, objectArray);
        internalGraph.addCells(objectArray);
        mxGraphTransferHandler mxGraphTransferHandler2 = (mxGraphTransferHandler)internalGraph.getAsComponent().getTransferHandler();
        mxGraphTransferable2 = new mxGraphTransferable(objectArray, internalGraph.getPaintBounds(objectArray), mxGraphTransferHandler2.createTransferableImage(internalGraph.getAsComponent(), objectArray));
        return mxGraphTransferable2;
    }

    static {
        JavaController javaController = new JavaController();
        internalGraph = new XcosDiagram(javaController, javaController.createObject(Kind.DIAGRAM), Kind.DIAGRAM, "");
        internalGraph.installListeners();
        MOUSE_LISTENER = new PaletteMouseListener();
        LOG = Logger.getLogger(PaletteBlockCtrl.class.getName());
        BLOCK_POSITION = XcosConstants.PaletteBlockSize.NORMAL.getBlockDimension();
        BLOCKS = new ArrayList<PaletteBlockCtrl>();
    }
}

