/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.modelica.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.scilab.modules.xcos.modelica.ModelStatistics;
import org.scilab.modules.xcos.modelica.ModelicaController;
import org.scilab.modules.xcos.modelica.ModelicaMessages;
import org.scilab.modules.xcos.modelica.TerminalAccessor;
import org.scilab.modules.xcos.modelica.TerminalTableModel;
import org.scilab.modules.xcos.modelica.listener.FixDerivativesAction;
import org.scilab.modules.xcos.modelica.listener.FixStatesAction;
import org.scilab.modules.xcos.modelica.listener.SolveAction;
import org.scilab.modules.xcos.modelica.listener.StatisticsUpdater;
import org.scilab.modules.xcos.modelica.model.Model;
import org.scilab.modules.xcos.modelica.model.Struct;
import org.scilab.modules.xcos.modelica.model.Terminal;
import org.scilab.modules.xcos.modelica.view.LabelWithValue;

public final class MainPanel
extends JPanel {
    private static final int[] EXTENDED_STATUS_LAYOUT_DATA = new int[]{2, 6};
    private final ModelicaController controller;
    private JPanel controlBar;
    private JScrollPane treeScrollPane;
    private JScrollPane tableScrollPane;
    private JSplitPane splitPanel;
    private JTable table;
    private TerminalTableModel tableModel;
    private JTree tree;
    private LabelWithValue equation;
    private LabelWithValue inputs;
    private LabelWithValue outputs;
    private LabelWithValue unknowns;
    private LabelWithValue reduced;
    private LabelWithValue diffSt;
    private LabelWithValue fixedParams;
    private LabelWithValue relaxedParams;
    private LabelWithValue fixedVars;
    private LabelWithValue relaxedVars;
    private LabelWithValue discretes;
    private JCheckBox embeddedParametersButton;
    private JCheckBox generateJacobianButton;
    private JButton solveButton;
    private JLabel solver;
    private JComboBox solverComboBox;
    private JProgressBar solverWaitBar;
    private JPanel variableStatusBar;
    private JPanel extendedStatus;
    private JPanel globalStatus;
    private JButton fixStates;
    private JButton fixDerivatives;

    public MainPanel(ModelicaController modelicaController) {
        this.controller = modelicaController;
        this.initComponents();
        this.installListeners();
        this.fireChange();
    }

    private void initComponents() {
        this.allocateFields();
        this.setLayoutsAndBorders();
        this.initGlobalStatus();
        this.variableStatusBar.add(this.globalStatus);
        this.initExtendedStatus();
        this.variableStatusBar.add(this.extendedStatus);
        this.add((Component)this.variableStatusBar, "First");
        this.tree.setModel(this.createTreeModel());
        this.treeScrollPane.setViewportView(this.tree);
        this.splitPanel.setLeftComponent(this.treeScrollPane);
        this.table.setModel(this.tableModel);
        this.table.setAutoCreateRowSorter(true);
        this.tableScrollPane.setViewportView(this.table);
        this.splitPanel.setRightComponent(this.tableScrollPane);
        this.add((Component)this.splitPanel, "Center");
        this.initControlBar();
        this.add((Component)this.controlBar, "Last");
    }

    private TreeModel createTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.controller.getRoot()){

            @Override
            public String toString() {
                return ((Model)this.getUserObject()).getName();
            }
        };
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        for (Struct struct : this.controller.getRoot().getElements().getStruct()) {
            defaultMutableTreeNode.add(this.createNodes(struct));
        }
        return defaultTreeModel;
    }

    private MutableTreeNode createNodes(Struct struct) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(struct){

            @Override
            public String toString() {
                return ((Struct)this.getUserObject()).getName();
            }
        };
        for (Object object : struct.getSubnodes().getStructOrTerminal()) {
            if (!(object instanceof Struct)) continue;
            defaultMutableTreeNode.add(this.createNodes((Struct)object));
        }
        return defaultMutableTreeNode;
    }

    private List<Terminal> getTerminals(TreePath[] treePathArray) {
        ArrayList<Terminal> arrayList = new ArrayList<Terminal>();
        for (TreePath treePath : treePathArray) {
            Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            arrayList.addAll(this.getTerminals(object));
        }
        return arrayList;
    }

    private List<Terminal> getTerminals(Object object) {
        List<Terminal> list;
        if (object instanceof Terminal) {
            Terminal terminal = (Terminal)object;
            list = Collections.singletonList(terminal);
        } else if (object instanceof Struct) {
            Struct struct = (Struct)object;
            List<Object> list2 = struct.getSubnodes().getStructOrTerminal();
            list = this.getTerminals(list2);
        } else if (object instanceof Model) {
            Model model = (Model)object;
            list = this.getTerminals(model.getElements().getStruct());
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            list = new ArrayList<Terminal>();
            for (Object e : collection) {
                list.addAll(this.getTerminals(e));
            }
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    private void initControlBar() {
        JPanel jPanel = new JPanel();
        this.solver.setText(ModelicaMessages.SOLVER + " :");
        jPanel.add(this.solver);
        this.solverComboBox.setModel(new DefaultComboBoxModel<ModelicaController.ComputationMethod>(ModelicaController.ComputationMethod.values()));
        this.solverComboBox.setToolTipText(ModelicaMessages.INITIAL_COMPUTING_METHOD);
        jPanel.add(this.solverComboBox);
        this.embeddedParametersButton.setText(ModelicaMessages.PARAMETER_EMBEDDING);
        this.embeddedParametersButton.setToolTipText(ModelicaMessages.PARAMETER_EMBEDDING_EXPLAINED);
        jPanel.add(this.embeddedParametersButton);
        this.generateJacobianButton.setText(ModelicaMessages.GENERATE_JACOBIAN);
        jPanel.add(this.generateJacobianButton);
        this.solveButton.setAction(new SolveAction(this.controller, this.solverWaitBar));
        jPanel.add(this.solveButton);
        jPanel.add(this.solverWaitBar);
        this.controlBar.add(jPanel);
    }

    private void initExtendedStatus() {
        this.diffSt.setTitle(ModelicaMessages.DIFF_ST);
        this.extendedStatus.add(this.diffSt);
        this.fixedParams.setTitle(ModelicaMessages.FIXED_PARAMS);
        this.extendedStatus.add(this.fixedParams);
        this.relaxedParams.setTitle(ModelicaMessages.RELAXED_PARAMS);
        this.extendedStatus.add(this.relaxedParams);
        this.fixedVars.setTitle(ModelicaMessages.FIXED_VARIABLES);
        this.extendedStatus.add(this.fixedVars);
        this.relaxedVars.setTitle(ModelicaMessages.RELAXED_VARIABLES);
        this.extendedStatus.add(this.relaxedVars);
        this.discretes.setTitle(ModelicaMessages.DISCRETES);
        this.extendedStatus.add(this.discretes);
        this.inputs.setTitle(ModelicaMessages.INPUTS);
        this.extendedStatus.add(this.inputs);
        this.outputs.setTitle(ModelicaMessages.OUTPUTS);
        this.extendedStatus.add(this.outputs);
    }

    private void initGlobalStatus() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.equation.setTitle(ModelicaMessages.EQUATIONS);
        jPanel.add(this.equation);
        this.unknowns.setTitle(ModelicaMessages.UNKNOWNS);
        jPanel.add(this.unknowns);
        this.reduced.setTitle(ModelicaMessages.REDUCED);
        jPanel.add(this.reduced);
        this.globalStatus.add(jPanel);
        this.fixStates.setAction(new FixStatesAction(this.controller));
        jPanel2.add(this.fixStates);
        this.fixDerivatives.setAction(new FixDerivativesAction(this.controller));
        jPanel2.add(this.fixDerivatives);
        this.globalStatus.add(jPanel2);
    }

    private void setLayoutsAndBorders() {
        this.setLayout(new BorderLayout());
        this.globalStatus.setBorder(BorderFactory.createTitledBorder(ModelicaMessages.GLOBAL));
        this.globalStatus.setLayout(new BoxLayout(this.globalStatus, 3));
        this.extendedStatus.setBorder(BorderFactory.createTitledBorder(ModelicaMessages.EXTENDED));
        this.extendedStatus.setLayout(new GridLayout(EXTENDED_STATUS_LAYOUT_DATA[0], EXTENDED_STATUS_LAYOUT_DATA[1]));
        this.splitPanel.setContinuousLayout(true);
        this.controlBar.setLayout(new BoxLayout(this.controlBar, 3));
    }

    private void allocateFields() {
        this.variableStatusBar = new JPanel();
        this.globalStatus = new JPanel();
        this.extendedStatus = new JPanel();
        this.equation = new LabelWithValue();
        this.unknowns = new LabelWithValue();
        this.reduced = new LabelWithValue();
        this.diffSt = new LabelWithValue();
        this.fixedParams = new LabelWithValue();
        this.relaxedParams = new LabelWithValue();
        this.fixedVars = new LabelWithValue();
        this.relaxedVars = new LabelWithValue();
        this.discretes = new LabelWithValue();
        this.inputs = new LabelWithValue();
        this.outputs = new LabelWithValue();
        this.splitPanel = new JSplitPane();
        this.treeScrollPane = new JScrollPane();
        this.tree = new JTree();
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        this.controlBar = new JPanel();
        this.solver = new JLabel();
        this.solverComboBox = new JComboBox();
        this.solverWaitBar = new JProgressBar();
        this.embeddedParametersButton = new JCheckBox();
        this.generateJacobianButton = new JCheckBox();
        this.solveButton = new JButton();
        this.fixStates = new JButton();
        this.fixDerivatives = new JButton();
        this.tableModel = new TerminalTableModel();
    }

    private void installListeners() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MainPanel.this.tableModel.setTerminals(MainPanel.this.getTerminals(MainPanel.this.tree.getSelectionPaths()));
            }
        });
        ModelStatistics modelStatistics = this.controller.getStatistics();
        modelStatistics.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ModelStatistics modelStatistics = (ModelStatistics)changeEvent.getSource();
                MainPanel.this.equation.setText(Long.toString(modelStatistics.getEquations()));
                MainPanel.this.unknowns.setText(Long.toString(modelStatistics.getUnknowns()));
                MainPanel.this.diffSt.setText(Long.toString(modelStatistics.getDerivativeStates()));
                MainPanel.this.fixedParams.setText(Long.toString(modelStatistics.getFixedParameters()));
                MainPanel.this.relaxedParams.setText(Long.toString(modelStatistics.getRelaxedParameters()));
                MainPanel.this.discretes.setText(Long.toString(modelStatistics.getDiscreteStates()));
                MainPanel.this.relaxedVars.setText(Long.toString(modelStatistics.getRelaxedVariables()));
                MainPanel.this.fixedVars.setText(Long.toString(modelStatistics.getFixedVariables()));
                MainPanel.this.inputs.setText(Long.toString(modelStatistics.getInputs()));
                MainPanel.this.outputs.setText(Long.toString(modelStatistics.getInputs()));
            }
        });
        this.installTableModelListeners(modelStatistics);
        this.solverComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainPanel.this.controller.setComputeMethod((ModelicaController.ComputationMethod)((Object)itemEvent.getItem()));
            }
        });
        this.solverComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainPanel.this.generateJacobianButton.setEnabled(itemEvent.getItem() == ModelicaController.ComputationMethod.Ida);
            }
        });
        this.embeddedParametersButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainPanel.this.controller.setParameterEmbedded(itemEvent.getStateChange() == 1);
            }
        });
        this.generateJacobianButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainPanel.this.controller.setJacobianEnable(itemEvent.getStateChange() == 1);
            }
        });
    }

    private void installTableModelListeners(ModelStatistics modelStatistics) {
        this.controller.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MainPanel.this.tableModel.fireTableDataChanged();
            }
        });
        this.tableModel.addTableModelListener(new StatisticsUpdater(modelStatistics));
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent instanceof TerminalTableModel.TerminalTableModelEvent && ((TerminalTableModel.TerminalTableModelEvent)tableModelEvent).isAfterCommit()) {
                    TerminalTableModel terminalTableModel;
                    Terminal terminal;
                    int n = tableModelEvent.getFirstRow();
                    int n2 = tableModelEvent.getColumn();
                    if (TerminalAccessor.values()[n2] == TerminalAccessor.WEIGHT && ((terminal = (terminalTableModel = (TerminalTableModel)tableModelEvent.getSource()).getTerminals().get(n)).getKind().equals("fixed_parameter") || terminal.getKind().equals("variable"))) {
                        double d = (Double)TerminalAccessor.getData(TerminalAccessor.WEIGHT, terminal);
                        boolean bl = d >= 1.0;
                        MainPanel.this.tableModel.setValueAt(bl, n, Arrays.asList(TerminalAccessor.values()).indexOf((Object)TerminalAccessor.FIXED));
                    }
                }
            }
        });
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent instanceof TerminalTableModel.TerminalTableModelEvent && !MainPanel.this.embeddedParametersButton.isSelected()) {
                    TerminalTableModel terminalTableModel;
                    Terminal terminal;
                    Double d;
                    int n = tableModelEvent.getFirstRow();
                    int n2 = tableModelEvent.getColumn();
                    if (TerminalAccessor.values()[n2] == TerminalAccessor.WEIGHT && (d = (Double)TerminalAccessor.getData(TerminalAccessor.WEIGHT, terminal = (terminalTableModel = (TerminalTableModel)tableModelEvent.getSource()).getTerminals().get(n))) >= 1.0) {
                        MainPanel.this.controller.setCompileNeeded(true);
                    }
                }
            }
        });
    }

    private void fireChange() {
        this.controller.getStatistics().fireChange();
        this.controller.fireChange();
    }
}

