/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.modelica.listener;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.scilab.modules.xcos.modelica.ModelStatistics;
import org.scilab.modules.xcos.modelica.TerminalAccessor;
import org.scilab.modules.xcos.modelica.TerminalTableModel;
import org.scilab.modules.xcos.modelica.model.Terminal;

public final class StatisticsUpdater
implements TableModelListener {
    private final ModelStatistics statistics;

    public StatisticsUpdater(ModelStatistics modelStatistics) {
        this.statistics = modelStatistics;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof TerminalTableModel.TerminalTableModelEvent) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            if (TerminalAccessor.values()[n2] == TerminalAccessor.WEIGHT) {
                TerminalTableModel terminalTableModel = (TerminalTableModel)tableModelEvent.getSource();
                Terminal terminal = terminalTableModel.getTerminals().get(n);
                int n3 = ((TerminalTableModel.TerminalTableModelEvent)tableModelEvent).isAfterCommit() ? 1 : -1;
                String string = (String)TerminalAccessor.getData(TerminalAccessor.KIND, terminal);
                Double d = (Double)TerminalAccessor.getData(TerminalAccessor.WEIGHT, terminal);
                if ("fixed_parameter".equals(string)) {
                    if (d == 1.0) {
                        this.statistics.incFixedParameters(n3);
                    } else {
                        this.statistics.incRelaxedParameters(n3);
                    }
                } else if ("variable".equals(string)) {
                    if (d == 1.0) {
                        this.statistics.incFixedVariables(n3);
                    } else {
                        this.statistics.incRelaxedVariables(n3);
                    }
                }
                this.statistics.fireChange();
            }
        }
    }
}

