/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.modelica;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.graph.utils.ScilabExported;
import org.scilab.modules.xcos.modelica.ModelicaController;
import org.scilab.modules.xcos.modelica.model.Model;
import org.scilab.modules.xcos.modelica.model.ObjectFactory;
import org.xml.sax.SAXException;

public final class Modelica {
    private static final String LATIN1_ENCODING = "ISO-8859-1";
    private static final String MODEL_CLASS_PACKAGE = "org.scilab.modules.xcos.modelica.model";
    private static final String SCHEMA_FILENAME = "/Modelica.xsd";
    private static Modelica instance;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    private Modelica() {
        String string = ScilabConstants.SCI.getAbsolutePath() + "/modules/xcos/etc/Modelica.xsd";
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)MODEL_CLASS_PACKAGE);
            this.marshaller = jAXBContext.createMarshaller();
            this.unmarshaller = jAXBContext.createUnmarshaller();
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(string));
            this.marshaller.setSchema(schema);
            this.unmarshaller.setSchema(schema);
            this.marshaller.setProperty("jaxb.encoding", (Object)LATIN1_ENCODING);
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException(jAXBException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(Modelica.class.getName()).severe(sAXException.toString());
        }
    }

    public static Modelica getInstance() {
        if (instance == null) {
            instance = new Modelica();
        }
        return instance;
    }

    @ScilabExported(module="xcos", filename="Modelica.giws.xml")
    public static void load(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelicaController.showDialog(new File(string), new File(string2));
            }
        });
    }

    public Model load(File file) throws JAXBException {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName(LATIN1_ENCODING));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(Modelica.class.getName()).severe(fileNotFoundException.toString());
            return null;
        }
        return (Model)((JAXBElement)this.unmarshaller.unmarshal((Reader)inputStreamReader)).getValue();
    }

    public void save(Model model, File file) throws JAXBException {
        try {
            StringWriter stringWriter = new StringWriter();
            this.marshaller.marshal(new ObjectFactory().createModel(this.unmerge(model)), (Writer)stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            String string = System.getProperty("line.separator");
            Pattern pattern = Pattern.compile("(/\\w*>)(<[\\w/])");
            Matcher matcher = pattern.matcher(stringBuffer);
            while (matcher.find()) {
                int n = matcher.end(1);
                stringBuffer.insert(n, string);
                matcher.reset();
            }
            stringBuffer.append(string);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
                ((Writer)outputStreamWriter).append(stringBuffer);
            }
        }
        catch (IOException | FactoryConfigurationError throwable) {
            Logger.getLogger(Modelica.class.getName()).severe(throwable.toString());
        }
    }

    public Model merge(Model model, Model model2) {
        model.setIdentifiers(model2.getIdentifiers());
        model.setModelInfo(model2.getModelInfo());
        model.setExplicitRelations(model2.getExplicitRelations());
        model.setImplicitRelations(model2.getImplicitRelations());
        model.setOutputs(model2.getOutputs());
        return model;
    }

    public Model unmerge(Model model) {
        Model model2 = new Model();
        model2.setName(model.getName());
        model2.setElements(model.getElements());
        model2.setEquations(model.getEquations());
        model2.setWhenClauses(model.getWhenClauses());
        return model2;
    }
}

