/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.link;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import java.awt.MouseInfo;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.DeleteAction;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.contextmenu.ContextMenu;
import org.scilab.modules.gui.contextmenu.ScilabContextMenu;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.actions.EditFormatAction;
import org.scilab.modules.xcos.block.actions.BorderColorAction;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.link.actions.StyleHorizontalAction;
import org.scilab.modules.xcos.link.actions.StyleOptimalAction;
import org.scilab.modules.xcos.link.actions.StyleStraightAction;
import org.scilab.modules.xcos.link.actions.StyleVerticalAction;
import org.scilab.modules.xcos.preferences.XcosOptions;
import org.scilab.modules.xcos.utils.XcosMessages;

public abstract class BasicLink
extends XcosCell {
    private static final mxGeometry DEFAULT_GEOMETRY = new mxGeometry(0.0, 0.0, 80.0, 80.0);
    private static final int DETECTION_RECTANGLE_DIMENSION = 10;
    private transient int ordering;

    public BasicLink(JavaController javaController, long l, Kind kind, Object object, mxGeometry mxGeometry2, String string, String string2, int n) {
        super(javaController, l, kind, object, mxGeometry2, string == null ? XcosOptions.getEdition().getEdgeStyle() : string, string2);
        this.vertex = false;
        this.edge = true;
        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.KIND, n);
    }

    public void setOrdering(int n) {
        this.ordering = n;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public void removePoint(int n) {
        if (this.getGeometry() == null || this.getGeometry().getPoints() == null) {
            return;
        }
        if (n < this.getGeometry().getPoints().size()) {
            this.getGeometry().getPoints().remove(n);
        }
    }

    private void removePoints() {
        this.getGeometry().setPoints(new ArrayList());
    }

    public List<mxPoint> getPoints(int n, boolean bl) {
        if (this.getGeometry() == null || this.getGeometry().getPoints() == null) {
            return new ArrayList<mxPoint>();
        }
        List list = this.getGeometry().getPoints();
        if (bl) {
            return new ArrayList<mxPoint>(list.subList(0, Math.min(list.size(), n)));
        }
        if (n < list.size()) {
            return new ArrayList<mxPoint>(list.subList(n, list.size()));
        }
        return new ArrayList<mxPoint>();
    }

    public int getPointCount() {
        if (this.getGeometry() == null || this.getGeometry().getPoints() == null) {
            return 0;
        }
        return this.getGeometry().getPoints().size();
    }

    public int findNearestSegment(mxPoint mxPoint2) {
        if (this.getGeometry() == null || this.getGeometry().getPoints() == null) {
            return 0;
        }
        double d = this.getSource().getParent().getGeometry().getX() + this.getSource().getGeometry().getX();
        double d2 = this.getSource().getParent().getGeometry().getY() + this.getSource().getGeometry().getY();
        double d3 = this.getTarget().getParent().getGeometry().getX() + this.getTarget().getGeometry().getX();
        double d4 = this.getTarget().getParent().getGeometry().getY() + this.getTarget().getGeometry().getY();
        double d5 = -1.0;
        int n = 0;
        for (int i = 0; i < this.getGeometry().getPoints().size() + 1; ++i) {
            Point2D.Double double_ = null;
            Point2D.Double double_2 = null;
            double_ = i == 0 ? new Point2D.Double(d, d2) : new Point2D.Double((int)((mxPoint)this.getGeometry().getPoints().get(i - 1)).getX(), (int)((mxPoint)this.getGeometry().getPoints().get(i - 1)).getY());
            double_2 = i == this.getGeometry().getPoints().size() ? new Point2D.Double(d3, d4) : new Point2D.Double((int)((mxPoint)this.getGeometry().getPoints().get(i)).getX(), (int)((mxPoint)this.getGeometry().getPoints().get(i)).getY());
            Point2D.Double double_3 = new Point2D.Double(mxPoint2.getX(), mxPoint2.getY());
            Line2D.Double double_4 = new Line2D.Double(double_, double_2);
            if (d5 == -1.0) {
                d5 = double_4.ptSegDist(double_3);
                n = i;
                continue;
            }
            double d6 = double_4.ptSegDist(double_3);
            if (!(d6 < d5)) continue;
            d5 = d6;
            n = i;
        }
        return n;
    }

    public void addPoint(double d, double d2) {
        mxPoint mxPoint2 = new mxPoint(d, d2);
        if (this.getGeometry().getPoints() == null) {
            this.getGeometry().setPoints(new ArrayList());
        }
        this.getGeometry().getPoints().add(mxPoint2);
    }

    public void insertPoint(mxPoint mxPoint2) {
        if (this.isLoopLink()) {
            mxGeometry mxGeometry2 = this.getSource().getParent().getGeometry();
            mxPoint2.setX(mxPoint2.getX() - mxGeometry2.getX());
            mxPoint2.setY(mxPoint2.getY() - mxGeometry2.getY());
        }
        if (this.getGeometry() == null) {
            this.setGeometry(DEFAULT_GEOMETRY);
        }
        if (this.getGeometry().getPoints() == null) {
            this.getGeometry().setPoints(new ArrayList());
            this.getGeometry().getPoints().add(mxPoint2);
        } else {
            int n;
            for (n = 0; n < this.getGeometry().getPoints().size(); ++n) {
                mxPoint mxPoint3 = (mxPoint)this.getGeometry().getPoints().get(n);
                mxRectangle mxRectangle2 = new mxRectangle(mxPoint3.getX() - 5.0, mxPoint3.getY() - 5.0, 10.0, 10.0);
                if (!mxRectangle2.contains(mxPoint2.getX(), mxPoint2.getY())) continue;
                this.getGeometry().getPoints().remove(n);
                return;
            }
            n = this.findNearestSegment(mxPoint2);
            this.getGeometry().getPoints().add(n, mxPoint2);
        }
    }

    private boolean isLoopLink() {
        return this.getSource() != null && this.getTarget() != null && this.getSource().getParent() == this.getParent() && this.getTarget().getParent() == this.getParent();
    }

    public abstract double[][] getColorAndType();

    public abstract int getLinkKind();

    public void openContextMenu(ScilabGraph scilabGraph) {
        ContextMenu contextMenu = ScilabContextMenu.createContextMenu();
        contextMenu.add(DeleteAction.createMenu((ScilabGraph)scilabGraph));
        contextMenu.getAsSimpleContextMenu().addSeparator();
        Menu menu = ScilabMenu.createMenu();
        menu.setText(XcosMessages.FORMAT);
        menu.add(BorderColorAction.createMenu(scilabGraph));
        menu.add(EditFormatAction.createMenu(scilabGraph));
        contextMenu.add(menu);
        contextMenu.getAsSimpleContextMenu().addSeparator();
        Menu menu2 = ScilabMenu.createMenu();
        menu2.setText(XcosMessages.LINK_STYLE);
        menu2.add(StyleHorizontalAction.createMenu(scilabGraph));
        menu2.add(StyleStraightAction.createMenu(scilabGraph));
        menu2.add(StyleVerticalAction.createMenu(scilabGraph));
        menu2.add(StyleOptimalAction.createMenu(scilabGraph));
        contextMenu.add(menu2);
        ((SwingScilabContextMenu)contextMenu.getAsSimpleContextMenu()).setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        contextMenu.setVisible(true);
    }

    public void invertDirection() {
        mxICell mxICell2 = this.getSource();
        mxICell mxICell3 = this.getTarget();
        List list = this.getGeometry().getPoints();
        this.setSource(mxICell3);
        this.setTarget(mxICell2);
        if (list != null) {
            this.removePoints();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.addPoint(((mxPoint)list.get(i)).getX(), ((mxPoint)list.get(i)).getY());
            }
        }
    }

    public boolean isConnectable() {
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.source);
        stringBuilder.append(" -> ");
        if (this.getChildCount() > 0) {
            stringBuilder.append(this.getChildAt(0).getValue());
        } else {
            stringBuilder.append(((Object)((Object)this)).getClass().getSimpleName());
        }
        stringBuilder.append(" -> ");
        stringBuilder.append(this.target).append("\n");
        return stringBuilder.toString();
    }
}

