/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import java.util.List;
import org.scilab.modules.localization.Messages;

public abstract class ScicosFormatException
extends Exception {
    private static final String UNABLE_TO_DECODE_INVALID_DATA = Messages.gettext((String)"Unable to decode \"%s\" : invalid data.");
    private static final String UNABLE_TO_DECODE_INVALID_FIELD = Messages.gettext((String)"Unable to decode \"%s.%s\" : invalid field.");

    protected ScicosFormatException() {
        if (!(this instanceof VersionMismatchException)) {
            this.printStackTrace();
        }
    }

    public ScicosFormatException(String string) {
        super(string);
    }

    public ScicosFormatException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public ScicosFormatException(Throwable throwable) {
        super(throwable);
    }

    public static class VersionMismatchException
    extends ScicosFormatException {
        private final String wrongVersion;

        public VersionMismatchException(String string) {
            this.wrongVersion = string;
        }

        public String getWrongVersion() {
            return this.wrongVersion;
        }
    }

    public static class WrongStructureException
    extends ScicosFormatException {
        public WrongStructureException() {
        }

        public WrongStructureException(String string) {
            super(String.format(UNABLE_TO_DECODE_INVALID_DATA, string));
        }

        public WrongStructureException(List<String> list) {
            super(String.format(UNABLE_TO_DECODE_INVALID_DATA, list.get(0)));
        }
    }

    public static class WrongTypeException
    extends ScicosFormatException {
        public WrongTypeException() {
        }

        public WrongTypeException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public WrongTypeException(Throwable throwable) {
            super(throwable);
        }

        public WrongTypeException(List<String> list, int n) {
            super(String.format(UNABLE_TO_DECODE_INVALID_FIELD, list.get(0), list.get(n)));
        }
    }

    public static class WrongElementException
    extends ScicosFormatException {
        public WrongElementException() {
            this.printStackTrace();
        }
    }
}

