/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.codec;

import com.mxgraph.io.mxCellCodec;
import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.io.mxObjectCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.TextBlock;
import org.scilab.modules.xcos.graph.model.BlockInterFunction;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.io.codec.XcosObjectCodec;
import org.scilab.modules.xcos.port.BasicPort;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BasicBlockCodec
extends XcosObjectCodec {
    private static final String BASIC_BLOCK = BasicBlock.class.getSimpleName();
    private static final String[] IGNORED_FIELDS = new String[0];
    private static final Logger LOG = Logger.getLogger(BasicBlockCodec.class.getName());

    public BasicBlockCodec(Object object, String[] stringArray, String[] stringArray2, Map<String, String> map) {
        super(object, stringArray, stringArray2, map);
    }

    public static void register() {
        try {
            Object object2;
            mxCodecRegistry.addPackage((String)"org.scilab.modules.xcos.block");
            mxCodecRegistry.addPackage((String)"org.scilab.modules.xcos.block.io");
            mxCodecRegistry.addPackage((String)"org.scilab.modules.xcos.block.custom");
            Map<Class, List<BlockInterFunction>> map = EnumSet.allOf(BlockInterFunction.class).stream().collect(Collectors.groupingBy(BlockInterFunction::getKlass));
            for (Object object2 : map.keySet()) {
                String string = map.get(object2).get(0).name();
                BasicBlockCodec basicBlockCodec = new BasicBlockCodec(XcosCellFactory.createBlock(string), IGNORED_FIELDS, REFS, null);
                mxCodecRegistry.register((mxObjectCodec)basicBlockCodec);
            }
            mxCellCodec mxCellCodec2 = new mxCellCodec((Object)new mxCell(), null, REFS, null);
            mxCodecRegistry.register((mxObjectCodec)mxCellCodec2);
            object2 = (BasicBlockCodec)mxCodecRegistry.getCodec((String)"AfficheBlock");
            ((BasicBlockCodec)((Object)object2)).exclude.add("printTimer");
            ((BasicBlockCodec)((Object)object2)).exclude.add("updateAction");
            mxCodecRegistry.addAlias((String)"ConstBlock", (String)BASIC_BLOCK);
            mxCodecRegistry.addAlias((String)"GainBlock", (String)BASIC_BLOCK);
            mxCodecRegistry.addAlias((String)"PrintBlock", (String)BASIC_BLOCK);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object beforeEncode(mxCodec mxCodec2, Object object, Node node) {
        BasicBlock basicBlock = (BasicBlock)object;
        for (int i = 0; i < basicBlock.getChildCount(); ++i) {
            mxICell mxICell2 = basicBlock.getChildAt(i);
            if (mxICell2 instanceof BasicPort) {
                if (mxICell2.getParent() == basicBlock) continue;
                this.trace(mxCodec2, node, "Inconsistent parent", new Object[0]);
                continue;
            }
            if (mxICell2 instanceof mxCell) continue;
            this.trace(mxCodec2, node, "Inconsistent child %s at %d", mxICell2, i);
        }
        if (basicBlock.getEdgeCount() > 0) {
            this.trace(mxCodec2, node, "Has %d links", basicBlock.getEdgeCount());
        }
        return super.beforeEncode(mxCodec2, object, node);
    }

    public Node beforeDecode(mxCodec mxCodec2, Node node, Object object) {
        return node;
    }

    @Override
    public Object afterDecode(mxCodec mxCodec2, Node node, Object object) {
        String[] stringArray;
        if (!(object instanceof BasicBlock)) {
            LOG.severe("Unable to decode " + String.valueOf(object));
            return object;
        }
        BasicBlock basicBlock = (BasicBlock)object;
        JavaController javaController = new JavaController();
        if (basicBlock instanceof TextBlock) {
            basicBlock.setValue(mxUtils.getBodyMarkup((String)String.valueOf(basicBlock.getValue()), (boolean)true));
        }
        StyleMap styleMap = new StyleMap(((Element)node).getAttribute("style"));
        this.formatStyle(styleMap, (BasicBlock)object, javaController);
        basicBlock.setStyle(styleMap.toString());
        if (node.getNodeName().equals("ConstBlock")) {
            stringArray = new String[1];
            javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, stringArray);
            if ("xcos_block".equals(stringArray[0])) {
                javaController.setObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, "CONST_m");
            }
            javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.SIM_FUNCTION_NAME, stringArray);
            if ("xcos_simulate".equals(stringArray[0])) {
                javaController.setObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.SIM_FUNCTION_NAME, "cstblk4");
            }
            if (basicBlock.getValue() == null) {
                basicBlock.setValue("1");
            }
        }
        if (node.getNodeName().equals("GainBlock")) {
            stringArray = new String[1];
            javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, stringArray);
            if ("xcos_block".equals(stringArray[0])) {
                javaController.setObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, "GAINBLK_f");
            }
        }
        return super.afterDecode(mxCodec2, node, object);
    }

    private void formatStyle(StyleMap styleMap, BasicBlock basicBlock, JavaController javaController) {
        String[] stringArray = new String[1];
        javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, stringArray);
        String string = stringArray[0];
        if (!styleMap.containsKey((Object)string)) {
            styleMap.put((Object)string, null);
        }
        this.formatStyle(styleMap);
    }

    protected Object getFieldTemplate(Object object, String string, Node node) {
        Object object2 = this.getFieldValue(object, string);
        if (object2 instanceof ScilabType) {
            return null;
        }
        return super.getFieldTemplate(object, string, node);
    }
}

