/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IllegalFormatException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabInteger;
import org.scilab.modules.types.ScilabIntegerTypeEnum;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.VectorOfScicosID;

public class ScilabTypeCoder {
    private static final Logger LOG = Logger.getLogger("org.scilab.modules.xcos.io");
    int position = 0;

    public VectorOfDouble var2vec(ScilabType scilabType) {
        Object object = scilabType == null ? new ScilabDouble() : scilabType;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering(ScilabTypeCoder.class.getCanonicalName(), "var2vec");
        }
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        this.encode((ScilabType)object, vectorOfDouble);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "var2vec:{0}:{1}", new Object[]{scilabType.toString(), ScilabTypeCoder.toString(vectorOfDouble)});
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.exiting(ScilabTypeCoder.class.getCanonicalName(), "var2vec");
        }
        return vectorOfDouble;
    }

    private VectorOfDouble encode(ScilabType scilabType, VectorOfDouble vectorOfDouble) {
        switch (scilabType.getType()) {
            case sci_matrix: {
                this.encode((ScilabDouble)scilabType, vectorOfDouble);
                break;
            }
            case sci_ints: {
                this.encode((ScilabInteger)scilabType, vectorOfDouble);
                break;
            }
            case sci_boolean: {
                this.encode((ScilabBoolean)scilabType, vectorOfDouble);
                break;
            }
            case sci_strings: {
                this.encode((ScilabString)scilabType, vectorOfDouble);
                break;
            }
            case sci_list: {
                this.encode((ArrayList)scilabType, vectorOfDouble, scilabType.getType());
                break;
            }
            case sci_mlist: {
                this.encode((ArrayList)scilabType, vectorOfDouble, scilabType.getType());
                break;
            }
            case sci_tlist: {
                this.encode((ArrayList)scilabType, vectorOfDouble, scilabType.getType());
                break;
            }
        }
        return vectorOfDouble;
    }

    private void encode(ScilabDouble scilabDouble, VectorOfDouble vectorOfDouble) {
        int n;
        int n2;
        this.encodeHeader(scilabDouble, vectorOfDouble, ScilabTypeEnum.sci_matrix);
        if (scilabDouble.getHeight() * scilabDouble.getWidth() == 0) {
            return;
        }
        if (scilabDouble.isReal()) {
            vectorOfDouble.add(0.0);
        } else {
            vectorOfDouble.add(1.0);
        }
        for (n2 = 0; n2 < scilabDouble.getHeight(); ++n2) {
            for (n = 0; n < scilabDouble.getWidth(); ++n) {
                vectorOfDouble.add(scilabDouble.getRealElement(n2, n));
            }
        }
        if (!scilabDouble.isReal()) {
            for (n2 = 0; n2 < scilabDouble.getHeight(); ++n2) {
                for (n = 0; n < scilabDouble.getWidth(); ++n) {
                    vectorOfDouble.add(scilabDouble.getImaginaryElement(n2, n));
                }
            }
        }
    }

    private void encode(ScilabInteger scilabInteger, VectorOfDouble vectorOfDouble) {
        int n;
        long[][] lArray = null;
        short[][] sArray = null;
        int[][] nArray = null;
        byte[][] byArray = null;
        switch (scilabInteger.getPrec()) {
            case sci_int64: 
            case sci_uint64: {
                n = 8;
                lArray = scilabInteger.getDataAsLong();
                break;
            }
            case sci_int32: 
            case sci_uint32: {
                n = 4;
                nArray = scilabInteger.getDataAsInt();
                break;
            }
            case sci_int16: 
            case sci_uint16: {
                n = 2;
                sArray = scilabInteger.getDataAsShort();
                break;
            }
            case sci_int8: 
            case sci_uint8: {
                n = 1;
                byArray = scilabInteger.getDataAsByte();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.encodeHeader(scilabInteger, vectorOfDouble, ScilabTypeEnum.sci_ints);
        if (scilabInteger.getHeight() * scilabInteger.getWidth() == 0) {
            return;
        }
        int n2 = n * scilabInteger.getHeight() * scilabInteger.getWidth();
        int n3 = (n2 + 8 - 1) / 8;
        int n4 = vectorOfDouble.size();
        vectorOfDouble.resize(n4 + n3);
        ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(n4, n3);
        for (int i = 0; i < scilabInteger.getHeight(); ++i) {
            block13: for (int j = 0; j < scilabInteger.getWidth(); ++j) {
                switch (scilabInteger.getPrec()) {
                    case sci_int64: 
                    case sci_uint64: {
                        byteBuffer.putLong(lArray[i][j]);
                        continue block13;
                    }
                    case sci_int32: 
                    case sci_uint32: {
                        byteBuffer.putInt(nArray[i][j]);
                        continue block13;
                    }
                    case sci_int16: 
                    case sci_uint16: {
                        byteBuffer.putShort(sArray[i][j]);
                        continue block13;
                    }
                    case sci_int8: 
                    case sci_uint8: {
                        byteBuffer.put(byArray[i][j]);
                    }
                }
            }
        }
    }

    private void encode(ScilabBoolean scilabBoolean, VectorOfDouble vectorOfDouble) {
        this.encodeHeader(scilabBoolean, vectorOfDouble, ScilabTypeEnum.sci_boolean);
        if (scilabBoolean.getHeight() * scilabBoolean.getWidth() == 0) {
            return;
        }
        int n = 4 * scilabBoolean.getHeight() * scilabBoolean.getWidth();
        int n2 = (n + 8 - 1) / 8;
        int n3 = vectorOfDouble.size();
        vectorOfDouble.resize(n3 + n2);
        ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(n3, n2);
        for (int i = 0; i < scilabBoolean.getHeight(); ++i) {
            for (int j = 0; j < scilabBoolean.getWidth(); ++j) {
                byteBuffer.putInt(scilabBoolean.getData()[i][j] ? 1 : 0);
            }
        }
    }

    private void encode(ScilabString scilabString, VectorOfDouble vectorOfDouble) {
        this.encodeHeader(scilabString, vectorOfDouble, ScilabTypeEnum.sci_strings);
        if (scilabString.getHeight() * scilabString.getWidth() == 0) {
            return;
        }
        int n = vectorOfDouble.size();
        vectorOfDouble.resize(n + scilabString.getHeight() * scilabString.getWidth());
        int n2 = 0;
        Charset charset = Charset.forName("UTF-8");
        for (int i = 0; i < scilabString.getHeight(); ++i) {
            for (int j = 0; j < scilabString.getWidth(); ++j) {
                String string = scilabString.getData()[i][j];
                byte[] byArray = string.getBytes(charset);
                int n3 = byArray.length + 1;
                int n4 = (n3 + 8 - 1) / 8;
                vectorOfDouble.set(n++, n2 += n4);
                int n5 = vectorOfDouble.size();
                vectorOfDouble.resize(n5 + n4);
                vectorOfDouble.asByteBuffer(n5, n4).put(byArray).put((byte)0);
            }
        }
    }

    private void encode(ArrayList<ScilabType> arrayList, VectorOfDouble vectorOfDouble, ScilabTypeEnum scilabTypeEnum) {
        this.encodeHeader(arrayList, vectorOfDouble, scilabTypeEnum);
        for (ScilabType scilabType : arrayList) {
            this.encode(scilabType, vectorOfDouble);
        }
    }

    private void encodeHeader(Object object, VectorOfDouble vectorOfDouble, ScilabTypeEnum scilabTypeEnum) {
        ScilabType scilabType = null;
        ArrayList arrayList = null;
        switch (scilabTypeEnum) {
            case sci_matrix: 
            case sci_ints: 
            case sci_boolean: 
            case sci_strings: {
                scilabType = (ScilabType)object;
                break;
            }
            case sci_list: 
            case sci_mlist: 
            case sci_tlist: {
                arrayList = (ArrayList)object;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (scilabType != null && scilabType.getHeight() * scilabType.getWidth() == 0) {
            vectorOfDouble.add(ScilabTypeEnum.sci_matrix.swigValue());
            vectorOfDouble.add(2.0);
            vectorOfDouble.add(0.0);
            vectorOfDouble.add(0.0);
            vectorOfDouble.add(0.0);
            return;
        }
        vectorOfDouble.add(scilabTypeEnum.swigValue());
        if (scilabType instanceof ScilabInteger) {
            vectorOfDouble.add(((ScilabInteger)scilabType).getPrec().swigValue());
        }
        if (scilabType != null) {
            vectorOfDouble.add(2.0);
            vectorOfDouble.add(scilabType.getHeight());
            vectorOfDouble.add(scilabType.getWidth());
        } else if (arrayList != null) {
            vectorOfDouble.add(arrayList.size());
        } else {
            throw new IllegalArgumentException();
        }
    }

    public ScilabType vec2var(VectorOfDouble vectorOfDouble) {
        this.position = 0;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering(ScilabTypeCoder.class.getName(), "vec2var", vectorOfDouble);
        }
        ScilabType scilabType = this.decodeHeader(vectorOfDouble);
        try {
            this.decode(vectorOfDouble, scilabType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            LOG.log(Level.SEVERE, "Unable to decode {0}", ScilabTypeCoder.toString(vectorOfDouble));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "vec2var:{0}:{1}", new Object[]{ScilabTypeCoder.toString(vectorOfDouble), scilabType.toString()});
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.exiting(ScilabTypeCoder.class.getName(), "vec2var");
        }
        return scilabType;
    }

    private ScilabType decode(VectorOfDouble vectorOfDouble, ScilabType scilabType) {
        switch (scilabType.getType()) {
            case sci_matrix: {
                this.decode(vectorOfDouble, (ScilabDouble)scilabType);
                break;
            }
            case sci_ints: {
                this.decode(vectorOfDouble, (ScilabInteger)scilabType);
                break;
            }
            case sci_boolean: {
                this.decode(vectorOfDouble, (ScilabBoolean)scilabType);
                break;
            }
            case sci_strings: {
                this.decode(vectorOfDouble, (ScilabString)scilabType);
                break;
            }
            case sci_list: {
                this.decode(vectorOfDouble, (ArrayList)scilabType);
                break;
            }
            case sci_mlist: {
                this.decode(vectorOfDouble, (ArrayList)scilabType);
                break;
            }
            case sci_tlist: {
                this.decode(vectorOfDouble, (ArrayList)scilabType);
                break;
            }
        }
        return scilabType;
    }

    private ScilabType decode(VectorOfDouble vectorOfDouble, ScilabDouble scilabDouble) {
        int n;
        double[][] dArray = scilabDouble.getRealPart();
        for (int i = 0; i < scilabDouble.getHeight(); ++i) {
            for (n = 0; n < scilabDouble.getWidth(); ++n) {
                dArray[i][n] = vectorOfDouble.get(this.position++);
            }
        }
        if (!scilabDouble.isReal()) {
            double[][] dArray2 = scilabDouble.getImaginaryPart();
            for (n = 0; n < scilabDouble.getHeight(); ++n) {
                for (int i = 0; i < scilabDouble.getWidth(); ++i) {
                    dArray2[n][i] = vectorOfDouble.get(this.position++);
                }
            }
        }
        return scilabDouble;
    }

    private ScilabType decode(VectorOfDouble vectorOfDouble, ScilabInteger scilabInteger) {
        int n;
        long[][] lArray = null;
        short[][] sArray = null;
        int[][] nArray = null;
        byte[][] byArray = null;
        switch (scilabInteger.getPrec()) {
            case sci_int64: 
            case sci_uint64: {
                n = 8;
                lArray = scilabInteger.getDataAsLong();
                break;
            }
            case sci_int32: 
            case sci_uint32: {
                n = 4;
                nArray = scilabInteger.getDataAsInt();
                break;
            }
            case sci_int16: 
            case sci_uint16: {
                n = 2;
                sArray = scilabInteger.getDataAsShort();
                break;
            }
            case sci_int8: 
            case sci_uint8: {
                n = 1;
                byArray = scilabInteger.getDataAsByte();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = this.requiredLength(n, scilabInteger.getHeight(), scilabInteger.getWidth());
        ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(this.position, n2);
        for (int i = 0; i < scilabInteger.getHeight(); ++i) {
            block13: for (int j = 0; j < scilabInteger.getWidth(); ++j) {
                switch (scilabInteger.getPrec()) {
                    case sci_int64: 
                    case sci_uint64: {
                        lArray[i][j] = byteBuffer.getLong();
                        continue block13;
                    }
                    case sci_int32: 
                    case sci_uint32: {
                        nArray[i][j] = byteBuffer.getInt();
                        continue block13;
                    }
                    case sci_int16: 
                    case sci_uint16: {
                        sArray[i][j] = byteBuffer.getShort();
                        continue block13;
                    }
                    case sci_int8: 
                    case sci_uint8: {
                        byArray[i][j] = byteBuffer.get();
                    }
                }
            }
        }
        this.position += n2;
        return scilabInteger;
    }

    private ScilabType decode(VectorOfDouble vectorOfDouble, ScilabBoolean scilabBoolean) {
        boolean[][] blArray = scilabBoolean.getData();
        int n = 4 * scilabBoolean.getHeight() * scilabBoolean.getWidth() / 8 + 1;
        ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(this.position, n);
        for (int i = 0; i < scilabBoolean.getHeight(); ++i) {
            for (int j = 0; j < scilabBoolean.getWidth(); ++j) {
                blArray[i][j] = byteBuffer.getInt() != 0;
            }
        }
        this.position += n;
        return scilabBoolean;
    }

    private ScilabType decode(VectorOfDouble vectorOfDouble, ScilabString scilabString) {
        String[][] stringArray = scilabString.getData();
        this.decodeString(scilabString.getHeight(), scilabString.getWidth(), vectorOfDouble, (n, n2, string) -> {
            stringArray[n.intValue()][n2.intValue()] = string;
        });
        return scilabString;
    }

    private void decodeString(int n, int n2, VectorOfDouble vectorOfDouble, StoreFunction<Integer, Integer, String> storeFunction) {
        int n3;
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (n3 = 0; n3 < n2; ++n3) {
                nArray[i][n3] = (int)vectorOfDouble.get(this.position++);
            }
        }
        Charset charset = Charset.forName("UTF-8");
        n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = nArray[i][j] - n3;
                ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(this.position, n4);
                byte[] byArray = new byte[n4 * 8];
                byteBuffer.get(byArray);
                int n5 = 0;
                while (byArray[n5] != 0) {
                    ++n5;
                }
                storeFunction.apply(i, j, new String(byArray, 0, n5, charset));
                n3 += n4;
                this.position += n4;
            }
        }
    }

    private ScilabType decode(VectorOfDouble vectorOfDouble, ArrayList<ScilabType> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ScilabType scilabType = this.decodeHeader(vectorOfDouble);
            this.decode(vectorOfDouble, scilabType);
            arrayList.set(i, scilabType);
        }
        return (ScilabType)arrayList;
    }

    private ScilabType decodeHeader(VectorOfDouble vectorOfDouble) {
        int n = (int)vectorOfDouble.get(this.position++);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ScilabTypeEnum scilabTypeEnum = ScilabTypeEnum.swigToEnum((int)n);
        switch (scilabTypeEnum) {
            case sci_ints: {
                n2 = (int)vectorOfDouble.get(this.position++);
            }
            case sci_matrix: 
            case sci_boolean: 
            case sci_strings: {
                ++this.position;
                n3 = (int)vectorOfDouble.get(this.position++);
                n4 = (int)vectorOfDouble.get(this.position++);
                break;
            }
            case sci_list: 
            case sci_mlist: 
            case sci_tlist: {
                n5 = (int)vectorOfDouble.get(this.position++);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        double[][] dArray = null;
        if (scilabTypeEnum == ScilabTypeEnum.sci_matrix) {
            boolean bl;
            boolean bl2 = bl = vectorOfDouble.get(this.position++) != 0.0;
            if (bl) {
                dArray = new double[n3][n4];
            }
        }
        switch (scilabTypeEnum) {
            case sci_matrix: {
                if (n3 * n4 == 0) {
                    return new ScilabDouble();
                }
                return new ScilabDouble(new double[n3][n4], dArray);
            }
            case sci_boolean: {
                if (n3 * n4 == 0) {
                    return new ScilabDouble();
                }
                return new ScilabBoolean(new boolean[n3][n4]);
            }
            case sci_ints: {
                if (n3 * n4 == 0) {
                    return new ScilabDouble();
                }
                switch (ScilabIntegerTypeEnum.swigToEnum((int)n2)) {
                    case sci_int8: {
                        return new ScilabInteger(new byte[n3][n4], false);
                    }
                    case sci_int16: {
                        return new ScilabInteger(new short[n3][n4], false);
                    }
                    case sci_int32: {
                        return new ScilabInteger(new int[n3][n4], false);
                    }
                    case sci_int64: {
                        return new ScilabInteger(new long[n3][n4], false);
                    }
                    case sci_uint8: {
                        return new ScilabInteger(new byte[n3][n4], true);
                    }
                    case sci_uint16: {
                        return new ScilabInteger(new short[n3][n4], true);
                    }
                    case sci_uint32: {
                        return new ScilabInteger(new int[n3][n4], true);
                    }
                    case sci_uint64: {
                        return new ScilabInteger(new long[n3][n4], true);
                    }
                }
            }
            case sci_strings: {
                if (n3 * n4 == 0) {
                    return new ScilabDouble();
                }
                return new ScilabString(new String[n3][n4]);
            }
            case sci_list: {
                return new ScilabList(Collections.nCopies(n5, null));
            }
            case sci_mlist: {
                return new ScilabMList(new String[n5 - 1], Collections.nCopies(n5 - 1, null));
            }
            case sci_tlist: {
                return new ScilabTList(new String[n5 - 1], Collections.nCopies(n5 - 1, null));
            }
        }
        throw new IllegalArgumentException();
    }

    public String format(String string, VectorOfDouble vectorOfDouble) throws IllegalFormatException, IllegalArgumentException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.decodeToJava(vectorOfDouble, arrayList);
        return String.format(string, arrayList.toArray());
    }

    private int requiredLength(int n, int n2, int n3) {
        if (n == 8) {
            return n2 * n3 * n / 8;
        }
        return (n2 * n3 * n + 7) / 8;
    }

    private void decodeToJava(VectorOfDouble vectorOfDouble, ArrayList<Object> arrayList) {
        int n3 = (int)vectorOfDouble.get(this.position++);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        ScilabTypeEnum scilabTypeEnum = ScilabTypeEnum.swigToEnum((int)n3);
        switch (scilabTypeEnum) {
            case sci_ints: {
                n4 = (int)vectorOfDouble.get(this.position++);
            }
            case sci_matrix: 
            case sci_boolean: 
            case sci_strings: {
                ++this.position;
                n5 = (int)vectorOfDouble.get(this.position++);
                n6 = (int)vectorOfDouble.get(this.position++);
                break;
            }
            case sci_list: 
            case sci_mlist: 
            case sci_tlist: {
                n7 = (int)vectorOfDouble.get(this.position++);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        boolean bl = false;
        if (scilabTypeEnum == ScilabTypeEnum.sci_matrix) {
            bl = vectorOfDouble.get(this.position++) != 0.0;
        }
        block5 : switch (scilabTypeEnum) {
            case sci_matrix: {
                int n8;
                int n9;
                for (n9 = 0; n9 < n5; ++n9) {
                    for (n8 = 0; n8 < n6; ++n8) {
                        arrayList.add(vectorOfDouble.get(this.position++));
                    }
                }
                if (!bl) break;
                for (n9 = 0; n9 < n5; ++n9) {
                    for (n8 = 0; n8 < n6; ++n8) {
                        arrayList.add(vectorOfDouble.get(this.position++));
                    }
                }
                break;
            }
            case sci_boolean: {
                int n10 = this.requiredLength(4, n5, n6);
                ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(this.position, n10);
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        arrayList.add(byteBuffer.getInt() != 0);
                    }
                }
                this.position += n10;
                break;
            }
            case sci_ints: {
                switch (ScilabIntegerTypeEnum.swigToEnum((int)n4)) {
                    case sci_int8: 
                    case sci_uint8: {
                        int n11 = this.requiredLength(1, n5, n6);
                        ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(this.position, n11);
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n6; ++j) {
                                arrayList.add(byteBuffer.get());
                            }
                        }
                        break block5;
                    }
                    case sci_int16: 
                    case sci_uint16: {
                        int n12 = this.requiredLength(2, n5, n6);
                        ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(this.position, n12);
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n6; ++j) {
                                arrayList.add(byteBuffer.getShort());
                            }
                        }
                        break block5;
                    }
                    case sci_int32: 
                    case sci_uint32: {
                        int n13 = this.requiredLength(4, n5, n6);
                        ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(this.position, n13);
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n6; ++j) {
                                arrayList.add(byteBuffer.getInt());
                            }
                        }
                        break block5;
                    }
                    case sci_int64: 
                    case sci_uint64: {
                        int n14 = this.requiredLength(8, n5, n6);
                        ByteBuffer byteBuffer = vectorOfDouble.asByteBuffer(this.position, n14);
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n6; ++j) {
                                arrayList.add(byteBuffer.getLong());
                            }
                        }
                    }
                }
                break;
            }
            case sci_strings: {
                this.decodeString(n5, n6, vectorOfDouble, (n, n2, string) -> arrayList.add(string));
                break;
            }
            case sci_list: 
            case sci_mlist: 
            case sci_tlist: {
                for (int i = 0; i < n7; ++i) {
                    this.decodeToJava(vectorOfDouble, arrayList);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static String toString(VectorOfDouble vectorOfDouble) {
        int n = vectorOfDouble.size();
        double[] dArray = new double[n];
        DoubleBuffer.wrap(dArray).put(vectorOfDouble.asByteBuffer(0, n).asDoubleBuffer());
        return Arrays.toString(dArray);
    }

    public static String toString(VectorOfScicosID vectorOfScicosID) {
        int n = vectorOfScicosID.size();
        long[] lArray = new long[n];
        LongBuffer.wrap(lArray).put(vectorOfScicosID.asByteBuffer(0, n).asLongBuffer());
        return Arrays.toString(lArray);
    }

    public static String toString(VectorOfInt vectorOfInt) {
        int n = vectorOfInt.size();
        int[] nArray = new int[n];
        IntBuffer.wrap(nArray).put(vectorOfInt.asByteBuffer(0, n).asIntBuffer());
        return Arrays.toString(nArray);
    }

    @FunctionalInterface
    private static interface StoreFunction<R, C, V> {
        public void apply(R var1, C var2, V var3);
    }

    static class JavaScilabType {
        final ScilabTypeEnum type;
        final ScilabIntegerTypeEnum intType;

        public JavaScilabType(ScilabTypeEnum scilabTypeEnum, ScilabIntegerTypeEnum scilabIntegerTypeEnum) {
            this.type = scilabTypeEnum;
            this.intType = scilabIntegerTypeEnum;
        }
    }
}

