/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.scilab.modules.xcos.io.HandledElementsCategory;

public enum HandledElement {
    add(HandledElementsCategory.RAW_DATA),
    AfficheBlock(HandledElementsCategory.BLOCK),
    Array(HandledElementsCategory.RAW_DATA),
    BasicBlock(HandledElementsCategory.BLOCK),
    BigSom(HandledElementsCategory.BLOCK),
    CommandControlLink(HandledElementsCategory.LINK),
    CommandPort(HandledElementsCategory.PORT),
    ConstBlock(HandledElementsCategory.BLOCK),
    ControlPort(HandledElementsCategory.PORT),
    data(HandledElementsCategory.RAW_DATA),
    EventInBlock(HandledElementsCategory.BLOCK),
    EventOutBlock(HandledElementsCategory.BLOCK),
    ExplicitInBlock(HandledElementsCategory.BLOCK),
    ExplicitInputPort(HandledElementsCategory.PORT),
    ExplicitLink(HandledElementsCategory.LINK),
    ExplicitOutBlock(HandledElementsCategory.BLOCK),
    ExplicitOutputPort(HandledElementsCategory.PORT),
    GainBlock(HandledElementsCategory.BLOCK),
    GroundBlock(HandledElementsCategory.BLOCK),
    ImplicitInBlock(HandledElementsCategory.BLOCK),
    ImplicitInputPort(HandledElementsCategory.PORT),
    ImplicitLink(HandledElementsCategory.LINK),
    ImplicitOutBlock(HandledElementsCategory.BLOCK),
    ImplicitOutputPort(HandledElementsCategory.PORT),
    mxCell(HandledElementsCategory.JGRAPHX),
    mxGeometry(HandledElementsCategory.JGRAPHX),
    mxPoint(HandledElementsCategory.JGRAPHX),
    Orientation(HandledElementsCategory.CUSTOM),
    PrintBlock(HandledElementsCategory.BLOCK),
    Product(HandledElementsCategory.BLOCK),
    RoundBlock(HandledElementsCategory.BLOCK),
    ScilabBoolean(HandledElementsCategory.RAW_DATA),
    ScilabDouble(HandledElementsCategory.RAW_DATA),
    ScilabInteger(HandledElementsCategory.RAW_DATA),
    ScilabString(HandledElementsCategory.RAW_DATA),
    SplitBlock(HandledElementsCategory.BLOCK),
    Summation(HandledElementsCategory.BLOCK),
    SuperBlock(HandledElementsCategory.BLOCK),
    SuperBlockDiagram(HandledElementsCategory.CUSTOM),
    TextBlock(HandledElementsCategory.BLOCK),
    VoltageSensorBlock(HandledElementsCategory.BLOCK),
    XcosDiagram(HandledElementsCategory.CUSTOM);

    final HandledElementsCategory category;

    public static Map<String, HandledElement> getMap() {
        HashMap hashMap = new HashMap(HandledElement.values().length);
        Stream.of(HandledElement.values()).forEach(handledElement -> hashMap.put(handledElement.name(), handledElement));
        return Collections.unmodifiableMap(hashMap);
    }

    private HandledElement(HandledElementsCategory handledElementsCategory) {
        this.category = handledElementsCategory;
    }

    public HandledElementsCategory getCategory() {
        return this.category;
    }
}

