/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.explorer;

import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.xcos.BrowserView;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.explorer.BrowserTreeNodeData;
import org.scilab.modules.xcos.utils.XcosMessages;

public class BrowserTab
extends SwingScilabDockablePanel
implements SimpleTab {
    public static final String DEFAULT_WIN_UUID = "xcos-browser-default-window";
    public static final String DEFAULT_TAB_UUID = "xcos-browser-default-tab";
    private JTree tree;

    public BrowserTab(BrowserView browserView, String string) {
        super(XcosMessages.DIAGRAM_BROWSER, string);
        this.initComponents(browserView);
    }

    public JTree getTree() {
        return this.tree;
    }

    public static BrowserTab get() {
        return (BrowserTab)ScilabTabFactory.getInstance().getFromCache(DEFAULT_TAB_UUID);
    }

    public static void create() {
        BrowserTab browserTab = BrowserTab.allocate();
        SwingScilabWindow swingScilabWindow = WindowsConfigurationManager.createWindow((String)DEFAULT_WIN_UUID, (boolean)false);
        swingScilabWindow.addTab((SwingScilabPanel)browserTab);
        swingScilabWindow.setVisible(true);
    }

    public static BrowserTab allocate() {
        BrowserView browserView = Xcos.getInstance().getBrowser();
        BrowserTab browserTab = new BrowserTab(browserView, DEFAULT_TAB_UUID);
        ScilabTabFactory.getInstance().addToCache((SwingScilabDockablePanel)browserTab);
        ClosingOperationsManager.addDependencyWithRoot((SwingScilabDockablePanel)browserTab);
        ClosingOperationsManager.registerClosingOperation((SwingScilabDockablePanel)browserTab, (ClosingOperationsManager.ClosingOperation)new ClosingOperationsManager.ClosingOperation(){

            public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
            }

            public void destroy() {
                Xcos.getInstance().clearBrowser();
            }

            public int canClose() {
                return 1;
            }

            public String askForClosing(List<SwingScilabDockablePanel> list) {
                return null;
            }
        });
        return browserTab;
    }

    private void initComponents(BrowserView browserView) {
        this.tree = new JTree(browserView.getModel());
        this.tree.setRootVisible(false);
        JEditorPane jEditorPane = new JEditorPane("text/html", "<html><head><style type=\"text/css\">table { width: 100%; }\ncaption { text-align: center;\nfont: bold; }\ntd { text-align: left; }\n</style></head><body /></html>");
        jEditorPane.setEditable(false);
        this.tree.addTreeSelectionListener(new UpdateEditorContentListener((HTMLDocument)jEditorPane.getDocument()));
        this.tree.getModel().addTreeModelListener(new ExplorerModelListener((HTMLDocument)jEditorPane.getDocument(), this.tree));
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.tree, 20, 30), new JScrollPane(jEditorPane, 20, 30));
        this.setContentPane(jSplitPane);
        Dimension dimension = new Dimension(161, 100);
        jSplitPane.getLeftComponent().setPreferredSize(dimension);
        jSplitPane.getRightComponent().setPreferredSize(dimension);
    }

    private static class UpdateEditorContentListener
    implements TreeSelectionListener {
        final HTMLDocument doc;

        public UpdateEditorContentListener(HTMLDocument hTMLDocument) {
            this.doc = hTMLDocument;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            BrowserTreeNodeData browserTreeNodeData = (BrowserTreeNodeData)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            try {
                browserTreeNodeData.fillOrUpdateContent(this.doc);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static class ExplorerModelListener
    implements TreeModelListener {
        private final JTree tree;
        final HTMLDocument doc;

        public ExplorerModelListener(HTMLDocument hTMLDocument, JTree jTree) {
            this.tree = jTree;
            this.doc = hTMLDocument;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (this.tree.getSelectionModel().isPathSelected(treeModelEvent.getTreePath())) {
                TreePath treePath = treeModelEvent.getTreePath();
                BrowserTreeNodeData browserTreeNodeData = (BrowserTreeNodeData)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                try {
                    browserTreeNodeData.fillOrUpdateContent(this.doc);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getTreePath().getLastPathComponent() == this.tree.getModel().getRoot()) {
                this.tree.expandPath(treeModelEvent.getTreePath());
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }
}

