/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block.io;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SuperBlock;
import org.scilab.modules.xcos.block.io.EventInBlock;
import org.scilab.modules.xcos.block.io.EventOutBlock;
import org.scilab.modules.xcos.block.io.ExplicitInBlock;
import org.scilab.modules.xcos.block.io.ExplicitOutBlock;
import org.scilab.modules.xcos.block.io.ImplicitInBlock;
import org.scilab.modules.xcos.block.io.ImplicitOutBlock;
import org.scilab.modules.xcos.io.ScilabTypeCoder;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.control.ControlPort;
import org.scilab.modules.xcos.port.input.ExplicitInputPort;
import org.scilab.modules.xcos.port.input.ImplicitInputPort;
import org.scilab.modules.xcos.port.input.InputPort;
import org.scilab.modules.xcos.port.output.ExplicitOutputPort;
import org.scilab.modules.xcos.port.output.ImplicitOutputPort;
import org.scilab.modules.xcos.port.output.OutputPort;

public abstract class ContextUpdate
extends BasicBlock {
    private static final Logger LOG_LOCAL = Logger.getLogger(ContextUpdate.class.getName());
    private static final long serialVersionUID = 6076826729067963560L;
    private static final double DEFAULT_WIDTH = 20.0;
    private static final double DEFAULT_HEIGHT = 20.0;
    private transient boolean isContextDependent;

    public ContextUpdate(JavaController javaController, long l, Kind kind, Object object, mxGeometry mxGeometry2, String string, String string2) {
        super(javaController, l, kind, object, mxGeometry2, string, string2);
    }

    protected ContextUpdate(JavaController javaController, String string) {
        super(javaController, javaController.createObject(Kind.BLOCK), Kind.BLOCK, null, new mxGeometry(0.0, 0.0, 20.0, 20.0), string, new UID().toString());
        javaController.setObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, string);
    }

    public void setOrdering(JavaController javaController, int n) {
        VectorOfInt vectorOfInt = new VectorOfInt(1L);
        vectorOfInt.set(0, n);
        javaController.setObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.IPAR, vectorOfInt);
        VectorOfDouble vectorOfDouble = new ScilabTypeCoder().var2vec((ScilabType)new ScilabString(Integer.toString(n)));
        javaController.setObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.EXPRS, vectorOfDouble);
    }

    public void onContextChange(String[] stringArray) {
        if (this.isLocked()) {
            return;
        }
        if (!this.isContextDependent) {
            return;
        }
        LOG_LOCAL.finest("Update the I/O value from the context");
    }

    public static enum IOBlocks {
        EventInBlock(EventInBlock.class, ControlPort.class, CommandPort.class, ControlPort.class),
        EventOutBlock(EventOutBlock.class, CommandPort.class, ControlPort.class, CommandPort.class),
        ExplicitInBlock(ExplicitInBlock.class, ExplicitInputPort.class, ExplicitOutputPort.class, InputPort.class),
        ExplicitOutBlock(ExplicitOutBlock.class, ExplicitOutputPort.class, ExplicitInputPort.class, OutputPort.class),
        ImplicitInBlock(ImplicitInBlock.class, ImplicitInputPort.class, ImplicitOutputPort.class, InputPort.class),
        ImplicitOutBlock(ImplicitOutBlock.class, ImplicitOutputPort.class, ImplicitInputPort.class, OutputPort.class);

        private final Class<? extends ContextUpdate> ioBlock;
        private final Class<? extends BasicPort> port;
        private final Class<? extends BasicPort> opposite;
        private final Class<? extends BasicPort> assignement;

        private IOBlocks(Class<? extends ContextUpdate> clazz, Class<? extends BasicPort> clazz2, Class<? extends BasicPort> clazz3, Class<? extends BasicPort> clazz4) {
            this.ioBlock = clazz;
            this.port = clazz2;
            this.opposite = clazz3;
            this.assignement = clazz4;
        }

        public static Map<IOBlocks, List<mxICell>> getAllPorts(SuperBlock superBlock) {
            EnumMap<IOBlocks, List<mxICell>> enumMap = new EnumMap<IOBlocks, List<mxICell>>(IOBlocks.class);
            IOBlocks[] iOBlocksArray = IOBlocks.values();
            int n = iOBlocksArray.length;
            for (int i = 0; i < n; ++i) {
                IOBlocks[] iOBlocksArray2 = iOBlocksArray[i];
                enumMap.put((IOBlocks)iOBlocksArray2, new ArrayList());
            }
            int n2 = superBlock.getChildCount();
            for (n = 0; n < n2; ++n) {
                mxICell mxICell2 = superBlock.getChildAt(n);
                for (IOBlocks iOBlocks : IOBlocks.values()) {
                    if (!mxICell2.getClass().equals(iOBlocks.getReferencedPortClass())) continue;
                    enumMap.get((Object)iOBlocks).add(mxICell2);
                }
            }
            return enumMap;
        }

        public static List<mxICell> getPorts(SuperBlock superBlock, Class<? extends ContextUpdate> clazz) {
            ArrayList<mxICell> arrayList = new ArrayList<mxICell>();
            Class<? extends BasicPort> clazz2 = null;
            IOBlocks[] iOBlocksArray = IOBlocks.values();
            int n = iOBlocksArray.length;
            for (int i = 0; i < n; ++i) {
                IOBlocks iOBlocks = iOBlocksArray[i];
                if (!iOBlocks.getReferencedClass().equals(clazz)) continue;
                clazz2 = iOBlocks.getAssignementCompatiblePortClass();
                break;
            }
            int n2 = superBlock.getChildCount();
            for (n = 0; n < n2; ++n) {
                mxICell mxICell2 = superBlock.getChildAt(n);
                if (!clazz2.isInstance(mxICell2)) continue;
                arrayList.add(mxICell2);
            }
            return arrayList;
        }

        public static Class<? extends BasicPort> getOpposite(Class<? extends BasicPort> clazz) {
            for (IOBlocks iOBlocks : IOBlocks.values()) {
                if (iOBlocks.getReferencedPortClass() != clazz) continue;
                return iOBlocks.getOppositeClass();
            }
            return null;
        }

        public static Class<? extends BasicPort> getPort(Class<? extends ContextUpdate> clazz) {
            for (IOBlocks iOBlocks : IOBlocks.values()) {
                if (iOBlocks.getReferencedClass() != clazz) continue;
                return iOBlocks.getReferencedPortClass();
            }
            return null;
        }

        public static String getContextKey(Object object) {
            if (object instanceof ExplicitInBlock || object instanceof ImplicitInBlock) {
                return "in";
            }
            if (object instanceof ExplicitOutBlock || object instanceof ImplicitOutBlock) {
                return "out";
            }
            if (object instanceof EventInBlock) {
                return "ein";
            }
            if (object instanceof EventOutBlock) {
                return "eout";
            }
            return "";
        }

        public static ContextUpdate createBlock(BasicPort basicPort) {
            for (IOBlocks iOBlocks : IOBlocks.values()) {
                if (!iOBlocks.getReferencedPortClass().isInstance((Object)basicPort)) continue;
                try {
                    JavaController javaController = new JavaController();
                    Constructor<? extends ContextUpdate> constructor = iOBlocks.getReferencedClass().getConstructor(JavaController.class);
                    ContextUpdate contextUpdate = constructor.newInstance(javaController);
                    Constructor<? extends BasicPort> constructor2 = iOBlocks.getOppositeClass().getConstructor(JavaController.class, Long.TYPE, Kind.class, Object.class, String.class, String.class);
                    BasicPort basicPort2 = constructor2.newInstance(new Object[]{javaController, javaController.createObject(Kind.PORT), Kind.PORT, null, null, new UID().toString()});
                    contextUpdate.insert((mxICell)basicPort2);
                    return contextUpdate;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    Logger.getLogger(IOBlocks.class.getName()).severe(reflectiveOperationException.toString());
                }
            }
            return null;
        }

        public static BasicPort createPort(JavaController javaController, ContextUpdate contextUpdate) {
            Class<? extends BasicPort> clazz = IOBlocks.getPort(contextUpdate.getClass());
            try {
                BasicPort basicPort = clazz.getConstructor(JavaController.class, Long.TYPE, Kind.class, Object.class, String.class, String.class).newInstance(new Object[]{javaController, javaController.createObject(Kind.PORT), Kind.PORT, null, null, new UID().toString()});
                return basicPort;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                Logger.getLogger(ContextUpdate.class.getName()).log(Level.SEVERE, null, exception);
                return null;
            }
        }

        public Class<? extends ContextUpdate> getReferencedClass() {
            return this.ioBlock;
        }

        public Class<? extends BasicPort> getReferencedPortClass() {
            return this.port;
        }

        public Class<? extends BasicPort> getAssignementCompatiblePortClass() {
            return this.assignement;
        }

        public Class<? extends BasicPort> getOppositeClass() {
            return this.opposite;
        }
    }

    private static final class ExprsChangeAdapter
    implements PropertyChangeListener,
    Serializable {
        private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d+");
        private static ExprsChangeAdapter instance;

        public static ExprsChangeAdapter getInstance() {
            if (instance == null) {
                instance = new ExprsChangeAdapter();
            }
            return instance;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ScilabType scilabType = (ScilabType)propertyChangeEvent.getNewValue();
            ContextUpdate contextUpdate = (ContextUpdate)propertyChangeEvent.getSource();
            if (!scilabType.isEmpty()) {
                String string = ((ScilabString)scilabType).getData()[0][0];
                contextUpdate.isContextDependent = !INTEGER_PATTERN.matcher(string).matches();
            }
        }
    }

    private static final class IndexChangeAdapter
    implements PropertyChangeListener,
    Serializable {
        private static IndexChangeAdapter instance;

        private IndexChangeAdapter() {
        }

        public static synchronized IndexChangeAdapter getInstance() {
            if (instance == null) {
                instance = new IndexChangeAdapter();
            }
            return instance;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ScilabType scilabType = (ScilabType)propertyChangeEvent.getNewValue();
            ContextUpdate contextUpdate = (ContextUpdate)propertyChangeEvent.getSource();
            if (!scilabType.isEmpty()) {
                int n = (int)((ScilabDouble)scilabType).getRealPart()[0][0];
                if (propertyChangeEvent.getOldValue() instanceof ScilabDouble && !((ScilabDouble)propertyChangeEvent.getOldValue()).isEmpty()) {
                    int n2 = (int)((ScilabDouble)propertyChangeEvent.getOldValue()).getRealPart()[0][0];
                } else {
                    int n3 = -1;
                }
                contextUpdate.setValue(n);
            }
        }
    }
}

