/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block;

import com.mxgraph.model.mxGeometry;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.gui.contextmenu.ContextMenu;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.actions.CodeGenerationAction;
import org.scilab.modules.xcos.block.actions.SuperblockMaskCreateAction;
import org.scilab.modules.xcos.block.actions.SuperblockMaskCustomizeAction;
import org.scilab.modules.xcos.block.actions.SuperblockMaskRemoveAction;
import org.scilab.modules.xcos.utils.FileUtils;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class SuperBlock
extends BasicBlock {
    public static final String INTERFUNCTION_NAME = "SUPER_f";
    private static final String SIMULATION_NAME = "super";
    private static final String MASKED_SIMULATION_NAME = "csuper";
    public static final String MASKED_INTERFUNCTION_NAME = "DSUPER";

    public SuperBlock(JavaController javaController, long l, Kind kind, Object object, mxGeometry mxGeometry2, String string, String string2) {
        super(javaController, l, kind, object, mxGeometry2, string, string2);
        String[] stringArray = new String[]{""};
        javaController.getObjectProperty(l, kind, ObjectProperties.SIM_FUNCTION_NAME, stringArray);
        if (stringArray[0].isEmpty()) {
            javaController.setObjectProperty(l, kind, ObjectProperties.SIM_FUNCTION_NAME, SIMULATION_NAME);
        }
    }

    @Override
    public void openContextMenu(ScilabGraph scilabGraph) {
        ContextMenu contextMenu = null;
        contextMenu = this.createContextMenu(scilabGraph);
        contextMenu.getAsSimpleContextMenu().addSeparator();
        contextMenu.add(CodeGenerationAction.createMenu(scilabGraph));
        Menu menu = ScilabMenu.createMenu();
        menu.setText(XcosMessages.SUPERBLOCK_MASK);
        if (this.isMasked()) {
            menu.add(SuperblockMaskRemoveAction.createMenu(scilabGraph));
            contextMenu.add(menu);
        } else {
            menu.add(SuperblockMaskCreateAction.createMenu(scilabGraph));
        }
        menu.add(SuperblockMaskCustomizeAction.createMenu(scilabGraph));
        contextMenu.add(menu);
        contextMenu.setVisible(true);
    }

    public void mask(JavaController javaController) {
        javaController.setObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, MASKED_INTERFUNCTION_NAME);
        javaController.setObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.SIM_FUNCTION_NAME, MASKED_SIMULATION_NAME);
        VectorOfInt vectorOfInt = new VectorOfInt(1L);
        vectorOfInt.set(0, 1);
        javaController.setObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.IPAR, vectorOfInt);
    }

    public void unmask(JavaController javaController) {
        javaController.setObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, INTERFUNCTION_NAME);
        javaController.setObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.SIM_FUNCTION_NAME, SIMULATION_NAME);
    }

    public boolean isMasked() {
        JavaController javaController = new JavaController();
        String[] stringArray = new String[1];
        javaController.getObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, stringArray);
        return !INTERFUNCTION_NAME.equals(stringArray[0]);
    }

    @Override
    public void setValue(Object object) {
        if (object != null) {
            super.setValue(FileUtils.toValidCIdentifier(object.toString()));
        } else {
            super.setValue(object);
        }
    }
}

