/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import java.awt.MouseInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.CopyAction;
import org.scilab.modules.graph.actions.CutAction;
import org.scilab.modules.graph.actions.DeleteAction;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.contextmenu.ContextMenu;
import org.scilab.modules.gui.contextmenu.ScilabContextMenu;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.VectorOfString;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.actions.EditFormatAction;
import org.scilab.modules.xcos.actions.ShowHideShadowAction;
import org.scilab.modules.xcos.block.actions.AutoPositionSplitBlockAction;
import org.scilab.modules.xcos.block.actions.BlockDocumentationAction;
import org.scilab.modules.xcos.block.actions.BlockParametersAction;
import org.scilab.modules.xcos.block.actions.BorderColorAction;
import org.scilab.modules.xcos.block.actions.FilledColorAction;
import org.scilab.modules.xcos.block.actions.FlipAction;
import org.scilab.modules.xcos.block.actions.MirrorAction;
import org.scilab.modules.xcos.block.actions.RegionToSuperblockAction;
import org.scilab.modules.xcos.block.actions.RotateAction;
import org.scilab.modules.xcos.block.actions.ViewDetailsAction;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockAction;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionBottom;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionCenter;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionLeft;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionMiddle;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionRight;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionTop;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.control.ControlPort;
import org.scilab.modules.xcos.port.input.InputPort;
import org.scilab.modules.xcos.port.output.OutputPort;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.XcosMessages;

public class BasicBlock
extends XcosCell
implements Serializable {
    private static final Class<?>[] sortedChildrenClass = new Class[]{InputPort.class, OutputPort.class, ControlPort.class, CommandPort.class, Object.class};
    public static final String DEFAULT_INTERFACE_FUNCTION = "xcos_block";
    public static final String DEFAULT_SIMULATION_FUNCTION = "xcos_simulate";
    protected static final double DEFAULT_POSITION_X = 10.0;
    protected static final double DEFAULT_POSITION_Y = 10.0;
    private static final double DEFAULT_WIDTH = 40.0;
    private static final double DEFAULT_HEIGHT = 40.0;
    private boolean locked;

    private static int compareByChildClass(Object object, Object object2) {
        Class<?> clazz;
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < sortedChildrenClass.length; ++n) {
            clazz = sortedChildrenClass[n];
            if (!clazz.isInstance(object)) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < sortedChildrenClass.length; ++n) {
            clazz = sortedChildrenClass[n];
            if (!clazz.isInstance(object2)) continue;
            n3 = n;
            break;
        }
        n = n2 - n3;
        return n * (Integer.MAX_VALUE / sortedChildrenClass.length);
    }

    public void updateBlockView() {
    }

    public BasicBlock(JavaController javaController, long l, Kind kind, Object object, mxGeometry mxGeometry2, String string, String string2) {
        super(javaController, l, kind, object, mxGeometry2, string, string2);
        this.visible = true;
        this.vertex = true;
        this.connectable = false;
    }

    public synchronized boolean isLocked() {
        return this.locked;
    }

    public synchronized void setLocked(boolean bl) {
        this.locked = bl;
    }

    public void updateBlockSettings(JavaController javaController, XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        if (basicBlock == null) {
            return;
        }
        this.updateFields(javaController, xcosDiagram, basicBlock);
        this.updateChildren(javaController, xcosDiagram, basicBlock);
    }

    protected void updateFields(JavaController javaController, XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        if (basicBlock == null) {
            return;
        }
        TreeMap<ObjectProperties, Object> treeMap = new TreeMap<ObjectProperties, Object>();
        int[] nArray = new int[1];
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_FUNCTION_API, nArray);
        treeMap.put(ObjectProperties.SIM_FUNCTION_API, nArray);
        String[] stringArray = new String[1];
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.INTERFACE_FUNCTION, stringArray);
        treeMap.put(ObjectProperties.INTERFACE_FUNCTION, stringArray);
        stringArray = new String[1];
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_FUNCTION_NAME, stringArray);
        treeMap.put(ObjectProperties.SIM_FUNCTION_NAME, stringArray);
        stringArray = new String[1];
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_BLOCKTYPE, stringArray);
        treeMap.put(ObjectProperties.SIM_BLOCKTYPE, stringArray);
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.EXPRS, vectorOfDouble);
        treeMap.put(ObjectProperties.EXPRS, vectorOfDouble);
        vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.STATE, vectorOfDouble);
        treeMap.put(ObjectProperties.STATE, vectorOfDouble);
        vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.DSTATE, vectorOfDouble);
        treeMap.put(ObjectProperties.DSTATE, vectorOfDouble);
        vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.ODSTATE, vectorOfDouble);
        treeMap.put(ObjectProperties.ODSTATE, vectorOfDouble);
        vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.RPAR, vectorOfDouble);
        treeMap.put(ObjectProperties.RPAR, vectorOfDouble);
        vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.OPAR, vectorOfDouble);
        treeMap.put(ObjectProperties.OPAR, vectorOfDouble);
        vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.EQUATIONS, vectorOfDouble);
        treeMap.put(ObjectProperties.EQUATIONS, vectorOfDouble);
        VectorOfInt vectorOfInt = new VectorOfInt();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_DEP_UT, vectorOfInt);
        treeMap.put(ObjectProperties.SIM_DEP_UT, vectorOfInt);
        vectorOfInt = new VectorOfInt();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.NZCROSS, vectorOfInt);
        treeMap.put(ObjectProperties.NZCROSS, vectorOfInt);
        vectorOfInt = new VectorOfInt();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.NMODE, vectorOfInt);
        treeMap.put(ObjectProperties.NMODE, vectorOfInt);
        vectorOfInt = new VectorOfInt();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.IPAR, vectorOfInt);
        treeMap.put(ObjectProperties.IPAR, vectorOfInt);
        vectorOfInt = new VectorOfInt();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.COLOR, vectorOfInt);
        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.COLOR, vectorOfInt);
        treeMap.put(ObjectProperties.COLOR, vectorOfInt);
        VectorOfString vectorOfString = new VectorOfString();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.DIAGRAM_CONTEXT, vectorOfString);
        treeMap.put(ObjectProperties.DIAGRAM_CONTEXT, vectorOfString);
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
        treeMap.put(ObjectProperties.CHILDREN, vectorOfScicosID);
        xcosDiagram.updateBlock(this, treeMap);
        this.updateStyle(javaController, xcosDiagram, basicBlock);
        this.updateValue(javaController, xcosDiagram, basicBlock);
    }

    protected void updateStyle(JavaController javaController, XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        StyleMap styleMap = new StyleMap(this.getStyle());
        styleMap.putAll(basicBlock.getStyle());
        xcosDiagram.getModel().setStyle((Object)this, this.style.toString());
    }

    protected void updateValue(JavaController javaController, XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        xcosDiagram.getModel().setValue((Object)this, basicBlock.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateChildren(JavaController javaController, XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        if (basicBlock == null) {
            return;
        }
        HashSet<Class<? extends mxICell>> hashSet = new HashSet<Class<? extends mxICell>>(Arrays.asList(InputPort.class, OutputPort.class, ControlPort.class, CommandPort.class));
        Map<Class<? extends mxICell>, Deque<mxICell>> map = this.getTypedChildren(hashSet);
        Map<Class<? extends mxICell>, Deque<mxICell>> map2 = basicBlock.getTypedChildren(hashSet);
        xcosDiagram.getModel().beginUpdate();
        try {
            for (Class clazz : hashSet) {
                Deque<mxICell> deque = map.get(clazz);
                Deque<mxICell> deque2 = map2.get(clazz);
                while (!deque.isEmpty() && !deque2.isEmpty()) {
                    mxICell mxICell2 = deque.poll();
                    mxICell mxICell3 = deque2.poll();
                    int n = this.children.indexOf(mxICell2);
                    if (mxICell2.getEdgeCount() != 0) {
                        mxICell mxICell4 = mxICell2.getEdgeAt(0);
                        boolean bl = mxICell2 == mxICell4.getTerminal(true);
                        xcosDiagram.getModel().setTerminal((Object)mxICell4, (Object)mxICell3, bl);
                    }
                    xcosDiagram.removeCells(new Object[]{mxICell2}, false);
                    xcosDiagram.addCells(new Object[]{mxICell3}, this, n);
                    xcosDiagram.getModel().setGeometry((Object)mxICell3, (mxGeometry)mxICell2.getGeometry().clone());
                }
                if (!deque.isEmpty()) {
                    xcosDiagram.removeCells(deque.toArray(), true);
                }
                if (deque2.isEmpty()) continue;
                xcosDiagram.addCells(deque2.toArray(), this);
            }
        }
        finally {
            xcosDiagram.getModel().endUpdate();
        }
    }

    private Map<Class<? extends mxICell>, Deque<mxICell>> getTypedChildren(Set<Class<? extends mxICell>> set) {
        HashMap<Class<? extends mxICell>, Deque<mxICell>> hashMap = new HashMap<Class<? extends mxICell>, Deque<mxICell>>();
        for (Class<? extends mxICell> clazz : set) {
            hashMap.put(clazz, new LinkedList());
        }
        if (this.getChildCount() <= 0) {
            return hashMap;
        }
        for (Class<Object> clazz : this.children) {
            Class<?> clazz2;
            for (clazz2 = clazz.getClass(); clazz2 != null && !set.contains(clazz2); clazz2 = clazz2.getSuperclass()) {
            }
            Deque deque = (Deque)hashMap.get(clazz2);
            if (deque == null) continue;
            deque.add((mxICell)clazz);
        }
        return hashMap;
    }

    private Map<Class<? extends mxICell>, ArrayList<Integer>> getTypedChildrenIndexes(Set<Class<? extends mxICell>> set) {
        HashMap<Class<? extends mxICell>, ArrayList<Integer>> hashMap = new HashMap<Class<? extends mxICell>, ArrayList<Integer>>();
        for (Class<? extends mxICell> clazz2 : set) {
            hashMap.put(clazz2, new ArrayList());
        }
        if (this.getChildCount() <= 0) {
            return hashMap;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Class<?> clazz;
            Object e = this.children.get(i);
            for (clazz = e.getClass(); clazz != null && !set.contains(clazz); clazz = clazz.getSuperclass()) {
            }
            ArrayList arrayList = (ArrayList)hashMap.get(clazz);
            if (arrayList == null) continue;
            arrayList.add(i);
        }
        return hashMap;
    }

    public ArrayList<Integer> getTypedChildrenIndexes(Class<? extends mxICell> clazz) {
        return this.getTypedChildrenIndexes(Collections.singleton(clazz)).get(clazz);
    }

    public Map<Class<? extends mxICell>, ArrayList<Long>> getTypedChildrenUIDs(Set<Class<? extends mxICell>> set) {
        HashMap<Class<? extends mxICell>, ArrayList<Long>> hashMap = new HashMap<Class<? extends mxICell>, ArrayList<Long>>();
        set.stream().forEach(clazz -> hashMap.put((Class<? extends mxICell>)clazz, new ArrayList()));
        if (this.getChildCount() <= 0) {
            return hashMap;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Class<?> clazz2;
            Object e = this.children.get(i);
            for (clazz2 = e.getClass(); clazz2 != null && !set.contains(clazz2); clazz2 = clazz2.getSuperclass()) {
            }
            ArrayList arrayList = (ArrayList)hashMap.get(clazz2);
            if (arrayList == null) continue;
            if (e instanceof XcosCell) {
                arrayList.add(((XcosCell)((Object)e)).getUID());
                continue;
            }
            arrayList.add(0L);
        }
        return hashMap;
    }

    public ArrayList<Long> getTypedChildrenUIDs(Class<? extends mxICell> clazz) {
        return this.getTypedChildrenUIDs(Collections.singleton(clazz)).get(clazz);
    }

    public void openContextMenu(ScilabGraph scilabGraph) {
        ContextMenu contextMenu = null;
        contextMenu = this.createContextMenu(scilabGraph);
        contextMenu.setVisible(true);
    }

    public ContextMenu createPaletteContextMenu(ScilabGraph scilabGraph) {
        MenuItem menuItem;
        ContextMenu contextMenu = ScilabContextMenu.createContextMenu();
        List<XcosDiagram> list = Xcos.getInstance().openedDiagrams();
        if (list.size() == 0) {
            menuItem = ScilabMenuItem.createMenuItem();
            menuItem.setText(XcosMessages.ADDTO_NEW_DIAGRAM);
            menuItem.setCallback(new CommonCallBack(XcosMessages.ADDTO_NEW_DIAGRAM){

                public void callBack() {
                    JavaController javaController = new JavaController();
                    BasicBlock basicBlock = null;
                    try {
                        basicBlock = (BasicBlock)BasicBlock.this.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                    XcosDiagram xcosDiagram = new XcosDiagram(javaController, javaController.createObject(Kind.DIAGRAM), Kind.DIAGRAM, "");
                    xcosDiagram.getModel().add(xcosDiagram.getDefaultParent(), (Object)basicBlock, 0);
                    mxGeometry mxGeometry2 = BasicBlock.this.getGeometry();
                    BasicBlock.this.setDefaultPosition(mxGeometry2);
                    xcosDiagram.getModel().setGeometry((Object)basicBlock, mxGeometry2);
                    XcosTab.get(xcosDiagram).setVisible(true);
                    BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
                }
            });
            contextMenu.add(menuItem);
        } else if (list.size() == 1) {
            menuItem = ScilabMenuItem.createMenuItem();
            menuItem.setText(XcosMessages.ADDTO + " " + XcosTab.get(list.get(0)).getName());
            final XcosDiagram xcosDiagram = list.get(0);
            menuItem.setCallback(new CommonCallBack(xcosDiagram.getTitle()){
                private static final long serialVersionUID = -99601763227525686L;

                public void callBack() {
                    BasicBlock basicBlock = null;
                    try {
                        basicBlock = (BasicBlock)BasicBlock.this.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                    xcosDiagram.getModel().add(xcosDiagram.getDefaultParent(), (Object)basicBlock, 0);
                    mxGeometry mxGeometry2 = BasicBlock.this.getGeometry();
                    BasicBlock.this.setDefaultPosition(mxGeometry2);
                    xcosDiagram.getModel().setGeometry((Object)basicBlock, mxGeometry2);
                    BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
                }
            });
            contextMenu.add(menuItem);
        } else {
            menuItem = ScilabMenu.createMenu();
            menuItem.setText(XcosMessages.ADDTO);
            for (int i = 0; i < list.size(); ++i) {
                MenuItem menuItem2 = ScilabMenuItem.createMenuItem();
                final XcosDiagram xcosDiagram = list.get(i);
                menuItem2.setText(XcosTab.get(list.get(i)).getName());
                menuItem2.setCallback(new CommonCallBack(xcosDiagram.getTitle()){
                    private static final long serialVersionUID = 3345416658377835057L;

                    public void callBack() {
                        BasicBlock basicBlock = null;
                        try {
                            basicBlock = (BasicBlock)BasicBlock.this.clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            cloneNotSupportedException.printStackTrace();
                        }
                        xcosDiagram.getModel().add(xcosDiagram.getDefaultParent(), (Object)basicBlock, 0);
                        mxGeometry mxGeometry2 = BasicBlock.this.getGeometry();
                        BasicBlock.this.setDefaultPosition(mxGeometry2);
                        xcosDiagram.getModel().setGeometry((Object)basicBlock, mxGeometry2);
                        BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
                    }
                });
                menuItem.add(menuItem2);
            }
            contextMenu.add((Menu)menuItem);
        }
        contextMenu.getAsSimpleContextMenu().addSeparator();
        menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setText(XcosMessages.BLOCK_DOCUMENTATION);
        menuItem.setCallback(new CommonCallBack(XcosMessages.BLOCK_DOCUMENTATION){
            private static final long serialVersionUID = -1480947262397441951L;

            public void callBack() {
                JavaController javaController = new JavaController();
                String[] stringArray = new String[1];
                javaController.getObjectProperty(BasicBlock.this.getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, stringArray);
                InterpreterManagement.requestScilabExec((String)("help " + stringArray[0]));
            }
        });
        contextMenu.add(menuItem);
        contextMenu.setVisible(true);
        ((SwingScilabContextMenu)contextMenu.getAsSimpleContextMenu()).setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        return contextMenu;
    }

    public ContextMenu createContextMenu(ScilabGraph scilabGraph) {
        ContextMenu contextMenu = ScilabContextMenu.createContextMenu();
        HashMap<Class<? extends DefaultAction>, Menu> hashMap = new HashMap<Class<? extends DefaultAction>, Menu>();
        MenuItem menuItem = BlockParametersAction.createMenu(scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)BlockParametersAction.class, (Menu)menuItem);
        contextMenu.add(menuItem);
        contextMenu.getAsSimpleContextMenu().addSeparator();
        menuItem = CutAction.cutMenu((ScilabGraph)scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)CutAction.class, (Menu)menuItem);
        contextMenu.add(menuItem);
        menuItem = CopyAction.copyMenu((ScilabGraph)scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)CopyAction.class, (Menu)menuItem);
        contextMenu.add(menuItem);
        menuItem = DeleteAction.createMenu((ScilabGraph)scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)DeleteAction.class, (Menu)menuItem);
        contextMenu.add(menuItem);
        contextMenu.getAsSimpleContextMenu().addSeparator();
        menuItem = RegionToSuperblockAction.createMenu(scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)RegionToSuperblockAction.class, (Menu)menuItem);
        contextMenu.add(menuItem);
        contextMenu.getAsSimpleContextMenu().addSeparator();
        Menu menu = ScilabMenu.createMenu();
        menu.setText(XcosMessages.FORMAT);
        contextMenu.add(menu);
        menuItem = RotateAction.createMenu(scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)RotateAction.class, (Menu)menuItem);
        menu.add(menuItem);
        menuItem = MirrorAction.createMenu(scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)MirrorAction.class, (Menu)menuItem);
        menu.add(menuItem);
        menuItem = FlipAction.createMenu(scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)FlipAction.class, (Menu)menuItem);
        menu.add(menuItem);
        menuItem = ShowHideShadowAction.createMenu(scilabGraph);
        hashMap.put((Class<? extends DefaultAction>)ShowHideShadowAction.class, (Menu)menuItem);
        menu.add(menuItem);
        menu.addSeparator();
        Menu menu2 = ScilabMenu.createMenu();
        menu2.setText(XcosMessages.ALIGN_BLOCKS);
        menu2.add(AlignBlockActionLeft.createMenu(scilabGraph));
        menu2.add(AlignBlockActionCenter.createMenu(scilabGraph));
        menu2.add(AlignBlockActionRight.createMenu(scilabGraph));
        menu2.addSeparator();
        menu2.add(AlignBlockActionTop.createMenu(scilabGraph));
        menu2.add(AlignBlockActionMiddle.createMenu(scilabGraph));
        menu2.add(AlignBlockActionBottom.createMenu(scilabGraph));
        hashMap.put(AlignBlockAction.class, menu2);
        menu.add(menu2);
        menu.addSeparator();
        MenuItem menuItem2 = AutoPositionSplitBlockAction.createMenu(scilabGraph);
        menuItem2.setText(XcosMessages.BLOCK_AUTO_POSITION_SPLIT_BLOCK_CONTEXTUAL);
        menuItem2.setEnabled(false);
        hashMap.put((Class<? extends DefaultAction>)AutoPositionSplitBlockAction.class, (Menu)menuItem2);
        menu.add(menuItem2);
        menu.addSeparator();
        if (scilabGraph.getSelectionCells().length > 1) {
            menu.add(BorderColorAction.createMenu(scilabGraph));
            menu.add(FilledColorAction.createMenu(scilabGraph));
        } else {
            menu.add(EditFormatAction.createMenu(scilabGraph));
        }
        contextMenu.getAsSimpleContextMenu().addSeparator();
        contextMenu.add(ViewDetailsAction.createMenu(scilabGraph));
        contextMenu.getAsSimpleContextMenu().addSeparator();
        contextMenu.add(BlockDocumentationAction.createMenu(scilabGraph));
        ((SwingScilabContextMenu)contextMenu.getAsSimpleContextMenu()).setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        this.customizeMenu(hashMap);
        return contextMenu;
    }

    protected void customizeMenu(Map<Class<? extends DefaultAction>, Menu> map) {
    }

    private void setDefaultPosition(mxGeometry mxGeometry2) {
        mxGeometry2.setX(10.0);
        mxGeometry2.setY(10.0);
    }

    public boolean isConnectable() {
        return false;
    }

    public static enum SimulationFunctionType {
        ESELECT(-2),
        IFTHENELSE(-1),
        DEFAULT(0),
        TYPE_1(1),
        TYPE_2(2),
        TYPE_3(3),
        C_OR_FORTRAN(4),
        SCILAB(5),
        DEBUG(99),
        DYNAMIC_FORTRAN_1(1001),
        DYNAMIC_C_1(2001),
        DYNAMIC_EXPLICIT_4(2004),
        OLDBLOCKS(10001),
        IMPLICIT_C_OR_FORTRAN(10004),
        DYNAMIC_IMPLICIT_4(12004),
        MODELICA(30004),
        UNKNOWN(5);

        private final int value;

        private SimulationFunctionType(int n2) {
            this.value = n2;
        }

        public static SimulationFunctionType convertScilabValue(int n) {
            for (SimulationFunctionType simulationFunctionType : SimulationFunctionType.values()) {
                if (simulationFunctionType.getValue() != n) continue;
                return simulationFunctionType;
            }
            return UNKNOWN;
        }

        public int getValue() {
            return this.value;
        }
    }
}

