/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.actions.SetupAction;
import org.scilab.modules.xcos.actions.dialog.SetContextDialog;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;

public class SetupDialog
extends JDialog {
    private static final DecimalFormatSymbols FORMAT_SYMBOL = DecimalFormatSymbols.getInstance();
    private static final DecimalFormat CURRENT_FORMAT = new DecimalFormat("0.0####E00", FORMAT_SYMBOL);
    private static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final SolverDescriptor[] AVAILABLE_SOLVERS = new SolverDescriptor[]{new SolverDescriptor(0, "LSodar", "Method: dynamic, Nonlinear solver= dynamic", EnumSet.allOf(SolverModifiers.class)), new SolverDescriptor(1, "Sundials/CVODE - BDF - NEWTON", "Method: BDF, Nonlinear solver= NEWTON", EnumSet.allOf(SolverModifiers.class)), new SolverDescriptor(2, "Sundials/CVODE - BDF - FUNCTIONAL", "Method: BDF, Nonlinear solver= FUNCTIONAL", EnumSet.allOf(SolverModifiers.class)), new SolverDescriptor(3, "Sundials/CVODE - ADAMS - NEWTON", "Method: ADAMS, Nonlinear solver= NEWTON", EnumSet.allOf(SolverModifiers.class)), new SolverDescriptor(4, "Sundials/CVODE - ADAMS - FUNCTIONAL", "Method: ADAMS, Nonlinear solver= FUNCTIONAL", EnumSet.allOf(SolverModifiers.class)), new SolverDescriptor(5, "DOPRI5 - Dormand-Prince 4(5)", "Method: Fixed step", EnumSet.of(SolverModifiers.MAX_STEP_SIZE)), new SolverDescriptor(6, "RK45 - Runge-Kutta 4(5)", "Method: Fixed step", EnumSet.of(SolverModifiers.MAX_STEP_SIZE)), new SolverDescriptor(7, "Implicit RK45 - Implicit Runge-Kutta 4(5)", "Method: Fixed step, Nonlinear solver= FIXED-POINT", EnumSet.of(SolverModifiers.MAX_STEP_SIZE, SolverModifiers.RELATIVE_TOLERANCE)), new SolverDescriptor(8, "CRANI - Crank-Nicolson 2(3)", "Method: Fixed step, Nonlinear solver= FIXED-POINT", EnumSet.of(SolverModifiers.MAX_STEP_SIZE, SolverModifiers.RELATIVE_TOLERANCE)), new SolverDescriptor(100, "Sundials/IDA", "Method: BDF, Nonlinear solver= NEWTON", EnumSet.allOf(SolverModifiers.class)), new SolverDescriptor(101, "DDaskr - Newton", "Method: BDF, Nonlinear solver= NEWTON", EnumSet.allOf(SolverModifiers.class)), new SolverDescriptor(102, "DDaskr - GMRes", "Method: BDF, Nonlinear solver= GMRES", EnumSet.allOf(SolverModifiers.class))};
    private static final InputVerifier VALIDATE_POSITIVE_DOUBLE = new InputVerifier(){

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = false;
            JFormattedTextField jFormattedTextField = (JFormattedTextField)jComponent;
            try {
                BigDecimal bigDecimal = new BigDecimal(jFormattedTextField.getText());
                if (bigDecimal.compareTo(BigDecimal.ZERO) >= 0 && bigDecimal.compareTo(MAX_DOUBLE) <= 0) {
                    bl = true;
                }
                jFormattedTextField.setValue(bigDecimal);
            }
            catch (NumberFormatException numberFormatException) {
                return bl;
            }
            return bl;
        }
    };
    private final ScicosParameters parameters;
    private final XcosDiagram currentGraph;
    private JFormattedTextField integration;
    private JFormattedTextField rts;
    private JFormattedTextField integrator;
    private JFormattedTextField integratorRel;
    private JFormattedTextField toleranceOnTime;
    private JFormattedTextField maxIntegrationTime;
    private JComboBox<SolverDescriptor> solver;
    private JFormattedTextField maxStepSize;

    public SetupDialog(Component component, XcosDiagram xcosDiagram, ScicosParameters scicosParameters) {
        this.parameters = scicosParameters;
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"scilab"));
        Image image = imageIcon.getImage();
        this.setLayout(new GridBagLayout());
        this.setIconImage(image);
        this.setTitle(XcosMessages.SETUP_TITLE);
        this.setModal(false);
        this.setLocationRelativeTo(component);
        this.currentGraph = xcosDiagram;
        this.setDefaultCloseOperation(2);
        ScilabSwingUtilities.closeOnEscape((Window)this);
        this.initComponents();
    }

    private void initComponents() {
        JavaController javaController = new JavaController();
        JLabel jLabel = new JLabel(XcosMessages.FINAL_INTEGRATION_TIME);
        this.integration = new JFormattedTextField(CURRENT_FORMAT);
        this.integration.setInputVerifier(VALIDATE_POSITIVE_DOUBLE);
        this.integration.setValue(new BigDecimal(this.parameters.getProperties(javaController).get(0)));
        JLabel jLabel2 = new JLabel(XcosMessages.REAL_TIME_SCALING);
        this.rts = new JFormattedTextField(CURRENT_FORMAT);
        this.rts.setInputVerifier(VALIDATE_POSITIVE_DOUBLE);
        this.rts.setValue(new BigDecimal(this.parameters.getProperties(javaController).get(5)));
        JLabel jLabel3 = new JLabel(XcosMessages.INTEGRATOR_ABSOLUTE_TOLERANCE);
        this.integrator = new JFormattedTextField(CURRENT_FORMAT);
        this.integrator.setInputVerifier(VALIDATE_POSITIVE_DOUBLE);
        this.integrator.setValue(new BigDecimal(this.parameters.getProperties(javaController).get(1)));
        JLabel jLabel4 = new JLabel(XcosMessages.INTEGRATOR_RELATIVE_TOLERANCE);
        this.integratorRel = new JFormattedTextField(CURRENT_FORMAT);
        this.integratorRel.setInputVerifier(VALIDATE_POSITIVE_DOUBLE);
        this.integratorRel.setValue(new BigDecimal(this.parameters.getProperties(javaController).get(2)));
        JLabel jLabel5 = new JLabel(XcosMessages.TOLERANCE_ON_TIME);
        this.toleranceOnTime = new JFormattedTextField(CURRENT_FORMAT);
        this.toleranceOnTime.setInputVerifier(VALIDATE_POSITIVE_DOUBLE);
        this.toleranceOnTime.setValue(new BigDecimal(this.parameters.getProperties(javaController).get(3)));
        JLabel jLabel6 = new JLabel(XcosMessages.MAX_INTEGRATION_TIME_INTERVAL);
        this.maxIntegrationTime = new JFormattedTextField(CURRENT_FORMAT);
        this.maxIntegrationTime.setInputVerifier(VALIDATE_POSITIVE_DOUBLE);
        this.maxIntegrationTime.setValue(new BigDecimal(this.parameters.getProperties(javaController).get(4)));
        JLabel jLabel7 = new JLabel(XcosMessages.SOLVER_CHOICE);
        this.solver = new JComboBox<SolverDescriptor>(AVAILABLE_SOLVERS);
        double d = this.parameters.getProperties(javaController).get(6);
        int n = Arrays.binarySearch(AVAILABLE_SOLVERS, new SolverDescriptor(d));
        SolverDescriptor solverDescriptor = AVAILABLE_SOLVERS[n];
        this.solver.setSelectedIndex(n);
        final class ComboboxToolTipRenderer
        extends DefaultListCellRenderer {
            ComboboxToolTipRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (-1 < n && null != object) {
                    jList.setToolTipText(AVAILABLE_SOLVERS[n].getToolTip());
                }
                return jComponent;
            }
        }
        this.solver.setRenderer(new ComboboxToolTipRenderer());
        this.solver.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SolverDescriptor solverDescriptor = (SolverDescriptor)itemEvent.getItem();
                solverDescriptor.applyModifiers(SetupDialog.this.integrator, SetupDialog.this.integratorRel, SetupDialog.this.toleranceOnTime, SetupDialog.this.maxIntegrationTime, SetupDialog.this.maxStepSize);
            }
        });
        JLabel jLabel8 = new JLabel(XcosMessages.MAXIMUN_STEP_SIZE);
        this.maxStepSize = new JFormattedTextField(CURRENT_FORMAT);
        this.maxStepSize.setInputVerifier(VALIDATE_POSITIVE_DOUBLE);
        this.maxStepSize.setValue(new BigDecimal(this.parameters.getProperties(javaController).get(7)));
        JButton jButton = new JButton(XcosMessages.CANCEL);
        JButton jButton2 = new JButton(XcosMessages.OK);
        JButton jButton3 = new JButton(XcosMessages.DEFAULT);
        JButton jButton4 = new JButton(XcosMessages.SET_CONTEXT);
        jButton2.setPreferredSize(jButton.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        this.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        this.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        this.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        this.add((Component)jButton4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.integration, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.add((Component)this.rts, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.add((Component)this.integrator, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.add((Component)this.integratorRel, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        this.add((Component)this.toleranceOnTime, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        this.add((Component)this.maxIntegrationTime, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        this.add(this.solver, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        this.add((Component)this.maxStepSize, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 5);
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 10);
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 10);
        this.add((Component)jButton3, gridBagConstraints);
        this.installActionListeners(jButton, jButton2, jButton3, jButton4);
        solverDescriptor.applyModifiers(this.integrator, this.integratorRel, this.toleranceOnTime, this.maxIntegrationTime, this.maxStepSize);
        this.getRootPane().setDefaultButton(jButton2);
    }

    private void installActionListeners(JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetupDialog.this.dispose();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetupDialog.this.integration.setValue(new BigDecimal(ScicosParameters.DEFAULT_PARAMETERS.get(0)));
                SetupDialog.this.integrator.setValue(new BigDecimal(ScicosParameters.DEFAULT_PARAMETERS.get(1)));
                SetupDialog.this.integratorRel.setValue(new BigDecimal(ScicosParameters.DEFAULT_PARAMETERS.get(2)));
                SetupDialog.this.toleranceOnTime.setValue(new BigDecimal(ScicosParameters.DEFAULT_PARAMETERS.get(3)));
                SetupDialog.this.maxIntegrationTime.setValue(new BigDecimal(ScicosParameters.DEFAULT_PARAMETERS.get(4)));
                SetupDialog.this.maxStepSize.setValue(new BigDecimal(ScicosParameters.DEFAULT_PARAMETERS.get(7)));
                SetupDialog.this.rts.setValue(new BigDecimal(ScicosParameters.DEFAULT_PARAMETERS.get(5)));
                SetupDialog.this.solver.setSelectedIndex((int)ScicosParameters.DEFAULT_PARAMETERS.get(6));
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = SetupDialog.this.solver.getSelectedIndex();
                    VectorOfDouble vectorOfDouble = new VectorOfDouble(8L);
                    vectorOfDouble.set(0, ((BigDecimal)SetupDialog.this.integration.getValue()).doubleValue());
                    vectorOfDouble.set(1, ((BigDecimal)SetupDialog.this.integrator.getValue()).doubleValue());
                    vectorOfDouble.set(2, ((BigDecimal)SetupDialog.this.integratorRel.getValue()).doubleValue());
                    vectorOfDouble.set(3, ((BigDecimal)SetupDialog.this.toleranceOnTime.getValue()).doubleValue());
                    vectorOfDouble.set(4, ((BigDecimal)SetupDialog.this.maxIntegrationTime.getValue()).doubleValue());
                    vectorOfDouble.set(5, ((BigDecimal)SetupDialog.this.rts.getValue()).doubleValue());
                    vectorOfDouble.set(6, AVAILABLE_SOLVERS[n].getNumber());
                    vectorOfDouble.set(7, ((BigDecimal)SetupDialog.this.maxStepSize.getValue()).doubleValue());
                    SetupDialog.this.parameters.setProperties(new JavaController(), vectorOfDouble);
                    SetupDialog.this.dispose();
                }
                catch (PropertyVetoException propertyVetoException) {
                    Logger.getLogger(SetupAction.class.getName()).severe(propertyVetoException.toString());
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetContextDialog setContextDialog = new SetContextDialog((Component)SetupDialog.this, SetupDialog.this.currentGraph, SetupDialog.this.parameters);
                setContextDialog.pack();
                setContextDialog.setVisible(true);
            }
        });
    }

    static {
        FORMAT_SYMBOL.setDecimalSeparator('.');
        CURRENT_FORMAT.setDecimalFormatSymbols(FORMAT_SYMBOL);
        CURRENT_FORMAT.setParseIntegerOnly(false);
        CURRENT_FORMAT.setParseBigDecimal(true);
        Arrays.sort(AVAILABLE_SOLVERS);
    }

    protected static class SolverDescriptor
    implements Comparable<SolverDescriptor> {
        private final int number;
        private final String name;
        private final String tooltip;
        private final EnumSet<SolverModifiers> modifiers;

        public SolverDescriptor(int n, String string, String string2, EnumSet<SolverModifiers> enumSet) {
            this.number = n;
            this.name = string;
            this.tooltip = string2;
            this.modifiers = enumSet;
        }

        public SolverDescriptor(double d) {
            this.number = (int)d;
            this.name = null;
            this.tooltip = null;
            this.modifiers = null;
        }

        public int getNumber() {
            return this.number;
        }

        public String getToolTip() {
            return this.tooltip;
        }

        public String toString() {
            return this.name;
        }

        public void applyModifiers(JFormattedTextField jFormattedTextField, JFormattedTextField jFormattedTextField2, JFormattedTextField jFormattedTextField3, JFormattedTextField jFormattedTextField4, JFormattedTextField jFormattedTextField5) {
            jFormattedTextField.setEnabled(this.modifiers.contains((Object)SolverModifiers.ABSOLUTE_TOLERANCE));
            jFormattedTextField2.setEnabled(this.modifiers.contains((Object)SolverModifiers.RELATIVE_TOLERANCE));
            jFormattedTextField3.setEnabled(this.modifiers.contains((Object)SolverModifiers.TOLERANCE_ON_TIME));
            jFormattedTextField4.setEnabled(this.modifiers.contains((Object)SolverModifiers.MAX_INTEGRATION_TIME));
            jFormattedTextField5.setEnabled(this.modifiers.contains((Object)SolverModifiers.MAX_STEP_SIZE));
        }

        @Override
        public int compareTo(SolverDescriptor solverDescriptor) {
            return this.number < solverDescriptor.number ? -1 : (this.number == solverDescriptor.number ? 0 : 1);
        }
    }

    private static enum SolverModifiers {
        ABSOLUTE_TOLERANCE,
        RELATIVE_TOLERANCE,
        TOLERANCE_ON_TIME,
        MAX_INTEGRATION_TIME,
        MAX_STEP_SIZE;

    }
}

