/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos;

import com.mxgraph.swing.mxGraphOutline;
import java.awt.Component;
import java.awt.Container;
import java.net.MalformedURLException;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.flexdock.docking.activation.ActiveDockableTracker;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class ViewPortTab
extends SwingScilabDockablePanel {
    public static final String DEFAULT_WIN_UUID = "xcos-viewport-default-window";

    private ViewPortTab(XcosDiagram xcosDiagram, String string) {
        super(XcosMessages.VIEWPORT, string);
        xcosDiagram.setViewPortTab(string);
        this.setWindowIcon(Xcos.ICON.getImage());
        this.initComponents(xcosDiagram);
    }

    public static void restore(XcosDiagram xcosDiagram) {
        Optional<String> optional = ViewPortTab.resolveTabUUID(xcosDiagram);
        xcosDiagram.setViewPortTab(optional.orElse(UUID.randomUUID().toString()));
        ConfigurationManager.getInstance().addToRecentTabs(xcosDiagram);
        boolean bl = false;
        if (optional.isPresent()) {
            bl = WindowsConfigurationManager.restoreUUID((String)xcosDiagram.getViewPortTab());
        }
        if (!bl) {
            ViewPortTab.create(xcosDiagram);
        }
    }

    public static ViewPortTab get(XcosDiagram xcosDiagram) {
        String string = xcosDiagram.getViewPortTab();
        return (ViewPortTab)ScilabTabFactory.getInstance().getFromCache(string);
    }

    private static void create(XcosDiagram xcosDiagram) {
        ViewPortTab viewPortTab = ViewPortTab.allocate(xcosDiagram);
        SwingScilabWindow swingScilabWindow = WindowsConfigurationManager.createWindow((String)DEFAULT_WIN_UUID, (boolean)false);
        swingScilabWindow.addTab((SwingScilabPanel)viewPortTab);
        swingScilabWindow.setVisible(true);
        ActiveDockableTracker.requestDockableActivation((Component)((Object)viewPortTab));
    }

    private static Optional<String> resolveTabUUID(XcosDiagram xcosDiagram) {
        String string;
        Object object;
        String string2 = xcosDiagram.getViewPortTab();
        if (string2 != null) {
            return Optional.of(string2);
        }
        if (xcosDiagram.getSavedFile() != null) {
            try {
                object = xcosDiagram.getSavedFile().toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                object = null;
            }
            string = object;
        } else {
            string = null;
        }
        object = ConfigurationManager.getInstance().streamTab().filter(documentType -> Objects.equals(string, documentType.getUrl())).filter(documentType -> documentType.getUuid() == xcosDiagram.getGraphTab()).map(documentType -> documentType.getViewport()).findFirst();
        return object;
    }

    protected static ViewPortTab allocate(XcosDiagram xcosDiagram) {
        ViewPortTab viewPortTab = new ViewPortTab(xcosDiagram, xcosDiagram.getViewPortTab());
        XcosTab xcosTab = XcosTab.get(xcosDiagram);
        xcosTab.setViewportChecked(true);
        ClosingOperationsManager.registerClosingOperation((SwingScilabDockablePanel)viewPortTab, (ClosingOperationsManager.ClosingOperation)new ClosingOperation(xcosDiagram));
        ClosingOperationsManager.addDependency((SwingScilabDockablePanel)XcosTab.get(xcosDiagram), (SwingScilabDockablePanel)viewPortTab);
        WindowsConfigurationManager.registerEndedRestoration((SwingScilabDockablePanel)viewPortTab, (WindowsConfigurationManager.EndedRestoration)new EndedRestoration(xcosDiagram));
        WindowsConfigurationManager.makeDependency((String)xcosDiagram.getGraphTab(), (String)viewPortTab.getPersistentId());
        ScilabTabFactory.getInstance().addToCache((SwingScilabDockablePanel)viewPortTab);
        return viewPortTab;
    }

    private void initComponents(XcosDiagram xcosDiagram) {
        mxGraphOutline mxGraphOutline2 = new mxGraphOutline(xcosDiagram.getAsComponent());
        mxGraphOutline2.setDrawLabels(true);
        this.setContentPane((Container)mxGraphOutline2);
    }

    private static class ClosingOperation
    implements ClosingOperationsManager.ClosingOperation {
        private final XcosDiagram graph;

        public ClosingOperation(XcosDiagram xcosDiagram) {
            this.graph = xcosDiagram;
        }

        public int canClose() {
            return 1;
        }

        public void destroy() {
            XcosTab xcosTab = XcosTab.get(this.graph);
            xcosTab.setViewportChecked(false);
        }

        public String askForClosing(List<SwingScilabDockablePanel> list) {
            return null;
        }

        public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
        }
    }

    private static class EndedRestoration
    implements WindowsConfigurationManager.EndedRestoration {
        public EndedRestoration(XcosDiagram xcosDiagram) {
        }

        public void finish() {
        }
    }
}

