/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.view;

import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.props.PropertyManager;
import org.flexdock.docking.props.RootDockablePropertySet;
import org.flexdock.docking.props.ScopedDockablePropertySet;
import org.flexdock.view.View;

public class ViewProps
extends ScopedDockablePropertySet {
    public static final String ACTIVE_STATE_LOCKED = "View.ACTIVE_STATE_LOCKED";

    public ViewProps(View view) {
        super(view);
        this.init();
    }

    public ViewProps(int initialCapacity, View view) {
        super(initialCapacity, (Dockable)view);
        this.init();
    }

    protected void init() {
        this.constrainRoot(ACTIVE_STATE_LOCKED, Boolean.FALSE);
    }

    protected void constrainRoot(Object key, Object value) {
        Map map = this.getRoot();
        if (map instanceof RootDockablePropertySet) {
            ((RootDockablePropertySet)map).constrain(key, value);
        }
    }

    private View getView() {
        return View.getInstance(this.getDockingId());
    }

    public Boolean isActiveStateLocked() {
        return (Boolean)PropertyManager.getProperty((Object)ACTIVE_STATE_LOCKED, this);
    }

    public void setActiveStateLocked(boolean locked) {
        this.put((Object)ACTIVE_STATE_LOCKED, locked);
    }

    public void setActive(boolean active) {
        View view = this.getView();
        if (view == null) {
            super.setActive(active);
            return;
        }
        if (!view.isActiveStateLocked() && active != this.isActive()) {
            super.setActive(active);
            if (view.getTitlebar() != null) {
                view.getTitlebar().repaint();
            }
        }
    }
}

