/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective;

import java.awt.Component;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.DockingSplitPane;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.docking.state.tree.DockableNode;
import org.flexdock.docking.state.tree.DockingPortNode;
import org.flexdock.docking.state.tree.SplitNode;
import org.flexdock.util.SwingUtility;

public class LayoutBuilder {
    private static final LayoutBuilder SINGLETON = new LayoutBuilder();

    public static LayoutBuilder getInstance() {
        return SINGLETON;
    }

    private LayoutBuilder() {
    }

    public LayoutNode createLayout(DockingPort port) {
        if (port == null) {
            return null;
        }
        return this.createLayoutImpl(port);
    }

    private LayoutNode createLayoutImpl(DockingPort port) {
        DockingPortNode node = new DockingPortNode();
        node.setUserObject(port);
        Component docked = port.getDockedComponent();
        this.link((LayoutNode)node, docked);
        return node;
    }

    private LayoutNode createLayout(JSplitPane split) {
        String region = (String)SwingUtility.getClientProperty(split, "region");
        Component left = split.getLeftComponent();
        Component right = split.getRightComponent();
        float percent = split instanceof DockingSplitPane && ((DockingSplitPane)split).getPercent() != -1.0 ? (float)((DockingSplitPane)split).getPercent() : SwingUtility.getDividerProportion(split);
        SplitNode node = new SplitNode(split.getOrientation(), 0, percent, null);
        node.setDockingRegion(region);
        this.link((LayoutNode)node, left);
        this.link((LayoutNode)node, right);
        return node;
    }

    private LayoutNode createLayout(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        DockableNode node = new DockableNode();
        node.setDockableId(dockable.getPersistentId());
        return node;
    }

    private LayoutNode[] createLayout(JTabbedPane tabs) {
        int len = tabs.getComponentCount();
        LayoutNode[] nodes = new LayoutNode[len];
        for (int i = 0; i < len; ++i) {
            Component comp = tabs.getComponent(i);
            Dockable dockable = DockingManager.getDockable(comp);
            nodes[i] = this.createLayout(dockable);
        }
        return nodes;
    }

    private void link(LayoutNode node, Component child) {
        if (child instanceof DockingPort) {
            LayoutNode childNode = this.createLayoutImpl((DockingPort)((Object)child));
            this.link(node, childNode);
        } else if (child instanceof JSplitPane) {
            LayoutNode childNode = this.createLayout((JSplitPane)child);
            this.link(node, childNode);
        } else if (child instanceof JTabbedPane) {
            LayoutNode[] children = this.createLayout((JTabbedPane)child);
            for (int i = 0; i < children.length; ++i) {
                this.link(node, children[i]);
            }
        } else {
            Dockable dockable = DockingManager.getDockable(child);
            LayoutNode childNode = this.createLayout(dockable);
            this.link(node, childNode);
        }
    }

    private void link(LayoutNode parent, LayoutNode child) {
        if (child != null) {
            parent.add(child);
        }
    }
}

