/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.external_objects_java;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.scilab.modules.external_objects_java.ScilabClassLoader;
import org.scilab.modules.external_objects_java.ScilabJavaArray;
import org.scilab.modules.external_objects_java.ScilabJavaClass;
import org.scilab.modules.external_objects_java.ScilabJavaException;
import org.scilab.modules.external_objects_java.ScilabJavaMethod;

public class ScilabJavaObject {
    private static final int INITIALCAPACITY = 1024;
    private static final Map<Class, Integer> unwrappableType = new HashMap<Class, Integer>(51);
    private static final Map<Class, Integer> listBaseType = new HashMap<Class, Integer>(9);
    private static final Class[] returnType = new Class[1];
    static final Map<Class, Class> primTypes = new HashMap<Class, Class>(8);
    private static int currentPos = 1;
    private static FreePlace freePlace = new FreePlace();
    static boolean debug;
    static Logger logger;
    static FileHandler handler;
    protected static int currentCapacity;
    protected static ScilabJavaObject[] arraySJO;
    protected Object object;
    protected Class clazz;
    protected int id;

    public ScilabJavaObject(Object object) {
        this(object, object == null ? null : object.getClass());
    }

    public ScilabJavaObject(Object object, Class clazz) {
        this.object = object;
        this.clazz = clazz;
        if (object != null) {
            int n = freePlace.getFreePlace();
            this.id = n == -1 ? currentPos++ : n;
            ScilabJavaObject.arraySJO[this.id] = this;
            if (debug) {
                logger.log(Level.INFO, "Object creation with id=" + this.id + " and class=" + clazz.toString());
            }
            if (currentPos >= currentCapacity) {
                ScilabJavaObject[] scilabJavaObjectArray = new ScilabJavaObject[currentCapacity *= 2];
                System.arraycopy(arraySJO, 0, scilabJavaObjectArray, 0, currentPos);
                arraySJO = scilabJavaObjectArray;
                if (debug) {
                    logger.log(Level.INFO, "Scope copy");
                }
            }
        } else {
            if (debug) {
                logger.log(Level.INFO, "Object creation with id=0");
            }
            this.id = 0;
        }
    }

    public static final void initScilabJavaObject() {
    }

    public static final void enableTrace(String string) throws ScilabJavaException {
        if (debug) {
            ScilabJavaObject.disableTrace();
        }
        debug = true;
        logger = Logger.getLogger("JIMS");
        try {
            handler = new FileHandler(string, true);
            logger.addHandler(handler);
            logger.setLevel(Level.ALL);
            SimpleFormatter simpleFormatter = new SimpleFormatter();
            handler.setFormatter(simpleFormatter);
        }
        catch (SecurityException securityException) {
            debug = false;
            throw new ScilabJavaException("A security exception has been thrown:\n" + String.valueOf(securityException));
        }
        catch (IOException iOException) {
            debug = false;
            throw new ScilabJavaException("I/O problem:\n" + String.valueOf(iOException));
        }
    }

    public static final void writeLog(String string) {
        if (debug) {
            logger.log(Level.INFO, string);
        }
    }

    public static final void disableTrace() {
        if (debug && logger != null && handler != null) {
            logger.removeHandler(handler);
            handler.flush();
            handler.close();
            handler = null;
            debug = false;
        }
    }

    public String toString() {
        if (this.object == null) {
            return "null";
        }
        String string = this.object.toString();
        if (string != null) {
            return string;
        }
        return "Instance of " + String.valueOf(this.object.getClass()) + " with hashcode " + System.identityHashCode(this.object);
    }

    protected ScilabJavaObject clone() {
        return new ScilabJavaObject(this.object, this.clazz);
    }

    public static final String[] getInfos() {
        try {
            Class<?> clazz = Class.forName("java.lang.VersionProps");
            Method method = clazz.getMethod("print", Boolean.TYPE);
            method.setAccessible(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            System.setOut(printStream);
            method.invoke(null, false);
            printStream.flush();
            System.setOut(System.out);
            String[] stringArray = byteArrayOutputStream.toString().split("\n");
            printStream.close();
            byteArrayOutputStream.close();
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String getRepresentation(int n) {
        if (arraySJO[n] != null) {
            return arraySJO[n].toString();
        }
        return "Invalid Java object";
    }

    public static final boolean isValidJavaObject(int n) {
        return n == 0 || n > 0 && arraySJO[n] != null;
    }

    public static final int getArrayElement(int n, int[] nArray) throws ScilabJavaException {
        if (n > 0) {
            if (debug) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(");
                if (nArray.length > 0) {
                    int n2;
                    for (n2 = 0; n2 < nArray.length - 1; ++n2) {
                        stringBuffer.append(Integer.toString(nArray[n2]));
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(Integer.toString(nArray[n2]));
                }
                stringBuffer.append(")");
                logger.log(Level.INFO, "Get array element: array id=" + n + " at position " + stringBuffer.toString());
            }
            if (arraySJO[n] == null) {
                throw new ScilabJavaException("Invalid Java object");
            }
            return new ScilabJavaObject((Object)ScilabJavaArray.get((Object)ScilabJavaObject.arraySJO[n].object, (int[])nArray)).id;
        }
        throw new ScilabJavaException("null is not an array");
    }

    public static final void setArrayElement(int n, int[] nArray, int n2) throws ScilabJavaException {
        if (n > 0) {
            if (debug) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(");
                if (nArray.length > 0) {
                    int n3;
                    for (n3 = 0; n3 < nArray.length - 1; ++n3) {
                        stringBuffer.append(Integer.toString(nArray[n3]));
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(Integer.toString(nArray[n3]));
                }
                stringBuffer.append(")");
                logger.log(Level.INFO, "Set array element: array id=" + n + " at position " + stringBuffer.toString() + " and element id=" + n2);
            }
            if (arraySJO[n] == null) {
                throw new ScilabJavaException("Invalid Java object");
            }
        } else {
            throw new ScilabJavaException("null is not an array");
        }
        ScilabJavaArray.set(ScilabJavaObject.arraySJO[n].object, nArray, ScilabJavaObject.arraySJO[n2].object);
    }

    public static final String[] getCompletion(int n, String[] stringArray) throws ScilabJavaException {
        if (n > 0) {
            int n2;
            boolean bl;
            if (debug) {
                logger.log(Level.INFO, "Get accessible methods and fields in object id=" + n + " with path " + Arrays.deepToString(stringArray));
            }
            if (arraySJO[n] == null) {
                throw new ScilabJavaException("Invalid Java object");
            }
            Class<?> clazz = ScilabJavaObject.arraySJO[n].clazz;
            boolean bl2 = bl = ScilabJavaObject.arraySJO[n].object == clazz;
            if (stringArray.length == 0) {
                return ScilabJavaObject.getFieldsAndMethods(clazz, bl);
            }
            if (bl) {
                try {
                    Field field = clazz.getField(stringArray[0]);
                    int n3 = field.getModifiers();
                    if (!Modifier.isPublic(n3) || !Modifier.isStatic(n3)) {
                        return new String[0];
                    }
                    clazz = field.getType();
                }
                catch (Exception exception) {
                    return new String[0];
                }
            }
            int n4 = n2 = bl ? 1 : 0;
            while (n2 < stringArray.length) {
                try {
                    Field field = clazz.getField(stringArray[n2]);
                    if (!Modifier.isPublic(field.getModifiers())) {
                        return new String[0];
                    }
                    clazz = field.getType();
                }
                catch (Exception exception) {
                    return new String[0];
                }
                ++n2;
            }
            return ScilabJavaObject.getFieldsAndMethods(clazz, false);
        }
        return new String[0];
    }

    private static final String[] getFieldsAndMethods(Class clazz, boolean bl) {
        if (clazz.isArray()) {
            return new String[]{"length"};
        }
        try {
            int n;
            Field[] fieldArray = clazz.getFields();
            Method[] methodArray = clazz.getMethods();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Field accessibleObject : fieldArray) {
                n = accessibleObject.getModifiers();
                if (!Modifier.isPublic(n) || bl && !Modifier.isStatic(n)) continue;
                treeSet.add(accessibleObject.getName());
            }
            for (AccessibleObject accessibleObject : methodArray) {
                n = ((Method)accessibleObject).getModifiers();
                if (!Modifier.isPublic(n) || bl && !Modifier.isStatic(n)) continue;
                treeSet.add(((Method)accessibleObject).getName());
            }
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                if (propertyDescriptorArray != null) {
                    for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                        treeSet.add(propertyDescriptor.getName());
                        Method method = propertyDescriptor.getReadMethod();
                        Method method2 = propertyDescriptor.getWriteMethod();
                        if (method != null) {
                            treeSet.remove(method.getName());
                        }
                        if (method2 == null) continue;
                        treeSet.remove(method2.getName());
                    }
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static final String[] getAccessibleMethods(int n) throws ScilabJavaException {
        if (n > 0) {
            if (debug) {
                logger.log(Level.INFO, "Get accessible methods in object id=" + n);
            }
            if (arraySJO[n] == null) {
                throw new ScilabJavaException("Invalid Java object");
            }
            Method[] methodArray = ScilabJavaObject.arraySJO[n].clazz.getMethods();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Method method : methodArray) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                treeSet.add(method.getName());
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }
        return new String[0];
    }

    public static final String[] getAccessibleFields(int n) throws ScilabJavaException {
        if (n > 0) {
            if (debug) {
                logger.log(Level.INFO, "Get accessible fields in object id=" + n);
            }
            if (arraySJO[n] == null) {
                throw new ScilabJavaException("Invalid Java object");
            }
            if (ScilabJavaObject.arraySJO[n].clazz.isArray()) {
                return new String[]{"length"};
            }
            Field[] fieldArray = ScilabJavaObject.arraySJO[n].clazz.getFields();
            String[] stringArray = new String[fieldArray.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!Modifier.isPublic(fieldArray[i].getModifiers())) continue;
                stringArray[i] = fieldArray[i].getName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public static final String getClassName(int n) throws ScilabJavaException {
        if (n > 0) {
            if (debug) {
                logger.log(Level.INFO, "Get class name of object id=" + n);
            }
            if (arraySJO[n] == null) {
                throw new ScilabJavaException("Invalid Java object");
            }
            return ScilabJavaObject.arraySJO[n].clazz.getName();
        }
        return "null";
    }

    public static final void setField(int n, String string, int n2) throws ScilabJavaException {
        if (n > 0) {
            Field field = null;
            try {
                if (debug) {
                    logger.log(Level.INFO, "Set field '" + string + "' in object id=" + n + " with value id=" + n2);
                }
                if (arraySJO[n] == null) {
                    throw new ScilabJavaException("Invalid Java object");
                }
                try {
                    field = ScilabJavaObject.arraySJO[n].clazz.getField(string);
                    try {
                        field.set(ScilabJavaObject.arraySJO[n].object, ScilabJavaObject.arraySJO[n2].object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (field != null && field.getType() == Integer.TYPE && (ScilabJavaObject.arraySJO[n2].clazz == Double.TYPE || ScilabJavaObject.arraySJO[n2].clazz == Double.class) && (double)((Double)ScilabJavaObject.arraySJO[n2].object).intValue() == (Double)ScilabJavaObject.arraySJO[n2].object) {
                            field.set(ScilabJavaObject.arraySJO[n].object, ((Double)ScilabJavaObject.arraySJO[n2].object).intValue());
                            return;
                        }
                        throw illegalArgumentException;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                PropertyDescriptor propertyDescriptor = ScilabJavaObject.lookupBeanProperty(n, string);
                Method method = propertyDescriptor.getWriteMethod();
                if (method == null) {
                    throw new ScilabJavaException("Cannot read the property " + string + " in object " + ScilabJavaObject.getClassName(n));
                }
                method.invoke(ScilabJavaObject.arraySJO[n].object, ScilabJavaObject.arraySJO[n2].object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ScilabJavaException("Bad argument value for field " + string + " in object " + ScilabJavaObject.getClassName(n));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ScilabJavaException("Cannot access to the field " + string + " in object " + ScilabJavaObject.getClassName(n));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ScilabJavaException("Exception occurs on write access to the property " + string + " in object " + ScilabJavaObject.getClassName(n));
            }
        }
        throw new ScilabJavaException("null is not an object");
    }

    public static final int getField(int n, String string) throws ScilabJavaException {
        if (n > 0) {
            try {
                if (debug) {
                    logger.log(Level.INFO, "Get field '" + string + "' in object id=" + n);
                }
                if (arraySJO[n] == null) {
                    throw new ScilabJavaException("Invalid Java object");
                }
                if (ScilabJavaObject.arraySJO[n].clazz.isArray() && string.equals("length")) {
                    return new ScilabJavaObject((Object)Integer.valueOf((int)Array.getLength((Object)ScilabJavaObject.arraySJO[n].object)), Integer.TYPE).id;
                }
                if (ScilabJavaObject.arraySJO[n].object == ScilabJavaObject.arraySJO[n].clazz && string.equals("class")) {
                    return new ScilabJavaObject((Object)ScilabJavaObject.arraySJO[n].object, ScilabJavaObject.arraySJO[n].object.getClass()).id;
                }
                try {
                    Field field = ScilabJavaObject.arraySJO[n].clazz.getField(string);
                    Class<?> clazz = field.getType();
                    if (clazz == Integer.TYPE) {
                        return new ScilabJavaObject((Object)Integer.valueOf((int)field.getInt((Object)ScilabJavaObject.arraySJO[n].object)), Integer.TYPE).id;
                    }
                    if (clazz == Double.TYPE) {
                        return new ScilabJavaObject((Object)Double.valueOf((double)field.getDouble((Object)ScilabJavaObject.arraySJO[n].object)), Double.TYPE).id;
                    }
                    if (clazz == Boolean.TYPE) {
                        return new ScilabJavaObject((Object)Boolean.valueOf((boolean)field.getBoolean((Object)ScilabJavaObject.arraySJO[n].object)), Boolean.TYPE).id;
                    }
                    if (clazz == Short.TYPE) {
                        return new ScilabJavaObject((Object)Short.valueOf((short)field.getShort((Object)ScilabJavaObject.arraySJO[n].object)), Short.TYPE).id;
                    }
                    if (clazz == Character.TYPE) {
                        return new ScilabJavaObject((Object)Character.valueOf((char)field.getChar((Object)ScilabJavaObject.arraySJO[n].object)), Character.TYPE).id;
                    }
                    if (clazz == Float.TYPE) {
                        return new ScilabJavaObject((Object)Float.valueOf((float)field.getFloat((Object)ScilabJavaObject.arraySJO[n].object)), Float.TYPE).id;
                    }
                    if (clazz == Byte.TYPE) {
                        return new ScilabJavaObject((Object)Byte.valueOf((byte)field.getByte((Object)ScilabJavaObject.arraySJO[n].object)), Byte.TYPE).id;
                    }
                    if (clazz == Long.TYPE) {
                        return new ScilabJavaObject((Object)Long.valueOf((long)field.getLong((Object)ScilabJavaObject.arraySJO[n].object)), Long.TYPE).id;
                    }
                    return new ScilabJavaObject((Object)field.get((Object)ScilabJavaObject.arraySJO[n].object)).id;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    PropertyDescriptor propertyDescriptor = ScilabJavaObject.lookupBeanProperty(n, string);
                    Method method = propertyDescriptor.getReadMethod();
                    if (method == null) {
                        throw new ScilabJavaException("Cannot read the field or property " + string + " in object " + ScilabJavaObject.getClassName(n));
                    }
                    Object object = method.invoke(ScilabJavaObject.arraySJO[n].object, new Object[0]);
                    if (object == null) {
                        return new ScilabJavaObject((Object)object).id;
                    }
                    Class<?> clazz = object.getClass();
                    if (clazz == Integer.TYPE) {
                        return new ScilabJavaObject((Object)object, Integer.TYPE).id;
                    }
                    if (clazz == Double.TYPE) {
                        return new ScilabJavaObject((Object)object, Double.TYPE).id;
                    }
                    if (clazz == Boolean.TYPE) {
                        return new ScilabJavaObject((Object)object, Boolean.TYPE).id;
                    }
                    if (clazz == Short.TYPE) {
                        return new ScilabJavaObject((Object)object, Short.TYPE).id;
                    }
                    if (clazz == Character.TYPE) {
                        return new ScilabJavaObject((Object)object, Character.TYPE).id;
                    }
                    if (clazz == Float.TYPE) {
                        return new ScilabJavaObject((Object)object, Float.TYPE).id;
                    }
                    if (clazz == Byte.TYPE) {
                        return new ScilabJavaObject((Object)object, Byte.TYPE).id;
                    }
                    if (clazz == Long.TYPE) {
                        return new ScilabJavaObject((Object)object, Long.TYPE).id;
                    }
                    return new ScilabJavaObject((Object)object).id;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ScilabJavaException("Bad argument value for field " + string + " in object " + ScilabJavaObject.getClassName(n));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ScilabJavaException("Cannot access to the field " + string + " in object " + ScilabJavaObject.getClassName(n));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ScilabJavaException("Exception occurs on read access to the property " + string + " in object " + ScilabJavaObject.getClassName(n));
            }
        }
        throw new ScilabJavaException("null is not an object");
    }

    public static final int getFieldType(int n, String string) {
        if (n > 0 && arraySJO[n] != null) {
            if (debug) {
                logger.log(Level.INFO, "Get field type of '" + string + "' in object id=" + n);
            }
            if (ScilabJavaObject.isValidMethod(n, string)) {
                return 0;
            }
            try {
                if (ScilabJavaObject.arraySJO[n].clazz.isArray()) {
                    if (string.equals("length")) {
                        return 1;
                    }
                    return -1;
                }
                if (ScilabJavaObject.arraySJO[n].object == ScilabJavaObject.arraySJO[n].clazz && string.equals("class")) {
                    return 1;
                }
                try {
                    Field field = ScilabJavaObject.arraySJO[n].clazz.getField(string);
                    return 1;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    ScilabJavaObject.lookupBeanProperty(n, string);
                    return 1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            catch (ScilabJavaException scilabJavaException) {
                return -1;
            }
        }
        return -1;
    }

    private static final boolean isValidMethod(int n, String string) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(ScilabJavaObject.arraySJO[n].clazz);
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
        MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
        if (methodDescriptorArray == null) {
            return false;
        }
        for (MethodDescriptor methodDescriptor : methodDescriptorArray) {
            if (!string.equals(methodDescriptor.getName())) continue;
            return true;
        }
        return false;
    }

    private static final PropertyDescriptor lookupBeanProperty(int n, String string) throws ScilabJavaException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(ScilabJavaObject.arraySJO[n].clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new ScilabJavaException("Unable to get properties of object " + ScilabJavaObject.getClassName(n));
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            throw new ScilabJavaException("No property " + string + " in object " + ScilabJavaObject.getClassName(n));
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        throw new ScilabJavaException("No property " + string + " in object " + ScilabJavaObject.getClassName(n));
    }

    public static final int invoke(int n, String string, int[] nArray) throws ScilabJavaException {
        if (n > 0) {
            Object object;
            if (debug) {
                object = new StringBuffer();
                ((StringBuffer)object).append("(");
                if (nArray.length > 0) {
                    int n2;
                    for (n2 = 0; n2 < nArray.length - 1; ++n2) {
                        ((StringBuffer)object).append(Integer.toString(nArray[n2]));
                        ((StringBuffer)object).append(",");
                    }
                    ((StringBuffer)object).append(Integer.toString(nArray[n2]));
                }
                ((StringBuffer)object).append(")");
                logger.log(Level.INFO, "Invoke method '" + string + "' in object id=" + n + " with arguments id=" + ((StringBuffer)object).toString());
            }
            if (arraySJO[n] != null) {
                object = ScilabJavaMethod.invoke(string, ScilabJavaObject.arraySJO[n].clazz, ScilabJavaObject.arraySJO[n].object, returnType, nArray);
                if (object == null && returnType[0] == Void.TYPE) {
                    return -1;
                }
                return new ScilabJavaObject((Object)object, (Class)ScilabJavaObject.returnType[0]).id;
            }
            throw new ScilabJavaException("Invalid Java object");
        }
        throw new ScilabJavaException("null is not an object");
    }

    public static final int extract(int n, int[] nArray) throws ScilabJavaException {
        if (n > 0) {
            int n2;
            if (debug) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(");
                if (nArray.length > 0) {
                    for (n2 = 0; n2 < nArray.length - 1; ++n2) {
                        stringBuffer.append(Integer.toString(nArray[n2]));
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(Integer.toString(nArray[n2]));
                }
                stringBuffer.append(")");
                logger.log(Level.INFO, "Extract in object id=" + n + " with arguments id=" + stringBuffer.toString());
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= 0 && arraySJO[nArray[i]] != null) continue;
                throw new ScilabJavaException("Invalid Java object at position " + i);
            }
            if (arraySJO[n] != null) {
                Object object = ScilabJavaObject.arraySJO[n].object;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    Object object2;
                    Object object3 = object2 = nArray[n2] == 0 ? null : ScilabJavaObject.arraySJO[nArray[n2]].object;
                    if (object instanceof Map) {
                        object = ((Map)object).get(object2);
                        continue;
                    }
                    if (object instanceof List) {
                        List list = (List)object;
                        int n3 = -1;
                        n3 = object2 instanceof Double ? ((Double)object2).intValue() - 1 : (object2 instanceof Integer ? (Integer)object2 - 1 : (object2 instanceof Poly ? (int)ScilabJavaObject.horner(list.size(), (Poly)object2) - 1 : list.indexOf(object2)));
                        if (n3 >= 0 || n3 < list.size()) {
                            object = list.get(n3);
                            continue;
                        }
                        throw new ScilabJavaException("Cannot get object at position " + (n2 + 1));
                    }
                    if (object.getClass().isArray()) {
                        int n4 = -1;
                        if (object2 instanceof Double) {
                            n4 = ((Double)object2).intValue();
                        } else if (object2 instanceof Integer) {
                            n4 = (Integer)object2;
                        }
                        object = ScilabJavaArray.get(object, new int[]{n4 - 1});
                        continue;
                    }
                    throw new ScilabJavaException("Invalid field " + (object2 == null ? "null" : object2.toString()));
                }
                if (object == null) {
                    return 0;
                }
                return new ScilabJavaObject((Object)object).id;
            }
            throw new ScilabJavaException("Invalid Java object");
        }
        throw new ScilabJavaException("null is not an object");
    }

    public static final void insert(int n, int[] nArray, int n2) throws ScilabJavaException {
        if (n > 0) {
            int n3;
            Object object;
            if (debug) {
                object = new StringBuffer();
                ((StringBuffer)object).append("(");
                if (nArray.length > 0) {
                    for (n3 = 0; n3 < nArray.length - 1; ++n3) {
                        ((StringBuffer)object).append(Integer.toString(nArray[n3]));
                        ((StringBuffer)object).append(",");
                    }
                    ((StringBuffer)object).append(Integer.toString(nArray[n3]));
                }
                ((StringBuffer)object).append(")");
                logger.log(Level.INFO, "Insert in object id=" + n + " with arguments id=" + ((StringBuffer)object).toString() + " and the value id=" + n2);
            }
            if (arraySJO[n] != null) {
                int n4;
                List list;
                Object object2;
                object = ScilabJavaObject.arraySJO[n].object;
                for (n3 = 0; n3 < nArray.length - 1; ++n3) {
                    Object object3 = object2 = nArray[n3] == 0 ? null : ScilabJavaObject.arraySJO[nArray[n3]].object;
                    if (object instanceof Map) {
                        object = ((Map)object).get(object2);
                        continue;
                    }
                    if (object instanceof List) {
                        list = (List)object;
                        n4 = -1;
                        n4 = object2 instanceof Double ? ((Double)object2).intValue() - 1 : (object2 instanceof Integer ? (Integer)object2 - 1 : list.indexOf(object2));
                        if (n4 >= 0 || n4 < list.size()) {
                            object = list.get(n4);
                            continue;
                        }
                        throw new ScilabJavaException("Cannot get object at position " + (n3 + 1));
                    }
                    if (object.getClass().isArray()) {
                        int n5 = -1;
                        if (object2 instanceof Double) {
                            n5 = ((Double)object2).intValue();
                        } else if (object2 instanceof Integer) {
                            n5 = (Integer)object2;
                        }
                        object = ScilabJavaArray.get(object, new int[]{n5 - 1});
                        continue;
                    }
                    throw new ScilabJavaException("Invalid field " + (object2 == null ? "null" : object2.toString()));
                }
                if (object == null) {
                    return;
                }
                n3 = nArray[nArray.length - 1];
                Object object4 = object2 = n3 == 0 ? null : ScilabJavaObject.arraySJO[n3].object;
                if (object instanceof Map) {
                    ((Map)object).put(object2, ScilabJavaObject.arraySJO[n2].object);
                } else if (object instanceof List) {
                    list = (List)object;
                    n4 = -1;
                    n4 = object2 instanceof Double ? ((Double)object2).intValue() - 1 : (object2 instanceof Integer ? (Integer)object2 - 1 : (object2 instanceof Poly ? (int)ScilabJavaObject.horner(list.size(), (Poly)object2) - 1 : list.indexOf(object2)));
                    if (n4 >= 0 && n4 < list.size()) {
                        list.set(n4, ScilabJavaObject.arraySJO[n2].object);
                    } else if (n4 < 0) {
                        list.add(0, ScilabJavaObject.arraySJO[n2].object);
                    } else {
                        list.add(n4, ScilabJavaObject.arraySJO[n2].object);
                    }
                } else if (object.getClass().isArray()) {
                    int n6 = -1;
                    if (object2 instanceof Double) {
                        n6 = ((Double)object2).intValue();
                    } else if (object2 instanceof Integer) {
                        n6 = (Integer)object2;
                    }
                    ScilabJavaArray.set(object, new int[]{n6 - 1}, ScilabJavaObject.arraySJO[n2].object);
                } else {
                    throw new ScilabJavaException("Invalid field " + (object2 == null ? "null" : object2.toString()));
                }
                return;
            }
            throw new ScilabJavaException("Invalid Java object");
        }
        throw new ScilabJavaException("null is not an object");
    }

    private static final double horner(double d, Poly poly) {
        double d2 = 0.0;
        for (int i = poly.coefs.length - 1; i >= 0; --i) {
            d2 = d2 * d + poly.coefs[i];
        }
        return d2;
    }

    public static final int javaCast(int n, String string) throws ScilabJavaException {
        if (n > 0) {
            if (debug) {
                logger.log(Level.INFO, "Cast object id=" + n + " to class " + string);
            }
            int n2 = ScilabClassLoader.loadJavaClass(string, false);
            Class clazz = (Class)ScilabJavaObject.arraySJO[n2].object;
            try {
                int n3 = new ScilabJavaObject(clazz.cast((Object)ScilabJavaObject.arraySJO[n].object), (Class)clazz).id;
                ScilabJavaObject.removeScilabJavaObject(n2);
                return n3;
            }
            catch (ClassCastException classCastException) {
                throw new ScilabJavaException("Cannot cast object " + ScilabJavaObject.getClassName(n) + " into " + ScilabJavaObject.getClassName(n2));
            }
        }
        throw new ScilabJavaException("null is not an object");
    }

    public static final int javaCast(int n, int n2) throws ScilabJavaException {
        if (n > 0) {
            if (debug) {
                logger.log(Level.INFO, "Cast object id=" + n + " to class with id=" + n2);
            }
            Class clazz = (Class)ScilabJavaObject.arraySJO[n2].object;
            try {
                return new ScilabJavaObject(clazz.cast((Object)ScilabJavaObject.arraySJO[n].object), (Class)clazz).id;
            }
            catch (ClassCastException classCastException) {
                throw new ScilabJavaException("Cannot cast object " + ScilabJavaObject.getClassName(n) + " into " + ScilabJavaObject.getClassName(n2));
            }
        }
        throw new ScilabJavaException("null is not an object");
    }

    public static final void removeScilabJavaObject(int n) {
        if (n > 0 && arraySJO[n] != null) {
            if (debug) {
                logger.log(Level.INFO, "Remove object id=" + n);
            }
            freePlace.addFreePlace(n);
            if (arraySJO[n] instanceof ScilabJavaClass) {
                ScilabClassLoader.removeID(n);
            }
            ScilabJavaObject.arraySJO[n] = null;
        }
    }

    public static final void removeScilabJavaObject(int[] nArray) {
        for (int n : nArray) {
            ScilabJavaObject.removeScilabJavaObject(n);
        }
    }

    public static final void limitDirectBuffer(int n) {
        if (n > 0 && arraySJO[n] != null && ScilabJavaObject.arraySJO[n].object instanceof Buffer) {
            if (debug) {
                logger.log(Level.INFO, "Limit direct buffer with id=" + n);
            }
            ((Buffer)ScilabJavaObject.arraySJO[n].object).limit(0);
        }
    }

    public static final void garbageCollect() {
        if (debug) {
            logger.log(Level.INFO, "Garbage collection");
        }
        currentPos = 1;
        currentCapacity = 1024;
        arraySJO = new ScilabJavaObject[currentCapacity];
        ScilabJavaObject.arraySJO[0] = new ScilabJavaObject(null, null);
        freePlace = new FreePlace();
        ScilabClassLoader.clazz.clear();
        System.gc();
        System.runFinalization();
    }

    public static final int wrapAsDirectByteBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return new ScilabJavaObject((Object)byteBuffer, ByteBuffer.class).id;
    }

    public static final int wrapAsDirectDoubleBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return new ScilabJavaObject((Object)byteBuffer.asDoubleBuffer(), DoubleBuffer.class).id;
    }

    public static final int wrapAsDirectIntBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return new ScilabJavaObject((Object)byteBuffer.asIntBuffer(), IntBuffer.class).id;
    }

    public static final int wrapAsDirectCharBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return new ScilabJavaObject((Object)byteBuffer.asCharBuffer(), CharBuffer.class).id;
    }

    public static final int wrapAsDirectFloatBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return new ScilabJavaObject((Object)byteBuffer.asFloatBuffer(), FloatBuffer.class).id;
    }

    public static final int wrapAsDirectLongBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return new ScilabJavaObject((Object)byteBuffer.asLongBuffer(), LongBuffer.class).id;
    }

    public static final int wrapAsDirectShortBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return new ScilabJavaObject((Object)byteBuffer.asShortBuffer(), ShortBuffer.class).id;
    }

    public static final int wrap(double d) {
        return new ScilabJavaObject((Object)Double.valueOf((double)d), Double.TYPE).id;
    }

    public static final int wrap(double[] dArray) {
        return new ScilabJavaObject((Object)dArray, double[].class).id;
    }

    public static final int wrap(double[][] dArray) {
        return new ScilabJavaObject((Object)dArray, double[][].class).id;
    }

    public static final int wrap(int n) {
        return new ScilabJavaObject((Object)Integer.valueOf((int)n), Integer.TYPE).id;
    }

    public static final int wrap(int[] nArray) {
        return new ScilabJavaObject((Object)nArray, int[].class).id;
    }

    public static final int wrap(int[][] nArray) {
        return new ScilabJavaObject((Object)nArray, int[][].class).id;
    }

    public static final int wrap(long l) {
        return new ScilabJavaObject((Object)Long.valueOf((long)l), Long.TYPE).id;
    }

    public static final int wrap(long[] lArray) {
        return new ScilabJavaObject((Object)lArray, long[].class).id;
    }

    public static final int wrap(long[][] lArray) {
        return new ScilabJavaObject((Object)lArray, long[][].class).id;
    }

    public static final int wrap(byte by) {
        return new ScilabJavaObject((Object)Byte.valueOf((byte)by), Byte.TYPE).id;
    }

    public static final int wrap(byte[] byArray) {
        return new ScilabJavaObject((Object)byArray, byte[].class).id;
    }

    public static final int wrap(byte[][] byArray) {
        return new ScilabJavaObject((Object)byArray, byte[][].class).id;
    }

    public static final int wrap(short s) {
        return new ScilabJavaObject((Object)Short.valueOf((short)s), Short.TYPE).id;
    }

    public static final int wrap(short[] sArray) {
        return new ScilabJavaObject((Object)sArray, short[].class).id;
    }

    public static final int wrap(short[][] sArray) {
        return new ScilabJavaObject((Object)sArray, short[][].class).id;
    }

    public static final int wrap(String string) {
        return new ScilabJavaObject((Object)string, String.class).id;
    }

    public static final int wrap(String[] stringArray) {
        return new ScilabJavaObject((Object)stringArray, String[].class).id;
    }

    public static final int wrap(String[][] stringArray) {
        return new ScilabJavaObject((Object)stringArray, String[][].class).id;
    }

    public static final int wrap(boolean bl) {
        return new ScilabJavaObject((Object)Boolean.valueOf((boolean)bl), Boolean.TYPE).id;
    }

    public static final int wrap(boolean[] blArray) {
        return new ScilabJavaObject((Object)blArray, boolean[].class).id;
    }

    public static final int wrap(boolean[][] blArray) {
        return new ScilabJavaObject((Object)blArray, boolean[][].class).id;
    }

    public static final int wrap(char c) {
        return new ScilabJavaObject((Object)Character.valueOf((char)c), Character.TYPE).id;
    }

    public static final int wrap(char[] cArray) {
        return new ScilabJavaObject((Object)cArray, char[].class).id;
    }

    public static final int wrap(char[][] cArray) {
        return new ScilabJavaObject((Object)cArray, char[][].class).id;
    }

    public static final int wrap(float f) {
        return new ScilabJavaObject((Object)Float.valueOf((float)f), Float.TYPE).id;
    }

    public static final int wrap(float[] fArray) {
        return new ScilabJavaObject((Object)fArray, float[].class).id;
    }

    public static final int wrap(float[][] fArray) {
        return new ScilabJavaObject((Object)fArray, float[][].class).id;
    }

    public static final int wrapList(int[] nArray) {
        ArrayList<ScilabJavaObject> arrayList = new ArrayList<ScilabJavaObject>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(arraySJO[nArray[i]]);
        }
        return new ScilabJavaObject(arrayList, ArrayList.class).id;
    }

    public static final int wrapPoly(double[] dArray) {
        Poly poly = new Poly(dArray);
        return new ScilabJavaObject((Object)poly, Poly.class).id;
    }

    public static final double unwrapDouble(int n) {
        return (Double)ScilabJavaObject.arraySJO[n].object;
    }

    public static final Object unwrapRowDouble(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toDoubleArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Double[]) {
            return ScilabJavaArray.toPrimitive((Double[])ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof DoubleBuffer && !((DoubleBuffer)ScilabJavaObject.arraySJO[n].object).isDirect()) {
            return ((DoubleBuffer)ScilabJavaObject.arraySJO[n].object).array();
        }
        return ScilabJavaObject.arraySJO[n].object;
    }

    public static final double[][] unwrapMatDouble(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof Double[][]) {
            return (double[][])ScilabJavaArray.toPrimitive(ScilabJavaObject.arraySJO[n].object);
        }
        return (double[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final int unwrapInt(int n) {
        return (Integer)ScilabJavaObject.arraySJO[n].object;
    }

    public static final Object unwrapRowInt(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toIntArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Integer[]) {
            return ScilabJavaArray.toPrimitive((Integer[])ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof IntBuffer && !((IntBuffer)ScilabJavaObject.arraySJO[n].object).isDirect()) {
            return ((IntBuffer)ScilabJavaObject.arraySJO[n].object).array();
        }
        return ScilabJavaObject.arraySJO[n].object;
    }

    public static final int[][] unwrapMatInt(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof Integer[][]) {
            return (int[][])ScilabJavaArray.toPrimitive(ScilabJavaObject.arraySJO[n].object);
        }
        return (int[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final short unwrapShort(int n) {
        return (Short)ScilabJavaObject.arraySJO[n].object;
    }

    public static final Object unwrapRowShort(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toShortArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Short[]) {
            return ScilabJavaArray.toPrimitive((Short[])ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof ShortBuffer && !((ShortBuffer)ScilabJavaObject.arraySJO[n].object).isDirect()) {
            return ((ShortBuffer)ScilabJavaObject.arraySJO[n].object).array();
        }
        return ScilabJavaObject.arraySJO[n].object;
    }

    public static final short[][] unwrapMatShort(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof Short[][]) {
            return (short[][])ScilabJavaArray.toPrimitive(ScilabJavaObject.arraySJO[n].object);
        }
        return (short[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final byte unwrapByte(int n) {
        return (Byte)ScilabJavaObject.arraySJO[n].object;
    }

    public static final Object unwrapRowByte(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toByteArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Byte[]) {
            return ScilabJavaArray.toPrimitive((Byte[])ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof ByteBuffer && !((ByteBuffer)ScilabJavaObject.arraySJO[n].object).isDirect()) {
            return ((ByteBuffer)ScilabJavaObject.arraySJO[n].object).array();
        }
        return ScilabJavaObject.arraySJO[n].object;
    }

    public static final byte[][] unwrapMatByte(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof Byte[][]) {
            return (byte[][])ScilabJavaArray.toPrimitive(ScilabJavaObject.arraySJO[n].object);
        }
        return (byte[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final String unwrapString(int n) {
        return (String)ScilabJavaObject.arraySJO[n].object;
    }

    public static final String[] unwrapRowString(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toStringArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        return (String[])ScilabJavaObject.arraySJO[n].object;
    }

    public static final String[][] unwrapMatString(int n) {
        return (String[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final boolean unwrapBoolean(int n) {
        return (Boolean)ScilabJavaObject.arraySJO[n].object;
    }

    public static final boolean[] unwrapRowBoolean(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toBooleanArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Boolean[]) {
            return ScilabJavaArray.toPrimitive((Boolean[])ScilabJavaObject.arraySJO[n].object);
        }
        return (boolean[])ScilabJavaObject.arraySJO[n].object;
    }

    public static final boolean[][] unwrapMatBoolean(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof Boolean[][]) {
            return (boolean[][])ScilabJavaArray.toPrimitive(ScilabJavaObject.arraySJO[n].object);
        }
        return (boolean[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final char unwrapChar(int n) {
        return ((Character)ScilabJavaObject.arraySJO[n].object).charValue();
    }

    public static final Object unwrapRowChar(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toCharArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Character[]) {
            return ScilabJavaArray.toPrimitive((Character[])ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof CharBuffer && !((CharBuffer)ScilabJavaObject.arraySJO[n].object).isDirect()) {
            return ((CharBuffer)ScilabJavaObject.arraySJO[n].object).array();
        }
        return ScilabJavaObject.arraySJO[n].object;
    }

    public static final char[][] unwrapMatChar(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof Character[][]) {
            return (char[][])ScilabJavaArray.toPrimitive(ScilabJavaObject.arraySJO[n].object);
        }
        return (char[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final float unwrapFloat(int n) {
        return ((Float)ScilabJavaObject.arraySJO[n].object).floatValue();
    }

    public static final Object unwrapRowFloat(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toFloatArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Double[]) {
            return ScilabJavaArray.toPrimitive((Float[])ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof FloatBuffer && !((FloatBuffer)ScilabJavaObject.arraySJO[n].object).isDirect()) {
            return ((FloatBuffer)ScilabJavaObject.arraySJO[n].object).array();
        }
        return ScilabJavaObject.arraySJO[n].object;
    }

    public static final float[][] unwrapMatFloat(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof Float[][]) {
            return (float[][])ScilabJavaArray.toPrimitive(ScilabJavaObject.arraySJO[n].object);
        }
        return (float[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final long unwrapLong(int n) {
        return (Long)ScilabJavaObject.arraySJO[n].object;
    }

    public static final Object unwrapRowLong(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            return ScilabJavaArray.toLongArray((List)ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Long[]) {
            return ScilabJavaArray.toPrimitive((Long[])ScilabJavaObject.arraySJO[n].object);
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof LongBuffer && !((LongBuffer)ScilabJavaObject.arraySJO[n].object).isDirect()) {
            return ((LongBuffer)ScilabJavaObject.arraySJO[n].object).array();
        }
        return ScilabJavaObject.arraySJO[n].object;
    }

    public static final long[][] unwrapMatLong(int n) {
        if (ScilabJavaObject.arraySJO[n].object instanceof Long[][]) {
            return (long[][])ScilabJavaArray.toPrimitive(ScilabJavaObject.arraySJO[n].object);
        }
        return (long[][])ScilabJavaObject.arraySJO[n].object;
    }

    public static final int isUnwrappable(int n) {
        if (n == 0) {
            return 1;
        }
        Integer n2 = unwrappableType.get(ScilabJavaObject.arraySJO[n].clazz);
        if (n2 != null) {
            return n2;
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof List) {
            List list = (List)ScilabJavaObject.arraySJO[n].object;
            if (list.size() == 0 || list.get(0) == null) {
                return -1;
            }
            Class<?> clazz = list.get(0).getClass();
            Integer n3 = listBaseType.get(clazz);
            if (n3 != null) {
                for (Object e : list) {
                    if (e.getClass() == clazz) continue;
                    return -1;
                }
            }
            if (n3 == null) {
                return -1;
            }
            return n3;
        }
        if (ScilabJavaObject.arraySJO[n].object instanceof Buffer) {
            if (ScilabJavaObject.arraySJO[n].object instanceof DoubleBuffer) {
                unwrappableType.put(ScilabJavaObject.arraySJO[n].clazz, 3);
                return 3;
            }
            if (ScilabJavaObject.arraySJO[n].object instanceof ByteBuffer) {
                unwrappableType.put(ScilabJavaObject.arraySJO[n].clazz, 12);
                return 12;
            }
            if (ScilabJavaObject.arraySJO[n].object instanceof IntBuffer) {
                unwrappableType.put(ScilabJavaObject.arraySJO[n].clazz, 24);
                return 24;
            }
            if (ScilabJavaObject.arraySJO[n].object instanceof CharBuffer) {
                unwrappableType.put(ScilabJavaObject.arraySJO[n].clazz, 21);
                return 21;
            }
            if (ScilabJavaObject.arraySJO[n].object instanceof FloatBuffer) {
                unwrappableType.put(ScilabJavaObject.arraySJO[n].clazz, 36);
                return 36;
            }
            if (ScilabJavaObject.arraySJO[n].object instanceof LongBuffer) {
                unwrappableType.put(ScilabJavaObject.arraySJO[n].clazz, 30);
                return 30;
            }
            if (ScilabJavaObject.arraySJO[n].object instanceof ShortBuffer) {
                unwrappableType.put(ScilabJavaObject.arraySJO[n].clazz, 18);
                return 18;
            }
            return -1;
        }
        return -1;
    }

    static {
        currentCapacity = 1024;
        arraySJO = new ScilabJavaObject[currentCapacity];
        primTypes.put(Double.TYPE, Double.class);
        primTypes.put(Float.TYPE, Float.class);
        primTypes.put(Integer.TYPE, Integer.class);
        primTypes.put(Short.TYPE, Short.class);
        primTypes.put(Byte.TYPE, Byte.class);
        primTypes.put(Character.TYPE, Character.class);
        primTypes.put(Long.TYPE, Long.class);
        primTypes.put(Boolean.TYPE, Boolean.class);
        unwrappableType.put(Double.TYPE, 2);
        unwrappableType.put(double[].class, 3);
        unwrappableType.put(double[][].class, 4);
        unwrappableType.put(String.class, 5);
        unwrappableType.put(String[].class, 6);
        unwrappableType.put(String[][].class, 7);
        unwrappableType.put(Boolean.TYPE, 8);
        unwrappableType.put(boolean[].class, 9);
        unwrappableType.put(boolean[][].class, 10);
        unwrappableType.put(Byte.TYPE, 11);
        unwrappableType.put(byte[].class, 12);
        unwrappableType.put(byte[][].class, 13);
        unwrappableType.put(Short.TYPE, 17);
        unwrappableType.put(short[].class, 18);
        unwrappableType.put(short[][].class, 19);
        unwrappableType.put(Character.TYPE, 20);
        unwrappableType.put(char[].class, 21);
        unwrappableType.put(char[][].class, 22);
        unwrappableType.put(Integer.TYPE, 23);
        unwrappableType.put(int[].class, 24);
        unwrappableType.put(int[][].class, 25);
        unwrappableType.put(Long.TYPE, 29);
        unwrappableType.put(long[].class, 30);
        unwrappableType.put(long[][].class, 31);
        unwrappableType.put(Float.TYPE, 35);
        unwrappableType.put(float[].class, 36);
        unwrappableType.put(float[][].class, 37);
        unwrappableType.put(Double.class, 2);
        unwrappableType.put(Double[].class, 3);
        unwrappableType.put(Double[][].class, 4);
        unwrappableType.put(Integer.class, 23);
        unwrappableType.put(Integer[].class, 24);
        unwrappableType.put(Integer[][].class, 25);
        unwrappableType.put(Long.class, 29);
        unwrappableType.put(Long[].class, 30);
        unwrappableType.put(Long[][].class, 31);
        unwrappableType.put(Byte.class, 11);
        unwrappableType.put(Byte[].class, 12);
        unwrappableType.put(Byte[][].class, 13);
        unwrappableType.put(Character.class, 20);
        unwrappableType.put(Character[].class, 21);
        unwrappableType.put(Character[][].class, 22);
        unwrappableType.put(Boolean.class, 8);
        unwrappableType.put(Boolean[].class, 9);
        unwrappableType.put(Boolean[][].class, 10);
        unwrappableType.put(Float.class, 35);
        unwrappableType.put(Float[].class, 36);
        unwrappableType.put(Float[][].class, 37);
        unwrappableType.put(Short.class, 17);
        unwrappableType.put(Short[].class, 18);
        unwrappableType.put(Short[][].class, 19);
        listBaseType.put(Double.class, 3);
        listBaseType.put(Integer.class, 24);
        listBaseType.put(Long.class, 30);
        listBaseType.put(Byte.class, 12);
        listBaseType.put(Character.class, 21);
        listBaseType.put(Boolean.class, 9);
        listBaseType.put(Float.class, 36);
        listBaseType.put(Short.class, 18);
        listBaseType.put(String.class, 6);
        ScilabJavaObject.arraySJO[0] = new ScilabJavaObject(null, null);
    }

    private static final class FreePlace {
        int[] fp = new int[1024];
        int currentPos = -1;

        FreePlace() {
        }

        final void addFreePlace(int n) {
            if (this.currentPos == this.fp.length - 1) {
                int[] nArray = new int[(int)(1.5 * (double)this.fp.length)];
                System.arraycopy(this.fp, 0, nArray, 0, this.fp.length);
                this.fp = nArray;
            }
            this.fp[++this.currentPos] = n;
        }

        final int getFreePlace() {
            if (this.currentPos == -1) {
                return -1;
            }
            return this.fp[this.currentPos--];
        }

        final int[] getCurrentFreePlace() {
            if (this.currentPos == -1) {
                return null;
            }
            int[] nArray = new int[this.currentPos + 1];
            System.arraycopy(this.fp, 0, nArray, 0, nArray.length);
            return nArray;
        }
    }

    private static final class Poly {
        private final double[] coefs;

        public Poly(double[] dArray) {
            this.coefs = dArray;
        }
    }
}

