/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.history_browser;

import java.awt.MouseInfo;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.contextmenu.ContextMenu;
import org.scilab.modules.gui.contextmenu.ScilabContextMenu;
import org.scilab.modules.history_browser.CommandHistory;
import org.scilab.modules.history_browser.actions.ClearAction;
import org.scilab.modules.history_browser.actions.CopyAction;
import org.scilab.modules.history_browser.actions.CutAction;
import org.scilab.modules.history_browser.actions.DeleteAction;
import org.scilab.modules.history_browser.actions.EditInScinotesAction;
import org.scilab.modules.history_browser.actions.EvaluateAction;

public class CommandHistoryMouseListener
implements MouseListener {
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getClickCount() == 1 && SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isPopupTrigger() || CommandHistoryMouseListener.isMacOsPopupTrigger(mouseEvent)) && CommandHistory.getTree().getSelectionPath() != null) {
            this.displayContextMenu();
        }
        if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            EvaluateAction evaluateAction = new EvaluateAction();
            evaluateAction.callBack();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void displayContextMenu() {
        ContextMenu contextMenu = ScilabContextMenu.createContextMenu();
        contextMenu.add(CopyAction.createMenuItem());
        contextMenu.add(CutAction.createMenuItem());
        contextMenu.add(EvaluateAction.createMenuItem());
        contextMenu.add(EditInScinotesAction.createMenuItem());
        contextMenu.getAsSimpleContextMenu().addSeparator();
        contextMenu.add(DeleteAction.createMenuItem());
        contextMenu.add(ClearAction.createMenuItem());
        contextMenu.setVisible(true);
        ((SwingScilabContextMenu)contextMenu.getAsSimpleContextMenu()).setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
    }

    public static boolean isMacOsPopupTrigger(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isControlDown() && System.getProperty("os.name").toLowerCase().indexOf("mac") != -1 && (System.getProperty("java.specification.version").equals("1.5") || System.getProperty("java.specification.version").equals("1.6"));
    }
}

