/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.scilab.modules.helptools.TemplateFiller;
import org.scilab.modules.helptools.TemplateLocalization;

public class TemplateHandler {
    private String[] array;
    private TemplateFiller filler;
    private String language;

    public TemplateHandler(TemplateFiller templateFiller, File file, String string) {
        this.filler = templateFiller;
        this.language = string;
        this.parseFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFileFromTemplate(String string, String string2, String string3) {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
            for (int i = 0; i < this.array.length; i += 2) {
                outputStreamWriter.append(this.array[i]);
                String string4 = "";
                if (i + 1 >= this.array.length) continue;
                if (this.array[i + 1].equals("content")) {
                    string4 = string3;
                } else if (this.array[i + 1].equals("top")) {
                    string4 = this.filler.makeTop(string2);
                } else if (this.array[i + 1].equals("previous")) {
                    string4 = this.filler.makePrevious(string2);
                } else if (this.array[i + 1].equals("next")) {
                    string4 = this.filler.makeNext(string2);
                } else if (this.array[i + 1].equals("path")) {
                    string4 = this.filler.makePath(string2);
                } else if (this.array[i + 1].equals("title")) {
                    string4 = this.filler.makeTitle(string2);
                } else if (this.array[i + 1].equals("subtitle")) {
                    string4 = this.filler.makeSubtitle(string2);
                } else if (this.array[i + 1].equals("origin")) {
                    string4 = this.filler.makeOrigin(string2);
                } else if (this.array[i + 1].equals("toclist")) {
                    string4 = this.filler.makeTocList(string2);
                } else if (this.array[i + 1].equals("lastmodified")) {
                    string4 = this.filler.makeLastModified(string2);
                } else if (this.array[i + 1].equals("generationdate")) {
                    string4 = this.filler.makeGenerationDate(string2);
                } else if (this.array[i + 1].equals("version")) {
                    string4 = this.filler.makeVersion(string2);
                } else if (this.array[i + 1].equals("start")) {
                    string4 = this.filler.makeStart(string2);
                } else if (this.array[i + 1].startsWith("translate=")) {
                    String string5 = this.array[i + 1].substring("translate=".length());
                    string4 = TemplateLocalization.getLocalized(this.language, string5);
                }
                outputStreamWriter.append(string4);
            }
            outputStreamWriter.flush();
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }

    private void parseFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            this.array = stringBuilder.toString().split("(<!--<)|(>-->)");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

