/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.render.XMLHandler;
import org.scilab.forge.jlatexmath.fop.JLaTeXMathElementMapping;
import org.scilab.forge.jlatexmath.fop.JLaTeXMathXMLHandler;
import org.scilab.modules.commons.xml.ScilabTransformerFactory;
import org.scilab.modules.helptools.ContainerConverter;
import org.scilab.modules.helptools.Converter;
import org.scilab.modules.helptools.Helpers;
import org.scilab.modules.helptools.SciDocMain;
import org.xml.sax.SAXException;

public class FopConverter
extends ContainerConverter {
    final Converter.Backend format;

    public FopConverter(SciDocMain sciDocMain) {
        super(sciDocMain.getOutputDirectory(), sciDocMain.getLanguage());
        this.format = sciDocMain.getFormat();
    }

    @Override
    public void convert() throws SAXException, IOException {
        String string = Helpers.getBaseName(this.language);
        String string2 = this.outputDirectory + "/" + string + "." + this.format.name().toLowerCase();
        try {
            File file = new File(System.getenv("SCI") + "/modules/helptools/etc/fopconf.xml");
            FopFactory fopFactory = FopFactory.newInstance((File)file);
            fopFactory.addElementMapping((ElementMapping)new JLaTeXMathElementMapping());
            fopFactory.getXMLHandlerRegistry().addXMLHandler((XMLHandler)new JLaTeXMathXMLHandler());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            Fop fop = switch (this.format) {
                case Converter.Backend.PS -> fopFactory.newFop("application/postscript", (OutputStream)bufferedOutputStream);
                case Converter.Backend.PDF -> fopFactory.newFop("application/postscript", (OutputStream)bufferedOutputStream);
                default -> {
                    ((OutputStream)bufferedOutputStream).close();
                    throw new IOException(String.format("%s is not a supported format.%n", new Object[]{this.format}));
                }
            };
            String string3 = ScilabTransformerFactory.useDefaultTransformerFactoryImpl();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamSource streamSource = new StreamSource(new File(Helpers.getTemporaryNameFo(this.outputDirectory)));
            SAXResult sAXResult = new SAXResult(fop.getDefaultHandler());
            transformer.transform(streamSource, sAXResult);
            ScilabTransformerFactory.restoreTransformerFactoryImpl((String)string3);
            FormattingResults formattingResults = fop.getResults();
            System.out.println("Generated " + formattingResults.getPageCount() + " pages in total.");
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (FOPException fOPException) {
            System.out.println(fOPException.getLocalizedMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getLocalizedMessage());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println(transformerConfigurationException.getLocalizedMessage());
        }
        catch (TransformerException transformerException) {
            System.out.println(transformerException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException.getLocalizedMessage());
        }
    }

    @Override
    public void install() throws IOException {
    }
}

